/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.core.util;

import java.awt.Font;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.report.navigatorV2.ReportXMLUtil;
import oracle.dbtools.raptor.report.navigatorV2.RootNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public abstract class MigrationUtils {
    private static Format s_oraDATEFormat = null;

    private MigrationUtils() {
    }

    public static String removeSingleQuotes(String toRemove) {
        return MigrationUtils.removeQuotes(toRemove, '\'');
    }

    private static String removeQuotes(String toRemove, char quote) {
        String quoteCharAsString = "" + quote;
        if (toRemove.startsWith(quoteCharAsString) && toRemove.endsWith(quoteCharAsString)) {
            return toRemove.substring(1, toRemove.length() - 1);
        }
        return toRemove;
    }

    public static String formatNLSDate(Date date) {
        Format formater = MigrationUtils.getDateFormat();
        return formater.format(date);
    }

    private static Format getDateFormat() {
        if (s_oraDATEFormat != null) {
            return s_oraDATEFormat;
        }
        PersistenceManager pman = MigrationAddin.getPersistenceManager();
        if (pman != null) {
            Connection conn = pman.getConn();
            s_oraDATEFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)conn)).getOraDATEFormat();
        }
        return s_oraDATEFormat == null ? DateFormat.getInstance() : s_oraDATEFormat;
    }

    public static void resetDateFormatter() {
        s_oraDATEFormat = null;
    }

    public static void addReports(URL url) {
        ReportXMLUtil util = new ReportXMLUtil();
        try {
            RootNode node = RootNode.getInstance();
            InputStreamReader in = new InputStreamReader(url.openStream());
            util.parseXML((DefaultContainer)node, in, true);
            Iterator iter = node.getChildren();
            while (iter.hasNext()) {
                UpdateMessage.fireChildAdded((Subject)node, (Element)((Node)iter.next()));
            }
        }
        catch (IOException e) {
            Logger.getLogger(MigrationUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public static DataTypeSpecification getDataTypeSpecifcation(MdColumn col) {
        DataTypeSpecification spec = new DataTypeSpecification(col.getColumnType(), col.getPrecision(), col.getScale());
        return spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findCheckConstraintCondition(MdConstraint constraint, PersistenceManager pman) throws PersistenceException {
        String sRet;
        ClobHelper clob = constraint.getConstraintText();
        CloseableIterator constraintDetails = null;
        try {
            sRet = ConvertUtils.getClobAsString(clob);
            if (sRet != null && sRet.trim().length() > 0) {
                String string = sRet;
                return string;
            }
            PersistenceUtility util = PersistenceUtility.getInstance(pman);
            constraintDetails = util.getConstraintDetails(constraint.getKey());
            if (constraintDetails.hasNext()) {
                MdConstraintDetail detail = (MdConstraintDetail)constraintDetails.next();
                clob = detail.getConstraintText();
                sRet = ConvertUtils.getClobAsString(clob);
            }
        }
        catch (IOException ioe) {
            sRet = null;
        }
        finally {
            if (constraintDetails != null) {
                constraintDetails.close();
            }
        }
        return sRet;
    }

    private static STRUCT MigrationObjectFilterAsSTRUCT(MigrationObjectFilter filter, Connection connection) throws SQLException {
        Object[] objAr = new Object[]{filter.getFilterType(), filter.getObjectType(), null, null, null};
        if (filter.getFilterType() == 1) {
            objAr[3] = filter.getObjectNames();
        } else if (filter.getFilterType() == 2) {
            objAr[4] = filter.getWhereClause();
        } else if (filter.getFilterType() == 3) {
            DBObjectId[] ids = filter.getObjectIds();
            Long[] longObjs = new Long[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                longObjs[i] = ids[i].getId();
            }
            objAr[2] = longObjs;
        }
        StructDescriptor desc = StructDescriptor.createDescriptor((String)"MIGR_FILTER", (Connection)connection);
        STRUCT ret = new STRUCT(desc, connection, objAr);
        return ret;
    }

    public static ARRAY migrationFilterListAsARRAY(MigrationObjectFilterList filterList, Connection connection) throws SQLException {
        if (filterList == null) {
            return null;
        }
        MigrationObjectFilter[] filters = filterList.getFilters();
        Object[] contents = new Object[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            contents[i] = MigrationUtils.MigrationObjectFilterAsSTRUCT(filters[i], connection);
        }
        ArrayDescriptor desc = ArrayDescriptor.createDescriptor((String)"MIGR_FILTER_SET", (Connection)connection);
        ARRAY ret = new ARRAY(desc, connection, (Object)contents);
        return ret;
    }

    public static String initCap(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        boolean capitalize = true;
        char[] data = in.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == ' ' || Character.isWhitespace(data[i])) {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                data[i] = Character.toUpperCase(data[i]);
                capitalize = false;
                continue;
            }
            data[i] = Character.toLowerCase(data[i]);
        }
        return new String(data);
    }

    public static MigrationPlugin getPluginForConnection(MdConnection mdConnection) throws MigrationPluginException {
        String sPluginId = MigrationUtils.getPluginIdForConnection(mdConnection);
        if (sPluginId == null) {
            throw new MigrationPluginException(new Throwable("No plugin saved for connection " + mdConnection.getKey().toString()));
        }
        MigrationPlugin plugin = MigrationAddin.findPlugin(sPluginId);
        if (plugin == null) {
            throw new MigrationPluginException(new Throwable(sPluginId + " no longer available"));
        }
        return plugin;
    }

    public static String getPluginIdForConnection(MdConnection mdConnection) {
        return mdConnection.getProperty("PLUGIN_ID");
    }

    public static MdConnection getMdConnection(Context ctx) {
        ArrayList<MdConnection> conns = new ArrayList<MdConnection>();
        Element[] elements = ctx.getSelection();
        if (elements == null || elements.length == 0) {
            DBObject dbo = (DBObject)ctx.getProperty("ObjectAction.DBOBJECT");
            if (dbo != null) {
                MdConnection conn = MigrationUtils.getConnforDBObject(dbo);
                conns.add(conn);
            }
        } else {
            for (int i = 0; i < elements.length; ++i) {
                MdConnection conn = MigrationUtils.getConnforElement(elements[i]);
                conns.add(conn);
            }
        }
        if (conns.size() > 0) {
            return (MdConnection)conns.get(0);
        }
        return null;
    }

    public static MdConnection getConnforDBObject(DBObject dbObject) {
        MdConnection mdConnection = null;
        if (dbObject.getElement() instanceof MigrationConnectionNode) {
            MigrationConnectionNode capDb = (MigrationConnectionNode)dbObject.getElement();
            mdConnection = capDb.getMdConnection();
        } else if (dbObject.getElement() instanceof DatabaseElement) {
            Element element = dbObject.getElement();
            DBObjectId s = MigrationURLFormatHelper.getSchemaId(((DatabaseElement)element).getURL());
            try {
                MdSchema schema = MdSchema.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), s);
                MdCatalog catalog = MdCatalog.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), schema.getCatalogId());
                mdConnection = MdConnection.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), catalog.getConnectionId());
            }
            catch (PersistenceException e) {
                Logger.getLogger(MigrationUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (NoSuchObjectException e) {
                Logger.getLogger(MigrationUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return mdConnection;
    }

    public static MdConnection getConnforElement(Element element) {
        MdConnection connection = null;
        if (element instanceof DatabaseElement) {
            URL url = ((DatabaseElement)element).getURL();
            DBObjectId id = MigrationURLFormatHelper.getSchemaId(url);
            try {
                MdSchema schema = MdSchema.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), id);
                MdCatalog catalog = MdCatalog.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), schema.getCatalogId());
                connection = MdConnection.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), catalog.getConnectionId());
            }
            catch (PersistenceException e) {
                Logger.getLogger(MigrationUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (NoSuchObjectException e) {
                Logger.getLogger(MigrationUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            return connection;
        }
        if (element instanceof MigrationConnectionNode) {
            connection = ((MigrationConnectionNode)element).getMdConnection();
        }
        return connection;
    }

    public static boolean catalogIsDummy(MdCatalog catalog) {
        if (catalog == null) {
            return false;
        }
        String dummyFlag = catalog.getDummyFlag();
        if (dummyFlag == null) {
            return false;
        }
        return dummyFlag.equals("Y");
    }

    public static String mapSDToSDMWType(String sqlDevType) {
        if (sqlDevType.equalsIgnoreCase("MD_PROCEDURE")) {
            return "MD_STORED_PROGRAMS";
        }
        return null;
    }

    public static String fontToCSSString(Font f) {
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("font:");
        if (f.isBold()) {
            sBuf.append(" bold");
        }
        if (f.isItalic()) {
            sBuf.append(" italic");
        }
        sBuf.append(" " + f.getSize() + "pt");
        sBuf.append(" " + f.getFamily());
        return sBuf.toString();
    }
}

