/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.core.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

public class MultiLevelLogManager {
    private static Logger s_logger = Logger.getLogger("oracle.dbtools.migration");
    private static ResourceBundle s_bundle = s_logger.getResourceBundle();
    private Hashtable<Object, ArrayList<LogPoint>> m_currentObjects = new Hashtable();

    public void logMessage(Object parent, Level level, String msg, Object[] args) {
        ArrayList<Object> children;
        if (this.m_currentObjects.containsKey(parent)) {
            children = this.m_currentObjects.get(parent);
        } else {
            children = new ArrayList();
            this.m_currentObjects.put(parent, children);
        }
        children.add(new LogPoint(level, msg, args));
    }

    public void commitLog(Level level, Object parent, String parentHeading, PersistableObject clickable) {
        if (!this.m_currentObjects.containsKey(parent)) {
            return;
        }
        ArrayList<LogPoint> children = this.m_currentObjects.remove(parent);
        if (children.size() == 0) {
            return;
        }
        ClickableLogInfo cli = null;
        if (clickable != null) {
            cli = new ClickableLogInfo(clickable);
        }
        if (children.size() == 1) {
            s_logger.log(MultiLevelLogManager.toLogRecord(children.get(0), cli));
        } else {
            LogInfo childLogs = new LogInfo("");
            for (LogPoint lp : children) {
                childLogs.addChild(MultiLevelLogManager.toLogRecord(lp, cli));
            }
            s_logger.log(level, parentHeading, childLogs);
        }
    }

    private static LogRecord toLogRecord(LogPoint lp, LogInfo cli) {
        String msg = MessageFormat.format(s_bundle.getString(lp.getMessage()), lp.getArgs());
        LogRecord ret = new LogRecord(lp.getLevel(), msg);
        ret.setLoggerName(s_logger.getName());
        if (cli != null) {
            ret.setParameters(new Object[]{cli});
        } else {
            List<LogInfo> logInfo = MigrationLogUtil.searchParameterByType(lp.getArgs(), LogInfo.class);
            ret.setParameters(logInfo.toArray());
        }
        return ret;
    }

    private static class LogPoint {
        Level m_level;
        String m_message;
        Object[] m_args;

        public LogPoint(Level level, String message, Object[] args) {
            this.setLevel(level);
            this.setMessage(message);
            this.setArgs(args);
        }

        public Object[] getArgs() {
            return this.m_args;
        }

        private void setArgs(Object[] args) {
            this.m_args = args;
        }

        public Level getLevel() {
            return this.m_level;
        }

        private void setLevel(Level level) {
            this.m_level = level;
        }

        public String getMessage() {
            return this.m_message;
        }

        private void setMessage(String message) {
            this.m_message = message;
        }
    }
}

