/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove;

import java.util.Collection;
import java.util.LinkedHashMap;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMoveDescriptor {
    private MdSchema m_sourceSchema;
    private MdTable m_srcTable;
    private MdSchema m_targetSchema;
    private MdTable m_targetTable;
    private String m_srcDB;
    private LinkedHashMap<MdColumn, MdColumn> m_columnMap;

    public DataMoveDescriptor(MdSchema sourceSchema, MdTable sourceTable, MdSchema targetSchema, MdTable targetTable) {
        this.setSourceSchema(sourceSchema);
        this.setSourceTable(sourceTable);
        this.setTargetTable(targetTable);
        this.setTargetSchema(targetSchema);
        this.m_columnMap = new LinkedHashMap();
    }

    public void setTargetTable(MdTable targetTable) {
        this.m_targetTable = targetTable;
    }

    public MdTable getTargetTable() {
        return this.m_targetTable;
    }

    public String getTargetTableName(boolean qualified) {
        if (qualified) {
            return this.getTargetQualifiedTableName();
        }
        return this.getTargetUnqualifiedTableName();
    }

    public void setSourceTable(MdTable sourceTable) {
        this.m_srcTable = sourceTable;
    }

    public String getSourceTableName() {
        if (this.m_srcTable.getQualifiedNativeName() != null) {
            return this.m_srcTable.getQualifiedNativeName();
        }
        return this.m_srcTable.getTableName();
    }

    private String getTargetQualifiedTableName() {
        return this.m_targetSchema.getName() + "." + this.getTargetUnqualifiedTableName();
    }

    private String getTargetUnqualifiedTableName() {
        return this.m_targetTable.getTableName();
    }

    public void setSourceDatabaseName(String dbName) {
        this.m_srcDB = dbName;
    }

    public String getSourceDatabaseName() {
        return this.m_srcDB;
    }

    public void addColumnMap(MdColumn sourceColumn, MdColumn targetColumn) {
        this.m_columnMap.put(targetColumn, sourceColumn);
    }

    public void setColumnMap(LinkedHashMap<MdColumn, MdColumn> columnMap) {
        this.m_columnMap = columnMap;
    }

    public MdColumn[] getSourceColumns() {
        Collection<MdColumn> s = this.m_columnMap.values();
        return s.toArray(new MdColumn[s.size()]);
    }

    public String[] getSourceColumnNames() {
        MdColumn[] cols = this.getSourceColumns();
        String[] ret = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            ret[i] = cols[i].getColumnName();
        }
        return ret;
    }

    public MdColumn[] getTargetColumns() {
        MdColumn[] ret = this.m_columnMap.keySet().toArray(new MdColumn[this.m_columnMap.size()]);
        return ret;
    }

    public String[] getTargetColumnNames() {
        MdColumn[] targetCols = this.getTargetColumns();
        String[] ret = new String[targetCols.length];
        for (int i = 0; i < targetCols.length; ++i) {
            ret[i] = targetCols[i].getColumnName();
        }
        return ret;
    }

    public String getOriginalColumnName(String name) {
        MdColumn[] targetCols;
        for (MdColumn col : targetCols = this.getTargetColumns()) {
            if (!col.getColumnName().equals(name)) continue;
            MdColumn srcCol = this.m_columnMap.get(col);
            return srcCol.getColumnName();
        }
        return null;
    }

    public MdColumn getSourceColumnByName(String name) {
        for (MdColumn col : this.m_columnMap.values()) {
            if (!col.getColumnName().equals(name)) continue;
            return col;
        }
        return null;
    }

    protected void setTargetSchema(MdSchema targetSchema) {
        this.m_targetSchema = targetSchema;
    }

    protected void setSourceSchema(MdSchema sourceSchema) {
        this.m_sourceSchema = sourceSchema;
    }

    public MdTable getSourceTable() {
        return this.m_srcTable;
    }

    public MdSchema getSourceSchema() {
        return this.m_sourceSchema;
    }
}

