/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataMoveUtils {
    private static final String QUERY_LOAD_DESCRIPTOR = "SELECT DERIVED_TYPE, DERIVED_ID, SRC_ID FROM MD_DERIVATIVES WHERE (DERIVED_TYPE = 'MD_TABLES' OR DERIVED_TYPE = 'MD_COLUMNS') AND DERIVED_TYPE = SRC_TYPE AND DERIVED_CONNECTION_ID_FK = ? AND (DERIVED_ID IN (SELECT ID FROM MD_COLUMNS WHERE TABLE_ID_FK = ?) OR DERIVED_ID = ?)";
    private static final String GET_DERIVED_NAMES_QUERY = "SELECT ORIGINAL_IDENTIFIER, NEW_IDENTIFIER FROM MD_DERIVATIVES WHERE DERIVED_TYPE = 'MD_COLUMNS' AND SRC_TYPE = 'MD_COLUMNS' AND DERIVED_CONNECTION_ID_FK = ? AND DERIVED_ID IN (SELECT ID FROM MD_COLUMNS WHERE TABLE_ID_FK = ?)";
    private static final String FIND_PLUGIN_QUERY = "SELECT VALUE FROM MD_ADDITIONAL_PROPERTIES WHERE PROP_KEY = 'PLUGIN_ID' AND CONNECTION_ID_FK = REF_ID_FK AND CONNECTION_ID_FK IN  (SELECT SRC_ID FROM MD_DERIVATIVES WHERE DERIVED_ID = ?   AND SRC_TYPE = 'MD_CONNECTIONS' AND DERIVED_TYPE = 'MD_CONNECTIONS')";

    private DataMoveUtils() {
    }

    public static LinkedHashMap<String, String> getMappedColumnNames(PersistenceManager pman, DBObjectId derivedConnectionId, DBObjectId derivedTableId) throws PersistenceException {
        CloseableResultSet crs = null;
        try {
            PreparedStatement stmt = pman.getPreparedStatement(GET_DERIVED_NAMES_QUERY);
            stmt.setLong(1, derivedConnectionId.getId());
            stmt.setLong(2, derivedTableId.getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
            while (rs.next()) {
                String orig = rs.getString(1);
                String newid = rs.getString(2);
                ret.put(newid, orig);
            }
            crs.close();
            LinkedHashMap<String, String> linkedHashMap = ret;
            Object var10_10 = null;
            if (crs != null) {
                crs.close();
            }
            return linkedHashMap;
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                block6: {
                    Object var10_11 = null;
                    if (crs == null) break block6;
                    crs.close();
                }
                throw throwable;
            }
        }
    }

    public static Hashtable<String, Integer> getColumnTypes(String tableName, Connection conn) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from ");
        sql.append(tableName);
        sql.append(" where 1=0");
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql.toString());
        ResultSetMetaData rsmd = rs.getMetaData();
        Hashtable<String, Integer> ret = new Hashtable<String, Integer>();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            ret.put(rsmd.getColumnName(i).toUpperCase(), rsmd.getColumnType(i));
        }
        try {
            rs.close();
        }
        catch (SQLException sqlex) {
            // empty catch block
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MigrationPlugin findPluginUsed(DBObjectId convertedConnectionId, PersistenceManager pman) {
        CloseableResultSet crs = null;
        String sPluginId = null;
        try {
            try {
                PreparedStatement stmt = pman.getPreparedStatement(FIND_PLUGIN_QUERY);
                stmt.setLong(1, convertedConnectionId.getId());
                ResultSet rs = stmt.executeQuery();
                crs = new CloseableResultSet(null, rs);
                rs.next();
                sPluginId = rs.getString(1);
            }
            catch (SQLException sqlex) {
                MigrationLogUtil.logThrowable("Error retrieving plugin information", "Data Move", (Throwable)sqlex);
                MigrationPlugin migrationPlugin = null;
                Object var8_8 = null;
                if (crs != null) {
                    crs.close();
                }
                return migrationPlugin;
            }
            Object var8_7 = null;
            if (crs != null) {
                crs.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (crs != null) {
                crs.close();
            }
            throw throwable;
        }
        if (sPluginId == null) {
            Logger.getLogger("oracle.dbtools.migration").severe("No plugin information available");
            return null;
        }
        MigrationPlugin plugin = MigrationAddin.findPlugin(sPluginId);
        if (plugin == null) {
            Logger.getLogger("oracle.dbtools.migration").severe("Plugin no longer available");
            return null;
        }
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataMoveDescriptor loadDescriptor(PersistenceManager pman, DBObjectId tableId, DBObjectId connectionId) throws PersistenceException {
        CloseableResultSet crs = null;
        MdTable sourceTable = null;
        MdTable targetTable = null;
        MdSchema sourceSchema = null;
        MdSchema targetSchema = null;
        DataMoveDescriptor descriptor = null;
        try {
            try {
                PreparedStatement stmt = pman.getPreparedStatement(QUERY_LOAD_DESCRIPTOR);
                stmt.setLong(1, connectionId.getId());
                stmt.setLong(2, tableId.getId());
                stmt.setLong(3, tableId.getId());
                ResultSet rs = stmt.executeQuery();
                LinkedHashMap<MdColumn, MdColumn> columnNameMap = new LinkedHashMap<MdColumn, MdColumn>();
                crs = new CloseableResultSet(null, rs);
                while (rs.next()) {
                    String type = rs.getString(1);
                    Long derivedId = rs.getLong(2);
                    Long srcId = rs.getLong(3);
                    if (type.equals("MD_TABLES")) {
                        try {
                            sourceTable = MdTable.retrieveExistingInstance(pman, new DBObjectId(srcId));
                            sourceSchema = MdSchema.retrieveExistingInstance(pman, sourceTable.getSchemaId());
                            targetTable = MdTable.retrieveExistingInstance(pman, new DBObjectId(derivedId));
                            targetSchema = MdSchema.retrieveExistingInstance(pman, targetTable.getSchemaId());
                        }
                        catch (NoSuchObjectException nsoe) {
                            MigrationLogUtil.logThrowable(nsoe.getLocalizedMessage(), "Data Move", (Throwable)nsoe);
                        }
                        continue;
                    }
                    if (!type.equals("MD_COLUMNS")) continue;
                    try {
                        columnNameMap.put(MdColumn.retrieveExistingInstance(pman, new DBObjectId(derivedId)), MdColumn.retrieveExistingInstance(pman, new DBObjectId(srcId)));
                    }
                    catch (NoSuchObjectException e) {
                        MigrationLogUtil.logThrowable(e.getLocalizedMessage(), "Data Move", (Throwable)e);
                    }
                }
                if (sourceTable == null || sourceSchema == null || targetTable == null || targetTable == null || columnNameMap == null || columnNameMap.size() == 0) {
                    throw new IllegalStateException("derived records not found");
                }
                descriptor = new DataMoveDescriptor(sourceSchema, sourceTable, targetSchema, targetTable);
                descriptor.setColumnMap(columnNameMap);
            }
            catch (SQLException sex) {
                MigrationLogUtil.logThrowable(sex.getLocalizedMessage(), "Data Move", (Throwable)sex);
                Object var17_20 = null;
                if (crs != null) {
                    crs.close();
                }
            }
            Object var17_19 = null;
            if (crs != null) {
                crs.close();
            }
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            if (crs != null) {
                crs.close();
            }
            throw throwable;
        }
        return descriptor;
    }
}

