/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.offline.OfflineDatamoveOutputStream;

public class ClobToBlobHandler {
    private PersistenceManager m_persistenceManager = null;
    private DBObjectId m_connectionId = null;
    private static final String QUERY_FIND_BLOBS = "SELECT A.SCHEMA_NAME, A.TABLE_NAME, B.COLUMN_NAME, B.COLUMN_ORDER, B.NULLABLE FROM MGV_ALL_TABLES A, MD_COLUMNS B WHERE UPPER(B.COLUMN_TYPE) = 'BLOB' AND A.TABLE_ID = B.TABLE_ID_FK AND A.CONNECTION_ID = ? ORDER BY A.SCHEMA_NAME, A.TABLE_NAME, B.COLUMN_ORDER ";

    public ClobToBlobHandler(DBObjectId connectionId, PersistenceManager pman) {
        this.m_persistenceManager = pman;
        this.m_connectionId = connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAddAndModify(OfflineDatamoveOutputStream output, boolean qualified) {
        try {
            if (output == null) {
                throw new IllegalArgumentException("output cannot be null");
            }
            CloseableResultSet crs = null;
            try {
                PreparedStatement stmt = this.m_persistenceManager.getPreparedStatement(QUERY_FIND_BLOBS);
                stmt.setLong(1, this.m_connectionId.getId());
                ResultSet rs = stmt.executeQuery();
                crs = new CloseableResultSet(null, rs);
                while (rs.next()) {
                    String schemaName = rs.getString(1);
                    String tableName = rs.getString(2);
                    String columnName = rs.getString(3);
                    int columnOrder = rs.getInt(4);
                    String nullable = rs.getString(5);
                    if (qualified) {
                        output.println("ALTER TABLE " + schemaName + "." + tableName + " add (SQLDEVELOPER_CLOB_" + columnOrder + " CLOB);");
                        if (!nullable.equals("N")) continue;
                        output.println("ALTER TABLE " + schemaName + "." + tableName + " MODIFY " + columnName + " NULL;");
                        continue;
                    }
                    output.println("ALTER TABLE " + tableName + " add (SQLDEVELOPER_CLOB_" + columnOrder + " CLOB);");
                    if (!nullable.equals("N")) continue;
                    output.println("ALTER TABLE " + tableName + " MODIFY " + columnName + " NULL;");
                }
                Object var12_12 = null;
                if (crs != null) {
                    crs.close();
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (crs != null) {
                    crs.close();
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.SEVERE, "DataMove.FAILED_TO_WRITE_TO_OFFLINE_FILE", e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProcedureCallAndNotNull(OfflineDatamoveOutputStream output, boolean qualified) {
        try {
            if (output == null) {
                throw new IllegalArgumentException("output cannot be null");
            }
            CloseableResultSet crs = null;
            try {
                PreparedStatement stmt = this.m_persistenceManager.getPreparedStatement(QUERY_FIND_BLOBS);
                stmt.setLong(1, this.m_connectionId.getId());
                ResultSet rs = stmt.executeQuery();
                crs = new CloseableResultSet(null, rs);
                while (rs.next()) {
                    String schemaName = rs.getString(1);
                    String tableName = rs.getString(2);
                    String columnName = rs.getString(3);
                    int columnOrder = rs.getInt(4);
                    String nullable = rs.getString(5);
                    if (qualified) {
                        output.println("BEGIN " + schemaName + ".CLOBTOBLOB_sqldeveloper('" + tableName + "', 'SQLDEVELOPER_CLOB_" + columnOrder + "', '" + columnName + "'); END;");
                        output.println("/");
                        if (!nullable.equals("N")) continue;
                        output.println("ALTER TABLE " + schemaName + "." + tableName + " MODIFY " + columnName + " NOT NULL;");
                        continue;
                    }
                    output.println("BEGIN CLOBTOBLOB_sqldeveloper('" + tableName + "', 'SQLDEVELOPER_CLOB_" + columnOrder + "', '" + columnName + "'); END;");
                    output.println("/");
                    if (!nullable.equals("N")) continue;
                    output.println("ALTER TABLE " + tableName + " MODIFY " + columnName + " NOT NULL;");
                }
                Object var12_12 = null;
                if (crs != null) {
                    crs.close();
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (crs != null) {
                    crs.close();
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.SEVERE, "DataMove.FAILED_TO_WRITE_TO_OFFLINE_FILE", e.getLocalizedMessage());
        }
    }
}

