/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.datamove.offline.OfflineDataMoveWorker;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveListener;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.AbstractCommonMigrationProgressRunnable;

public class OfflineDataMoveRunner
extends AbstractCommonMigrationProgressRunnable
implements DataMoveListener {
    private OfflineDataMoveWorker m_offlineDataMoveWorker;
    private static String[] s_header = new String[]{"Object", "Type", "Count"};
    private int count = 0;
    private int sqlcount = 0;
    private int scriptcount = 0;

    public OfflineDataMoveRunner(OfflineDataMoveWorker odmw) {
        this.m_offlineDataMoveWorker = odmw;
        this.m_offlineDataMoveWorker.addListener(this);
        this.setTitle(MigrationAddinArb.getString(171));
        this.setMessage(MigrationAddinArb.getString(172));
        this._jTableModel.setColumnIdentifiers(s_header);
        this.setupTable();
    }

    private void setupTable() {
        Object[] thirdPty = new Object[]{"", 1, "0"};
        Object[] sqlLdr = new Object[]{"", 2, "0"};
        Object[] script = new Object[]{"", 3, "0"};
        this._jTableModel.addRow(thirdPty);
        this._jTableModel.addRow(sqlLdr);
        this._jTableModel.addRow(script);
        this._jTableModel.fireTableDataChanged();
    }

    public String[] getColumnNames() {
        return s_header;
    }

    public String getEventString(Object event) {
        DataMoveEvent ode = (DataMoveEvent)event;
        if (ode == null) {
            return null;
        }
        return "Writing" + ode.getSource();
    }

    public void setTableCellRenderer() {
    }

    protected Object doWork() throws Exception {
        try {
            this.m_offlineDataMoveWorker.doWork();
            return Boolean.TRUE;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return Boolean.FALSE;
        }
    }

    public void raiseEvent(DataMoveEvent event) {
        String state = (String)event.getSupplementaryData();
        switch (event.getEventId()) {
            case 1: {
                this.createOrUpdateRow(event.getSource().toString(), "3rd Party Script", this.count++, state);
                break;
            }
            case 2: {
                this.createOrUpdateRow(event.getSource().toString(), "SQL Loader Script", this.sqlcount++, state);
                break;
            }
            case 3: {
                this.createOrUpdateRow(event.getSource().toString(), "Control Script", this.scriptcount++, state);
                break;
            }
        }
        this._jTableModel.fireTableDataChanged();
        this.updateProgress(1, null, "Tables completed:" + this.count);
    }

    private void createOrUpdateRow(String sourceTable, String type, int count, String state) {
        boolean found = false;
        Object[] o = new Object[]{sourceTable, type, state};
        for (int i = 0; i < this._jTableModel.getRowCount(); ++i) {
            if (this._jTableModel.getValueAt(i, 2) == null || !this._jTableModel.getValueAt(i, 2).toString().equals(type)) continue;
            this._jTableModel.removeRow(i);
            found = true;
        }
        if (!found) {
            this._jTableModel.addRow(o);
        }
        this._jTableModel.fireTableDataChanged();
    }

    public void setToolTip() {
    }
}

