/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MgvAllTablesRec;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.datamove.DataMoveException;
import oracle.dbtools.migration.datamove.DataMoveMarshal;
import oracle.dbtools.migration.datamove.DataMoveUtils;
import oracle.dbtools.migration.datamove.offline.ClobToBlobHandler;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.datamove.offline.OfflineSQLLoaderGenerator;
import oracle.dbtools.migration.datamove.offline.OfflineSQLLoaderPrintStream;
import oracle.dbtools.migration.datamove.online.ConstraintHandler;
import oracle.dbtools.migration.datamove.online.DataMoveAudience;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveListener;
import oracle.dbtools.migration.datamove.online.TriggerHandler;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;

public class OfflineDataMoveWorker
implements Cancelable,
DataMoveMarshal {
    private static Logger s_log = Logger.getLogger("oracle.dbtools.migration");
    public static final String MY_ID = "OfflineDataMoveWorker";
    private CloseableIterator<MgvAllTablesRec> m_tables;
    private PersistenceManager m_persistenceManager;
    private PersistenceUtility m_persistenceUtility;
    private DBObjectId m_targetConnectionId;
    private DataMoveAudience m_audience;
    private MdConnection m_mdConnection;
    private Offline3rdPartyPrintStream thirdPartyPrintStream;
    private OfflineSQLLoaderPrintStream sqlloaderPrintStream;

    public OfflineDataMoveWorker(PersistenceManager pman, MdConnection connection, String genPath, Offline3rdPartyPrintStream thirdPartyPrintStream, OfflineSQLLoaderPrintStream sqlLoaderPrintStream) throws DataMoveException {
        this.setPersistenceManager(pman);
        this.setPersistenceUtility(PersistenceUtility.getInstance(pman));
        this.setTargetConnectionId(connection.getKey());
        this.setTargetConnection(connection);
        this.sqlloaderPrintStream = sqlLoaderPrintStream;
        this.thirdPartyPrintStream = thirdPartyPrintStream;
        this.m_audience = new DataMoveAudience();
    }

    private void setTargetConnection(MdConnection connection) {
        this.m_mdConnection = connection;
    }

    public void addListener(DataMoveListener listener) {
        this.m_audience.addListener(listener);
    }

    private void setTargetConnectionId(DBObjectId targetConnectionId) {
        this.m_targetConnectionId = targetConnectionId;
    }

    private void setPersistenceManager(PersistenceManager pman) {
        this.m_persistenceManager = pman;
    }

    public void doWork() throws PersistenceException {
        MigrationPlugin plugin;
        this.m_tables = this.getPersistenceUtility().getTablesForConnectionId(this.m_targetConnectionId);
        OfflineDataMoveWorker m_marshal = this;
        DataMoveDescriptor m_descriptor = m_marshal.getDescriptor();
        DataMoveEvent dme = new DataMoveEvent(3, "Offline Generation", "SUCCESS");
        this.m_audience.fireListeners(dme);
        try {
            plugin = MigrationUtils.getPluginForConnection(this.m_mdConnection);
        }
        catch (MigrationPluginException e) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(285), (String)MigrationAddinArb.getString(286), (String)"f1_offlineDatamovePluginFound_html");
            return;
        }
        if (plugin.doIReturnUnloadScripts()) {
            this.thirdPartyPrintStream.startDatabase();
        }
        this.sqlloaderPrintStream.startDatabase();
        ConstraintHandler constraintHandler = new ConstraintHandler(this.m_mdConnection.getKey(), this.m_persistenceManager);
        TriggerHandler triggerHandler = new TriggerHandler(this.m_mdConnection.getKey(), this.m_persistenceManager);
        ClobToBlobHandler clobToBlobHandler = new ClobToBlobHandler(this.m_mdConnection.getKey(), this.m_persistenceManager);
        this.sqlloaderPrintStream.println("WHENEVER SQLERROR CONTINUE;");
        constraintHandler.disableConstraints(this.sqlloaderPrintStream, true);
        triggerHandler.disableTriggers(this.sqlloaderPrintStream, true);
        if (plugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob()) {
            clobToBlobHandler.writeAddAndModify(this.sqlloaderPrintStream, true);
        }
        this.sqlloaderPrintStream.endTable();
        OfflineSQLLoaderGenerator sqlloadGenerator = new OfflineSQLLoaderGenerator();
        while (m_descriptor != null) {
            String srcTable = m_descriptor.getSourceTableName();
            MdColumn[] srcTableCols = m_descriptor.getSourceColumns();
            MdColumn[] tgtTableCols = m_descriptor.getTargetColumns();
            Arrays.sort(srcTableCols, new MdColumnComparator());
            Arrays.sort(tgtTableCols, new MdColumnComparator());
            String targetTable = m_descriptor.getTargetTableName(true);
            boolean thirdPartyFlag = true;
            if (plugin.doIReturnUnloadScripts()) {
                thirdPartyFlag = plugin.getDataExportCommmand(srcTable, srcTableCols, this.thirdPartyPrintStream);
            }
            dme = new DataMoveEvent(1, srcTable, thirdPartyFlag ? "SUCCESS" : "FAILURE");
            this.m_audience.fireListeners(dme);
            boolean sqlloaderFlag = sqlloadGenerator.generateCtl(srcTable, targetTable, srcTableCols, tgtTableCols, this.sqlloaderPrintStream, plugin);
            dme = new DataMoveEvent(2, srcTable, sqlloaderFlag);
            m_descriptor = m_marshal.getDescriptor();
        }
        this.sqlloaderPrintStream.openEnableSQLFile();
        if (plugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob()) {
            clobToBlobHandler.writeProcedureCallAndNotNull(this.sqlloaderPrintStream, true);
        }
        this.sqlloaderPrintStream.println("WHENEVER SQLERROR CONTINUE;");
        constraintHandler.reenableConstraints(this.sqlloaderPrintStream, true);
        triggerHandler.enableTriggers(this.sqlloaderPrintStream, true);
        this.sqlloaderPrintStream.endTable();
        if (plugin.doIReturnUnloadScripts()) {
            this.thirdPartyPrintStream.endDatabase();
        }
        this.sqlloaderPrintStream.endDatabase();
        boolean scriptFlag = sqlloadGenerator.generateScriptCtl(this.sqlloaderPrintStream.m_createdFiles, this.sqlloaderPrintStream, false);
        this.sqlloaderPrintStream.winPrintstream();
        if (scriptFlag) {
            scriptFlag = sqlloadGenerator.generateScriptCtl(this.sqlloaderPrintStream.m_createdFiles, this.sqlloaderPrintStream, true);
        }
        dme = new DataMoveEvent(3, "SQL Loader Driver Script", scriptFlag ? "SUCCESS" : "FAILURE");
        this.m_audience.fireListeners(dme);
        this.thirdPartyPrintStream.finished();
        this.sqlloaderPrintStream.finished();
    }

    protected PersistenceUtility getPersistenceUtility() {
        return this.m_persistenceUtility;
    }

    protected void setPersistenceUtility(PersistenceUtility persistenceUtility) {
        this.m_persistenceUtility = persistenceUtility;
    }

    public void signalCancel() {
    }

    public DataMoveDescriptor getDescriptor() {
        if (!this.m_tables.hasNext()) {
            return null;
        }
        MgvAllTablesRec tableRec = (MgvAllTablesRec)this.m_tables.next();
        try {
            DataMoveDescriptor descriptor = DataMoveUtils.loadDescriptor(this.m_persistenceManager, tableRec.getTableId(), this.m_targetConnectionId);
            return descriptor;
        }
        catch (PersistenceException pex) {
            MigrationLogUtil.logThrowable("OfflineDataMove.RETRIEVE_DESCRIPTOR_FAILED", "Data Move", (Throwable)pex);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MdColumnComparator
    implements Comparator<MdColumn> {
        MdColumnComparator() {
        }

        @Override
        public int compare(MdColumn o1, MdColumn o2) {
            return o1.getColumnOrder() - o2.getColumnOrder();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof MdColumnComparator;
        }
    }
}

