/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Logger;
import oracle.dbtools.migration.datamove.offline.OfflineDatamoveOutputStream;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public abstract class OfflineDatamovePrintStream
implements OfflineDatamoveOutputStream {
    protected String writeDir = "";
    protected String pluginName;
    protected MigrationConfig m_offlineDataMoveOptions;
    protected String streamTimestamp;
    protected Logger m_logger = Logger.getLogger("oracle.dbtools.migration");

    public OfflineDatamovePrintStream(String pluginType, String timeStamp, String dir) {
        Preferences p = Preferences.getPreferences();
        MigrationConfig options = MigrationConfig.getInstance((PropertyStorage)p);
        this.setOfflineDataMoveOptions(options);
        this.pluginName = pluginType;
        this.setTimeStamp(timeStamp);
        this.setupFileStore(dir, pluginType, timeStamp);
    }

    private void setupFileStore(String dir, String pluginType, String timeStamp) {
        String currentDir;
        File ts;
        String topDir = dir + File.separator + pluginType;
        File f = new File(topDir);
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(ts = new File(currentDir = topDir + File.separator + timeStamp)).exists()) {
            ts.mkdir();
        }
        this.setWriteDir(currentDir);
    }

    public static String getTimeStamp() {
        String timeStamp = "";
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String dateFormat = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        timeStamp = sdf.format(cal.getTime());
        return timeStamp;
    }

    public final void setTimeStamp(String timestamp) {
        this.streamTimestamp = timestamp;
    }

    protected final void setOfflineDataMoveOptions(MigrationConfig datamoveOptions) {
        this.m_offlineDataMoveOptions = datamoveOptions;
    }

    public final String getWriteDir() {
        return this.writeDir;
    }

    public final void setWriteDir(String dir) {
        this.writeDir = dir;
    }

    public abstract void startDatabase();

    public abstract void endDatabase();

    public abstract void startTable(String var1);

    public abstract void endTable();
}

