/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.datamove.offline.OfflineSQLLoaderPrintStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineSQLLoaderGenerator {
    public boolean generateCtl(String srcTable, String targetTable, MdColumn[] srcTableCols, MdColumn[] tgtTableCols, OfflineSQLLoaderPrintStream printStream, MigrationPlugin plugin) {
        MigrationConfig config = MigrationAddin.getMigrationConfig();
        try {
            printStream.startTable(targetTable);
            printStream.println("load data");
            printStream.println("infile '" + plugin.maybeUnqualifyTable(srcTable) + "." + plugin.getDatafileExtension() + "' \"str '" + config.getEndRowDelimiter() + "'\"");
            printStream.println("into table " + targetTable);
            printStream.println("fields terminated by '" + config.getEndColumnDelimiter() + "'");
            printStream.println("trailing nullcols");
            printStream.println("(");
            for (int i = 0; i < tgtTableCols.length; ++i) {
                if (i < tgtTableCols.length - 1) {
                    printStream.println(this.formatCol(srcTableCols[i], tgtTableCols[i], plugin) + ",");
                    continue;
                }
                printStream.println(this.formatCol(srcTableCols[i], tgtTableCols[i], plugin));
            }
            printStream.println(")");
            printStream.endTable();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String formatCol(MdColumn srcColumn, MdColumn tgtColumn, MigrationPlugin plugin) {
        String line = tgtColumn.getColumnName();
        String format = plugin.formatSQLLoaderColumn(srcColumn, tgtColumn);
        if (plugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob() && tgtColumn.getColumnType().toUpperCase().equals("BLOB")) {
            line = "SQLDEVELOPER_CLOB_" + tgtColumn.getColumnOrder();
        }
        return line + " " + format;
    }

    public boolean generateScriptCtl(ArrayList<String> tables, OfflineSQLLoaderPrintStream printStream, boolean isWindows) {
        try {
            this.setNLSHeader(printStream, isWindows);
            if (isWindows) {
                for (String table : tables) {
                    printStream.println("sqlldr <Username>/<Password> control=Oracle\\" + table + ".ctl " + "log=" + table + ".log");
                }
            } else {
                for (String table : tables) {
                    printStream.println("sqlldr <Username>/<Password> control=Oracle/" + table + ".ctl " + "log=" + table + ".log");
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        printStream.println("sqlplus <Username>/<Password> < post_load.sql");
        return true;
    }

    private void setNLSHeader(OfflineSQLLoaderPrintStream printStream, boolean isWindows) {
        if (isWindows) {
            printStream.println("set NLS_DATE_FORMAT=Mon dd YYYY HH:mi:ssAM");
            printStream.println("REM set NLS_TIMESTAMP_FORMAT=Mon dd YYYY HH:mi:ffAM");
            printStream.println("REM set NLS_LANGUAGE=<insert the language of your database here e.g., US7ASCII>");
            printStream.println("sqlplus <Username>/<Password> < pre_load.sql");
        } else {
            printStream.println("export NLS_DATE_FORMAT='Mon dd YYYY HH:mi:ssAM'\n");
            printStream.println("# export NLS_TIMESTAMP_FORMAT='Mon dd YYYY HH:mi:ffAM'\n");
            printStream.println("# export NLS_LANGUAGE=<insert the language of your database here e.g., US7ASCII>");
            printStream.println("sqlplus <Username>/<Password> < pre_load.sql");
        }
    }
}

