/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.datamove.offline.OfflineDatamovePrintStream;
import oracle.ide.Ide;

public class OfflineSQLLoaderPrintStream
extends OfflineDatamovePrintStream {
    protected ArrayList<String> m_createdFiles = new ArrayList();
    private PrintWriter m_printer;

    public OfflineSQLLoaderPrintStream(String pluginType, String timestamp, String dir) {
        super(pluginType, timestamp, dir);
        this.setLoaderDir(this.writeDir);
    }

    private void setLoaderDir(String dir) {
        String loaderDir = dir + File.separator + "Oracle";
        File f = new File(loaderDir);
        if (!f.exists()) {
            f.mkdir();
        }
        this.writeDir = loaderDir;
    }

    public void endDatabase() {
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            this.m_printer = encoding == null ? new PrintWriter(this.writeDir + File.separator + ".." + File.separator + "oracle_ctl.sh") : new PrintWriter(this.writeDir + File.separator + ".." + File.separator + "oracle_ctl.sh", encoding);
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void winPrintstream() {
        this.finished();
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            this.m_printer = encoding == null ? new PrintWriter(this.writeDir + File.separator + ".." + File.separator + "oracle_ctl.bat") : new PrintWriter(this.writeDir + File.separator + ".." + File.separator + "oracle_ctl.bat", encoding);
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void startDatabase() {
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            this.m_printer = encoding == null ? new PrintWriter(this.writeDir + File.separator + ".." + File.separator + "pre_load.sql") : new PrintWriter(this.writeDir + File.separator + ".." + File.separator + "pre_load.sql", encoding);
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void openEnableSQLFile() {
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            this.m_printer = encoding == null ? new PrintWriter(this.writeDir + File.separator + ".." + File.separator + "post_load.sql") : new PrintWriter(this.writeDir + File.separator + ".." + File.separator + "post_load.sql", encoding);
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void println(String toPrint) {
        this.m_printer.println(toPrint);
    }

    public final void endTable() {
        this.m_printer.flush();
        this.m_printer.close();
    }

    public final void startTable(String tableName) {
        this.m_createdFiles.add(tableName);
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            PrintWriter pw = null;
            pw = encoding == null ? new PrintWriter(this.writeDir + File.separator + tableName + ".ctl") : new PrintWriter(this.writeDir + File.separator + tableName + ".ctl", encoding);
            this.m_printer = pw;
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void finished() {
        this.m_printer.flush();
        this.m_printer.close();
    }
}

