/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.offline.OfflineDatamoveOutputStream;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

public class ConstraintHandler {
    private static final int ORA_ERR_NO_SUCH_CONSTAINT = 2431;
    private static final String QUERY_FIND_CONSTRAINTS = "SELECT A.SCHEMA_NAME, A.TABLE_NAME, B.NAME, B.CONSTRAINT_TYPE, DECODE(B.CONSTRAINT_TYPE, 'CHECK', 1, 'FOREIGN KEY',2, 'PK', 3, 'UNIQUE', 4) CONSCODE FROM MGV_ALL_TABLES A, MD_CONSTRAINTS B WHERE A.TABLE_ID = B.TABLE_ID_FK AND A.CONNECTION_ID = ? ORDER BY CONSCODE";
    private ArrayList<ConstraintDetail> m_disabledConstraints;
    private DBObjectId m_connectionId;
    private PersistenceManager m_persistenceManager;

    public ConstraintHandler(DBObjectId connectionId, PersistenceManager pman) {
        this.m_persistenceManager = pman;
        this.m_connectionId = connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableConstraints(OfflineDatamoveOutputStream output, Connection conn, boolean qualifyNames) throws SQLException {
        if (output == null && conn == null) {
            throw new IllegalArgumentException("both output and connection cannot be null");
        }
        if (output != null && conn != null) {
            throw new IllegalArgumentException("Only 1 of otuput or conn should be set");
        }
        this.m_disabledConstraints = new ArrayList();
        CloseableResultSet crs = null;
        try {
            PreparedStatement stmt = this.m_persistenceManager.getPreparedStatement(QUERY_FIND_CONSTRAINTS);
            stmt.setLong(1, this.m_connectionId.getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            while (rs.next()) {
                ConstraintDetail detail = new ConstraintDetail(rs.getString(1), rs.getString(2), rs.getString(3));
                try {
                    if (conn != null) {
                        ConstraintHandler.disableDetail(detail, conn, qualifyNames);
                    } else {
                        output.println(detail.toOracleDisableString(qualifyNames) + ";");
                    }
                    this.m_disabledConstraints.add(detail);
                }
                catch (SQLException sqlex) {
                    if (sqlex.getErrorCode() == 2431) continue;
                    MigrationLogUtil.logThrowable("DataMove.DISABLE_CONSTRAINTS_FAILED", new Object[]{"Data Move", new LogInfo("Data Move")}, (Throwable)sqlex);
                }
            }
            Object var10_9 = null;
            if (crs != null) {
                crs.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (crs != null) {
                crs.close();
            }
            throw throwable;
        }
    }

    public void disableConstraints(Connection conn, boolean qualifyNames) throws SQLException {
        this.disableConstraints(null, conn, qualifyNames);
    }

    public void disableConstraints(OfflineDatamoveOutputStream output, boolean qualifyNames) {
        try {
            this.disableConstraints(output, null, qualifyNames);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void reenableConstraints(OfflineDatamoveOutputStream output, Connection conn, boolean qualifyNames) {
        if (output == null && conn == null) {
            throw new IllegalArgumentException("Output and conn cannot be null");
        }
        if (output != null && conn != null) {
            throw new IllegalArgumentException("Only 1 of output and conn should be set.");
        }
        while (this.m_disabledConstraints.size() > 0) {
            ConstraintDetail detail = this.m_disabledConstraints.remove(this.m_disabledConstraints.size() - 1);
            try {
                if (conn != null) {
                    ConstraintHandler.enableDetail(detail, conn, qualifyNames);
                    continue;
                }
                output.println(detail.toOracleEnableString(qualifyNames) + ";");
            }
            catch (SQLException sqlex) {
                Logger.getLogger("oracle.dbtools.migration").log(Level.SEVERE, "DataMove.ENABLE_CONSTRAINT_FAILED", sqlex.getLocalizedMessage());
            }
        }
    }

    public void reenableConstraints(Connection conn, boolean qualifyNames) {
        this.reenableConstraints(null, conn, qualifyNames);
    }

    public void reenableConstraints(OfflineDatamoveOutputStream output, boolean qualifyNames) {
        this.reenableConstraints(output, null, qualifyNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disableDetail(ConstraintDetail detail, Connection conn, boolean qualifyNames) throws SQLException {
        Statement stmt = conn.createStatement();
        try {
            stmt.executeUpdate(detail.toOracleDisableString(qualifyNames));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                stmt.close();
            }
            catch (SQLException sqlex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stmt.close();
        }
        catch (SQLException sqlex) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enableDetail(ConstraintDetail detail, Connection conn, boolean qualifyNames) throws SQLException {
        Statement stmt = conn.createStatement();
        try {
            stmt.executeUpdate(detail.toOracleEnableString(qualifyNames));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                stmt.close();
            }
            catch (SQLException sqlex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stmt.close();
        }
        catch (SQLException sqlex) {}
    }

    private static class ConstraintDetail {
        private String m_schemaName;
        private String m_tableName;
        private String m_constraintName;

        public ConstraintDetail(String schemaName, String tableName, String constraintName) {
            this.setSchemaName(schemaName);
            this.setTableName(tableName);
            this.setConstraintName(constraintName);
        }

        public String getConstraintName() {
            return this.m_constraintName;
        }

        public String getTableName() {
            return this.m_tableName;
        }

        public String getSchemaName() {
            return this.m_schemaName;
        }

        protected void setConstraintName(String constraintName) {
            this.m_constraintName = constraintName;
        }

        protected void setTableName(String tableName) {
            this.m_tableName = tableName;
        }

        protected void setSchemaName(String schemaName) {
            this.m_schemaName = schemaName;
        }

        private String toOracleAlterStatement(boolean qualifyName, boolean enable) {
            StringBuffer sBuf = new StringBuffer();
            sBuf.append("ALTER TABLE ");
            if (qualifyName) {
                sBuf.append(this.getSchemaName());
                sBuf.append('.');
            }
            sBuf.append(this.getTableName());
            sBuf.append(' ');
            if (enable) {
                sBuf.append("ENABLE");
            } else {
                sBuf.append("DISABLE");
            }
            sBuf.append(" CONSTRAINT ");
            sBuf.append(this.getConstraintName());
            return sBuf.toString();
        }

        public String toOracleDisableString(boolean qualifyName) {
            return this.toOracleAlterStatement(qualifyName, false);
        }

        public String toOracleEnableString(boolean qualifyName) {
            return this.toOracleAlterStatement(qualifyName, true);
        }
    }
}

