/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.datamove.DataMoveMarshal;
import oracle.dbtools.migration.datamove.DataMoveUtils;
import oracle.dbtools.migration.datamove.online.DataMoveAudience;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveLogWrapper;
import oracle.dbtools.migration.datamove.online.DroneState;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMoveDrone
implements Runnable,
Cancelable {
    private static Logger s_log = Logger.getLogger("oracle.dbtools.migration");
    public static final int ROWCOUNT_UNKNOWN = -1;
    public static final String STATE_INITIALISING = "INITIALISING";
    public static final String STATE_DISABLING = "DISABLING";
    public static final String STATE_BUILDING = "BUILDING";
    public static final String STATE_MOVING = "MOVING";
    public static final String STATE_DONE = "DONE";
    public static final String STATE_FINISHED = "FINISHED";
    private DataMoveMarshal m_marshal;
    private boolean m_cancelled = false;
    private DroneStateVector m_stateVector;
    private Connection m_sourceConnection;
    private Connection m_targetConnection;
    private DataMoveDescriptor m_descriptor;
    private Quoter m_quoter;
    private boolean m_getCounts = false;
    private int m_commitInterval;
    private boolean m_pessimistic = false;
    private Vector<DataMoveLogWrapper> m_messages;
    private ResourceBundle m_resourceBundle;
    private DataMoveAudience m_audience;
    private boolean m_qualifyNames;

    public DataMoveDrone(String id, DataMoveMarshal marshal, Connection sourceConnection, Connection targetConnection, Quoter quoter, boolean getCounts, int commitInterval, DataMoveAudience audience, boolean qualifyNames) {
        this.m_marshal = marshal;
        this.m_stateVector = new DroneStateVector(id);
        this.setSourceConnection(sourceConnection);
        this.setTargetConnection(targetConnection);
        this.m_quoter = quoter;
        this.m_audience = audience;
        this.m_getCounts = getCounts;
        if (commitInterval < 1) {
            throw new IllegalArgumentException("commit interval must be at least every 1 row");
        }
        this.m_commitInterval = commitInterval;
        this.m_resourceBundle = s_log.getResourceBundle();
        this.m_qualifyNames = qualifyNames;
    }

    public DataMoveDrone(String id, DataMoveMarshal marshal, Connection sourceConnection, Connection targetConnection, Quoter quoter, int commitInterval, DataMoveAudience audience, boolean qualifyNames) {
        this(id, marshal, sourceConnection, targetConnection, quoter, true, commitInterval, audience, qualifyNames);
    }

    private void createLogMessage(String tableName, Level level, String message, MdTable table, MdSchema schema) {
        boolean isMessageExists = false;
        for (DataMoveLogWrapper wrapper : this.m_messages) {
            if (!wrapper.getMessage().equals(message)) continue;
            isMessageExists = true;
            wrapper.setCounter(wrapper.getCounter() + 1);
            break;
        }
        if (!isMessageExists) {
            DataMoveLogWrapper wrapper = new DataMoveLogWrapper();
            wrapper.setTable(table);
            wrapper.setSchema(schema);
            wrapper.setLevel(level);
            wrapper.setMessage(message);
            this.m_messages.add(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block14: {
            MdTable tableToPass2;
            String message2;
            String currentTable2;
            try {
                this.m_descriptor = this.m_marshal.getDescriptor();
                while (this.m_descriptor != null) {
                    this.doDataMove();
                    this.m_stateVector.m_totalTablesMoved++;
                    if (this.m_cancelled) break;
                    this.m_descriptor = this.m_marshal.getDescriptor();
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                MdTable tableToPass2;
                String message2;
                String currentTable2;
                Object var2_2 = null;
                try {
                    this.getSourceConnection().close();
                }
                catch (SQLException sqlex) {
                    currentTable2 = this.m_descriptor.getSourceTableName();
                    message2 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.CLOSE_SOURCE_FAILED"), sqlex.getLocalizedMessage());
                    tableToPass2 = this.m_descriptor.getTargetTable();
                    if (tableToPass2 == null) {
                        tableToPass2 = this.m_descriptor.getSourceTable();
                    }
                    this.createLogMessage(currentTable2, Level.WARNING, message2, tableToPass2, this.m_descriptor.getSourceSchema());
                }
                this.m_sourceConnection = null;
                try {
                    this.getTargetConnection().close();
                }
                catch (SQLException sqlex2) {
                    currentTable2 = this.m_stateVector.getCurrentTable();
                    message2 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.CLOSE_TARGET_FAILED"), sqlex2.getLocalizedMessage());
                    tableToPass2 = this.m_descriptor.getTargetTable();
                    if (tableToPass2 == null) {
                        tableToPass2 = this.m_descriptor.getSourceTable();
                    }
                    this.createLogMessage(currentTable2, Level.WARNING, message2, tableToPass2, this.m_descriptor.getSourceSchema());
                }
                this.m_targetConnection = null;
                this.m_stateVector.setCurrentProcessState(STATE_FINISHED);
                throw throwable;
            }
            try {
                this.getSourceConnection().close();
            }
            catch (SQLException sqlex) {
                currentTable2 = this.m_descriptor.getSourceTableName();
                message2 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.CLOSE_SOURCE_FAILED"), sqlex.getLocalizedMessage());
                tableToPass2 = this.m_descriptor.getTargetTable();
                if (tableToPass2 == null) {
                    tableToPass2 = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(currentTable2, Level.WARNING, message2, tableToPass2, this.m_descriptor.getSourceSchema());
            }
            this.m_sourceConnection = null;
            try {
                this.getTargetConnection().close();
                break block14;
            }
            catch (SQLException sqlex2) {
                currentTable2 = this.m_stateVector.getCurrentTable();
                message2 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.CLOSE_TARGET_FAILED"), sqlex2.getLocalizedMessage());
                tableToPass2 = this.m_descriptor.getTargetTable();
                if (tableToPass2 == null) {
                    tableToPass2 = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(currentTable2, Level.WARNING, message2, tableToPass2, this.m_descriptor.getSourceSchema());
            }
            {
            }
        }
        this.m_targetConnection = null;
        this.m_stateVector.setCurrentProcessState(STATE_FINISHED);
    }

    private void logMessages() {
        LogInfo childLogs = new LogInfo("Data Move");
        if (this.m_messages.size() == 0) {
            return;
        }
        if (this.m_messages.size() > 1) {
            for (DataMoveLogWrapper helper : this.m_messages) {
                LogRecord rec = this.createLogRecord(helper, helper.getMessage(), true);
                if (helper.getCounter() > 1) {
                    String message = MessageFormat.format(this.m_resourceBundle.getString("DataMove.MULTIPLE_OCCURANCES_OF_MESSAGE"), helper.getCounter());
                    LogRecord child = this.createLogRecord(helper, message, false);
                    rec.setParameters(new Object[]{child});
                }
                childLogs.addChild(rec);
            }
            LogRecord messageRecord = new LogRecord(Level.WARNING, this.m_descriptor.getSourceTableName());
            messageRecord.setLoggerName(s_log.getName());
            messageRecord.setParameters(new Object[]{childLogs});
            s_log.log(messageRecord);
        } else {
            DataMoveLogWrapper helper = this.m_messages.get(0);
            String message = helper.getSchema().getName() + "." + helper.getTable().getTableName() + ": " + helper.getMessage();
            LogRecord rec = this.createLogRecord(helper, message, true);
            s_log.log(rec);
        }
    }

    private LogRecord createLogRecord(DataMoveLogWrapper helper, String message, boolean isClickable) {
        LogRecord rec = new LogRecord(helper.getLevel(), message);
        rec.setLoggerName(s_log.getName());
        ResourceBundle resourceBundle = s_log.getResourceBundle();
        rec.setResourceBundle(resourceBundle);
        if (isClickable) {
            ClickableLogInfo cl = new ClickableLogInfo(helper.getTable(), "DataMove");
            rec.setParameters(new Object[]{cl});
        }
        return rec;
    }

    @Override
    public void signalCancel() {
        this.m_cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doDataMove() {
        block33: {
            Statement selectStmt;
            PreparedStatement insertStmt;
            ResultSet rs;
            block30: {
                Hashtable<String, Integer> colTypesTable = null;
                this.m_messages = new Vector();
                this.m_stateVector.newTable(this.m_descriptor.getSourceTableName());
                try {
                    colTypesTable = DataMoveUtils.getColumnTypes(this.m_descriptor.getTargetTableName(this.m_qualifyNames), this.m_targetConnection);
                }
                catch (SQLException sqlex) {
                    String currentTable = this.m_descriptor.getTargetTableName(this.m_qualifyNames);
                    String message = MessageFormat.format(this.m_resourceBundle.getString("DataMove.FAILED_TO_FIND_TARGET"), currentTable);
                    MdTable tableToPass = this.m_descriptor.getTargetTable();
                    if (tableToPass == null) {
                        tableToPass = this.m_descriptor.getSourceTable();
                    }
                    this.createLogMessage(currentTable, Level.SEVERE, message, tableToPass, this.m_descriptor.getSourceSchema());
                    this.incrementErrorCount();
                    return;
                }
                rs = null;
                String[] targetColNames = this.m_descriptor.getTargetColumnNames();
                this.m_stateVector.setCurrentProcessState(STATE_BUILDING);
                if (this.m_getCounts) {
                    this.m_stateVector.setTableRowCount(this.getSourceRowCount());
                }
                String selectQuery = this.createSelectQuery();
                insertStmt = null;
                selectStmt = null;
                insertStmt = this.createInsertPreparedStatement(targetColNames);
                selectStmt = this.m_sourceConnection.createStatement();
                rs = selectStmt.executeQuery(selectQuery);
                this.moveRows(rs, insertStmt, targetColNames, colTypesTable);
                this.commitInserts();
                this.m_stateVector.setCurrentProcessState(STATE_DONE);
                String currentTable = this.m_descriptor.getSourceTableName();
                MdTable tableToPass = this.m_descriptor.getTargetTable();
                if (tableToPass == null) {
                    tableToPass = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(currentTable, Level.INFO, this.m_stateVector.toLogString(), tableToPass, this.m_descriptor.getSourceSchema());
                DataMoveEvent event = new DataMoveEvent(3, this.m_descriptor.getSourceTable().getTableName(), this);
                this.m_audience.fireListeners(event);
                Object var12_17 = null;
                if (rs == null) break block30;
                try {
                    rs.close();
                }
                catch (SQLException sqlex1) {
                    // empty catch block
                }
            }
            if (insertStmt != null) {
                try {
                    insertStmt.close();
                }
                catch (SQLException sqlex2) {
                    // empty catch block
                }
            }
            if (selectStmt != null) {
                try {
                    selectStmt.close();
                }
                catch (SQLException sqlex3) {
                    // empty catch block
                }
            }
            this.logMessages();
            {
                break block33;
                catch (SQLException sqlex) {
                    String currentTable = this.m_descriptor.getSourceTableName();
                    String message = MessageFormat.format(this.m_resourceBundle.getString("DataMove.MOVE_FAILED"), sqlex.getLocalizedMessage());
                    MdTable tableToPass = this.m_descriptor.getTargetTable();
                    if (tableToPass == null) {
                        tableToPass = this.m_descriptor.getSourceTable();
                    }
                    this.createLogMessage(currentTable, Level.SEVERE, message, tableToPass, this.m_descriptor.getSourceSchema());
                    Object var12_18 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqlex1) {
                            // empty catch block
                        }
                    }
                    if (insertStmt != null) {
                        try {
                            insertStmt.close();
                        }
                        catch (SQLException sqlex2) {
                            // empty catch block
                        }
                    }
                    if (selectStmt != null) {
                        try {
                            selectStmt.close();
                        }
                        catch (SQLException sqlex3) {
                            // empty catch block
                        }
                    }
                    this.logMessages();
                }
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqlex1) {
                        // empty catch block
                    }
                }
                if (insertStmt != null) {
                    try {
                        insertStmt.close();
                    }
                    catch (SQLException sqlex2) {
                        // empty catch block
                    }
                }
                if (selectStmt != null) {
                    try {
                        selectStmt.close();
                    }
                    catch (SQLException sqlex3) {
                        // empty catch block
                    }
                }
                this.logMessages();
                throw throwable;
            }
        }
    }

    private void commitInserts() {
        try {
            this.m_targetConnection.commit();
        }
        catch (SQLException sqlex) {
            String currentTable = this.m_descriptor.getSourceTableName();
            String message = MessageFormat.format(this.m_resourceBundle.getString("DataMove.COMMIT_FAILED"), sqlex.getLocalizedMessage());
            MdTable tableToPass = this.m_descriptor.getTargetTable();
            if (tableToPass == null) {
                tableToPass = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(currentTable, Level.SEVERE, message, tableToPass, this.m_descriptor.getSourceSchema());
            this.incrementErrorCount();
        }
    }

    protected void moveRows(ResultSet rs, PreparedStatement insertStmt, String[] targetColNames, Hashtable<String, Integer> colTypes) {
        ArrayList<CLOB> clobsToRelease = null;
        ArrayList<BLOB> blobsToRelease = null;
        int currentRow = 0;
        boolean hasMore = false;
        boolean reportedEmptyToNULL = false;
        String currentField = null;
        String lastErrMsg = null;
        this.m_stateVector.setCurrentProcessState(STATE_MOVING);
        try {
            hasMore = rs.next();
            ++currentRow;
        }
        catch (SQLException sqlex) {
            String currentTable = this.m_descriptor.getSourceTableName();
            String message = MessageFormat.format(this.m_resourceBundle.getString("DataMove.RETRIEVE_FAILED"), this.m_descriptor.getSourceTableName());
            MdTable tableToPass = this.m_descriptor.getTargetTable();
            if (tableToPass == null) {
                tableToPass = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(currentTable, Level.SEVERE, message, tableToPass, this.m_descriptor.getSourceSchema());
            this.incrementErrorCount();
            return;
        }
        while (hasMore) {
            String currentTable;
            block22: {
                MdTable tableToPass;
                if (this.m_cancelled) {
                    return;
                }
                try {
                    blobsToRelease = new ArrayList<BLOB>();
                    clobsToRelease = new ArrayList<CLOB>();
                    for (int i = 0; i < targetColNames.length; ++i) {
                        currentField = targetColNames[i];
                        String sourceColName = this.m_descriptor.getOriginalColumnName(currentField);
                        Object o = rs.getObject(sourceColName);
                        if (rs.wasNull()) {
                            this.handleNullValue(colTypes, sourceColName, currentField, insertStmt, i + 1, blobsToRelease, clobsToRelease);
                            continue;
                        }
                        Object transform = this.checkEmptyObject(o);
                        if (transform != null) {
                            insertStmt.setObject(i + 1, transform);
                            if (reportedEmptyToNULL) continue;
                            String currentTable2 = this.m_descriptor.getTargetTableName(this.m_qualifyNames);
                            String message = MessageFormat.format(this.m_resourceBundle.getString("DataMove.REPLACED_EMPTY_WARNING"), currentTable2 + "." + currentField, currentRow);
                            MdTable tableToPass2 = this.m_descriptor.getTargetTable();
                            if (tableToPass2 == null) {
                                tableToPass2 = this.m_descriptor.getSourceTable();
                            }
                            this.createLogMessage(currentTable2, Level.WARNING, message, tableToPass2, this.m_descriptor.getSourceSchema());
                            reportedEmptyToNULL = true;
                            continue;
                        }
                        if (o instanceof BigInteger) {
                            NUMBER oNUM = new NUMBER((BigInteger)o);
                            ((OraclePreparedStatement)insertStmt).setNUMBER(i + 1, oNUM);
                            continue;
                        }
                        if (o instanceof Blob) {
                            BLOB orablob = this.handleBlob(insertStmt, i + 1, (Blob)o);
                            if (orablob == null) continue;
                            blobsToRelease.add(orablob);
                            continue;
                        }
                        if (o instanceof Clob) {
                            CLOB oraclob = this.handleClob(insertStmt, i + 1, (Clob)o);
                            if (oraclob == null) continue;
                            clobsToRelease.add(oraclob);
                            continue;
                        }
                        insertStmt.setObject(i + 1, o);
                    }
                    int insertedRows = insertStmt.executeUpdate();
                    this.releaseLobs(blobsToRelease, clobsToRelease);
                    blobsToRelease = null;
                    clobsToRelease = null;
                    if (insertedRows != 1) {
                        String currentTable3 = this.m_descriptor.getTargetTableName(this.m_qualifyNames);
                        String message = MessageFormat.format(this.m_resourceBundle.getString("DataMove.INSERT_ERROR"), this.m_descriptor.getSourceDatabaseName());
                        tableToPass = this.m_descriptor.getTargetTable();
                        if (tableToPass == null) {
                            tableToPass = this.m_descriptor.getSourceTable();
                        }
                        this.createLogMessage(currentTable3, Level.SEVERE, message, tableToPass, this.m_descriptor.getSourceSchema());
                        this.incrementErrorCount();
                    } else {
                        this.m_stateVector.m_rowsMoved++;
                        if (this.m_stateVector.m_rowsMoved % (long)this.m_commitInterval == 0L) {
                            this.commitInserts();
                        }
                    }
                }
                catch (SQLException sqlex2) {
                    this.releaseLobs(blobsToRelease, clobsToRelease);
                    blobsToRelease = null;
                    clobsToRelease = null;
                    this.incrementErrorCount();
                    lastErrMsg = this.m_descriptor.getSourceTableName() + " " + sqlex2.getLocalizedMessage();
                    currentTable = this.m_descriptor.getSourceTableName();
                    tableToPass = this.m_descriptor.getTargetTable();
                    if (tableToPass == null) {
                        tableToPass = this.m_descriptor.getSourceTable();
                    }
                    this.createLogMessage(currentTable, Level.SEVERE, lastErrMsg, tableToPass, this.m_descriptor.getSourceSchema());
                    if (!this.m_pessimistic) break block22;
                    return;
                }
            }
            try {
                hasMore = rs.next();
                ++currentRow;
            }
            catch (SQLException sqlex3) {
                currentTable = this.m_descriptor.getSourceTableName();
                String message = MessageFormat.format(this.m_resourceBundle.getString("DataMove.RETRIEVE_FAILED"), this.m_descriptor.getSourceTableName());
                MdTable tableToPass = this.m_descriptor.getTargetTable();
                if (tableToPass == null) {
                    tableToPass = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(currentTable, Level.SEVERE, message, tableToPass, this.m_descriptor.getSourceSchema());
                this.incrementErrorCount();
                return;
            }
        }
    }

    private void handleNullValue(Hashtable<String, Integer> colTypes, String sourceColName, String targetColName, PreparedStatement stmt, int fieldIndex, ArrayList<BLOB> blobsToRelease, ArrayList<CLOB> clobsToRelease) throws SQLException {
        MdTable tableToPass;
        String message;
        String currentTable;
        Integer type = colTypes.get(targetColName.toUpperCase());
        MdColumn mdcol = this.m_descriptor.getSourceColumnByName(sourceColName);
        if (mdcol == null) {
            currentTable = this.m_descriptor.getSourceTableName();
            message = MessageFormat.format(this.m_resourceBundle.getString("DataMove.FAILEDTOFINDMDCOL"), sourceColName);
            tableToPass = this.m_descriptor.getTargetTable();
            if (tableToPass == null) {
                tableToPass = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(currentTable, Level.FINE, message, tableToPass, this.m_descriptor.getSourceSchema());
        } else if (!PersistenceUtility.isColumnNullable(mdcol)) {
            Object o = this.getDummyValueForType(type);
            if (o instanceof CLOB) {
                clobsToRelease.add((CLOB)o);
            } else if (o instanceof BLOB) {
                blobsToRelease.add((BLOB)o);
            }
            if (o != null) {
                String currentTable2 = this.m_descriptor.getSourceTableName();
                String message2 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.DEFAULTINGNULLVALUE"), sourceColName, o.toString());
                MdTable tableToPass2 = this.m_descriptor.getTargetTable();
                if (tableToPass2 == null) {
                    tableToPass2 = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(currentTable2, Level.WARNING, message2, tableToPass2, this.m_descriptor.getSourceSchema());
                stmt.setObject(fieldIndex, o);
            } else {
                String currentTable3 = this.m_descriptor.getSourceTableName();
                String message3 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.DEFAULTINGNULLVALUE"), sourceColName, "null");
                MdTable tableToPass3 = this.m_descriptor.getTargetTable();
                if (tableToPass3 == null) {
                    tableToPass3 = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(currentTable3, Level.WARNING, message3, tableToPass3, this.m_descriptor.getSourceSchema());
                stmt.setNull(fieldIndex, type);
            }
            return;
        }
        if (type == null) {
            currentTable = this.m_descriptor.getSourceTableName();
            message = MessageFormat.format(this.m_resourceBundle.getString("DataMove.FIND_TYPE_FAILED"), targetColName);
            tableToPass = this.m_descriptor.getTargetTable();
            if (tableToPass == null) {
                tableToPass = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(currentTable, Level.FINE, message, tableToPass, this.m_descriptor.getSourceSchema());
            stmt.setNull(fieldIndex, 12);
        } else {
            stmt.setNull(fieldIndex, type);
        }
    }

    private Object getDummyValueForType(int type) {
        switch (type) {
            case 2003: {
                return null;
            }
            case -5: {
                return BigInteger.ZERO;
            }
            case -2: {
                return this.createDummyBlob();
            }
            case -7: {
                return 0;
            }
            case 2004: {
                return this.createDummyBlob();
            }
            case 16: {
                return 0;
            }
            case 1: {
                return new Character(' ');
            }
            case 2005: {
                return this.createDummyClob();
            }
            case 70: {
                return null;
            }
            case 91: {
                return new Date(0L);
            }
            case 3: {
                return BigDecimal.ZERO;
            }
            case 2001: {
                return null;
            }
            case 8: {
                return 0.0;
            }
            case 6: {
                return Float.valueOf(0.0f);
            }
            case 4: {
                return 0;
            }
            case 2000: {
                return null;
            }
            case -4: {
                return this.createDummyBlob();
            }
            case -1: {
                return this.createDummyClob();
            }
            case 0: {
                return null;
            }
            case 2: {
                return 0;
            }
            case 1111: {
                return null;
            }
            case 7: {
                return Float.valueOf(0.0f);
            }
            case 2006: {
                return null;
            }
            case 5: {
                return 0;
            }
            case 2002: {
                return null;
            }
            case 92: {
                return new Time(0L);
            }
            case 93: {
                return new Timestamp(0L);
            }
            case -6: {
                return 0;
            }
            case -3: {
                return this.createDummyBlob();
            }
            case 12: {
                return new String(" ");
            }
        }
        return null;
    }

    private void releaseLobs(ArrayList<BLOB> blobs, ArrayList<CLOB> clobs) {
        MdTable tableToPass;
        String currentTable;
        while (blobs.size() != 0) {
            BLOB loblaw = blobs.remove(0);
            try {
                loblaw.freeTemporary();
            }
            catch (SQLException sqlex) {
                currentTable = this.m_descriptor.getSourceTableName();
                tableToPass = this.m_descriptor.getTargetTable();
                if (tableToPass == null) {
                    tableToPass = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(currentTable, Level.WARNING, sqlex.getLocalizedMessage(), tableToPass, this.m_descriptor.getSourceSchema());
            }
        }
        while (clobs.size() != 0) {
            CLOB clob = clobs.remove(0);
            try {
                clob.freeTemporary();
            }
            catch (SQLException sqlex2) {
                currentTable = this.m_descriptor.getSourceTableName();
                tableToPass = this.m_descriptor.getTargetTable();
                if (tableToPass == null) {
                    tableToPass = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(currentTable, Level.WARNING, sqlex2.getLocalizedMessage(), tableToPass, this.m_descriptor.getSourceSchema());
            }
        }
    }

    private CLOB handleClob(PreparedStatement stmt, int colIndex, Clob loblaw) {
        try {
            CLOB oraclob = CLOB.createTemporary((Connection)this.m_targetConnection, (boolean)true, (int)10);
            oraclob.open(1);
            Reader sourceReader = loblaw.getCharacterStream();
            Writer targetWriter = oraclob.setCharacterStream(0L);
            int chunksize = oraclob.getChunkSize();
            char[] buffer = new char[chunksize];
            int length = 0;
            while ((length = sourceReader.read(buffer, 0, chunksize)) != -1) {
                targetWriter.write(buffer, 0, length);
            }
            sourceReader.close();
            targetWriter.flush();
            targetWriter.close();
            stmt.setClob(colIndex, (Clob)oraclob);
            return oraclob;
        }
        catch (SQLException sqlex) {
            String currentTable = this.m_descriptor.getSourceTableName();
            MdTable tableToPass = this.m_descriptor.getTargetTable();
            if (tableToPass == null) {
                tableToPass = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(currentTable, Level.FINE, sqlex.getLocalizedMessage(), tableToPass, this.m_descriptor.getSourceSchema());
        }
        catch (IOException ioe) {
            String currentTable = this.m_descriptor.getSourceTableName();
            MdTable tableToPass = this.m_descriptor.getTargetTable();
            if (tableToPass == null) {
                tableToPass = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(currentTable, Level.FINE, ioe.getLocalizedMessage(), tableToPass, this.m_descriptor.getSourceSchema());
        }
        return null;
    }

    private BLOB handleBlob(PreparedStatement stmt, int colIndex, Blob loblaw) {
        try {
            BLOB orablob = BLOB.createTemporary((Connection)this.m_targetConnection, (boolean)true, (int)10);
            orablob.open(1);
            InputStream sourceDataStream = loblaw.getBinaryStream();
            OutputStream targetDataStream = orablob.setBinaryStream(0L);
            int chunksize = orablob.getChunkSize();
            byte[] buffer = new byte[chunksize];
            int length = 0;
            while ((length = sourceDataStream.read(buffer)) != -1) {
                targetDataStream.write(buffer, 0, length);
            }
            sourceDataStream.close();
            targetDataStream.flush();
            targetDataStream.close();
            stmt.setBlob(colIndex, (Blob)orablob);
            return orablob;
        }
        catch (SQLException sqlex) {
            String currentTable = this.m_descriptor.getSourceTableName();
            MdTable tableToPass = this.m_descriptor.getTargetTable();
            if (tableToPass == null) {
                tableToPass = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(currentTable, Level.FINE, sqlex.getLocalizedMessage(), tableToPass, this.m_descriptor.getSourceSchema());
        }
        catch (IOException e) {
            String currentTable = this.m_descriptor.getSourceTableName();
            MdTable tableToPass = this.m_descriptor.getTargetTable();
            if (tableToPass == null) {
                tableToPass = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(currentTable, Level.FINE, e.getLocalizedMessage(), tableToPass, this.m_descriptor.getSourceSchema());
        }
        return null;
    }

    private Object checkEmptyObject(Object o) {
        MdTable tableToPass;
        String currentTable;
        if (o instanceof String) {
            String s = (String)o;
            if (s.length() == 0 && MigrationAddin.getMigrationConfig().getEmptyStringIsSpace()) {
                return " ";
            }
            return null;
        }
        if (o instanceof byte[]) {
            byte[] b = (byte[])o;
            if (b.length == 0) {
                byte[] ret = new byte[]{32};
                return ret;
            }
            return null;
        }
        if (o instanceof Blob) {
            Blob blob = (Blob)o;
            try {
                if (blob.length() == 0L) {
                    return this.createDummyBlob();
                }
            }
            catch (SQLException sqlex) {
                currentTable = this.m_descriptor.getSourceTableName();
                tableToPass = this.m_descriptor.getTargetTable();
                if (tableToPass == null) {
                    tableToPass = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(currentTable, Level.FINE, sqlex.getLocalizedMessage(), tableToPass, this.m_descriptor.getSourceSchema());
            }
        }
        if (o instanceof Clob) {
            Clob clob = (Clob)o;
            try {
                if (clob.length() == 0L) {
                    clob = null;
                    return clob;
                }
            }
            catch (SQLException sqlex) {
                currentTable = this.m_descriptor.getSourceTableName();
                tableToPass = this.m_descriptor.getTargetTable();
                if (tableToPass == null) {
                    tableToPass = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(currentTable, Level.FINE, sqlex.getLocalizedMessage(), tableToPass, this.m_descriptor.getSourceSchema());
            }
        }
        return null;
    }

    private BLOB createDummyBlob() {
        try {
            byte[] emptyish = new byte[]{32};
            BLOB retblob = new BLOB((OracleConnection)this.m_targetConnection, emptyish);
            return retblob;
        }
        catch (SQLException sqlex) {
            String currentTable = this.m_descriptor.getSourceTableName();
            MdTable tableToPass = this.m_descriptor.getTargetTable();
            if (tableToPass == null) {
                tableToPass = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(currentTable, Level.FINE, sqlex.getLocalizedMessage(), tableToPass, this.m_descriptor.getSourceSchema());
            return null;
        }
    }

    private CLOB createDummyClob() {
        try {
            byte[] emptyish = new byte[]{32};
            CLOB retclob = new CLOB((OracleConnection)this.m_targetConnection, emptyish);
            return retclob;
        }
        catch (SQLException sqlex) {
            String currentTable = this.m_descriptor.getSourceTableName();
            MdTable tableToPass = this.m_descriptor.getTargetTable();
            if (tableToPass == null) {
                tableToPass = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(currentTable, Level.WARNING, sqlex.getLocalizedMessage(), tableToPass, this.m_descriptor.getSourceSchema());
            return null;
        }
    }

    protected PreparedStatement createInsertPreparedStatement(String[] targetColNames) throws SQLException {
        StringBuffer sBuf = new StringBuffer();
        StringBuffer questionClause = new StringBuffer();
        sBuf.append("INSERT INTO ");
        sBuf.append(this.m_descriptor.getTargetTableName(this.m_qualifyNames));
        sBuf.append('(');
        for (int i = 0; i < targetColNames.length; ++i) {
            sBuf.append(targetColNames[i]);
            questionClause.append('?');
            if (i == targetColNames.length - 1) continue;
            sBuf.append(", ");
            questionClause.append(", ");
        }
        sBuf.append(") VALUES (");
        sBuf.append(questionClause);
        sBuf.append(')');
        PreparedStatement stmt = this.m_targetConnection.prepareStatement(sBuf.toString());
        return stmt;
    }

    protected String createSelectQuery() {
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("SELECT ");
        String[] colNames = this.m_descriptor.getSourceColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            sBuf.append(this.m_quoter.quoteIdentifier(colNames[i]));
            if (i == colNames.length - 1) continue;
            sBuf.append(", ");
        }
        sBuf.append(" FROM ");
        sBuf.append(this.m_descriptor.getSourceTableName());
        return sBuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getSourceRowCount() {
        long ret = -1L;
        CloseableResultSet crs = null;
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("SELECT COUNT(*) FROM ");
        sBuf.append(this.m_descriptor.getSourceTableName());
        try {
            try {
                Statement selectStmt = this.m_sourceConnection.createStatement();
                ResultSet rs = selectStmt.executeQuery(sBuf.toString());
                crs = new CloseableResultSet(selectStmt, rs);
                rs.next();
                ret = rs.getLong(1);
            }
            catch (SQLException sqlex) {
                String currentTable = this.m_descriptor.getSourceTableName();
                String message = MessageFormat.format(this.m_resourceBundle.getString("DataMove.FAILED_TO_OBTAIN_COUNT"), sqlex.getMessage());
                MdTable tableToPass = this.m_descriptor.getTargetTable();
                if (tableToPass == null) {
                    tableToPass = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(currentTable, Level.WARNING, message, tableToPass, this.m_descriptor.getSourceSchema());
                Object var10_9 = null;
                if (crs != null) {
                    crs.close();
                }
            }
            Object var10_8 = null;
            if (crs != null) {
                crs.close();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (crs != null) {
                crs.close();
            }
            throw throwable;
        }
        return ret;
    }

    private void incrementErrorCount() {
        this.m_stateVector.incrementErrorCount();
    }

    public String getId() {
        return this.m_stateVector.getId();
    }

    public DroneState getState() {
        return this.m_stateVector.takeSnapshot();
    }

    protected Connection getSourceConnection() {
        return this.m_sourceConnection;
    }

    protected void setSourceConnection(Connection sourceConnection) {
        this.m_sourceConnection = sourceConnection;
    }

    protected Connection getTargetConnection() {
        return this.m_targetConnection;
    }

    protected void setTargetConnection(Connection targetConnection) {
        this.m_targetConnection = targetConnection;
    }

    private static class DroneStateVector
    implements DroneState {
        private String m_currentProcessState;
        private String m_id;
        private int m_totalTablesMoved;
        private String m_currentTable;
        private long m_tableRowCount;
        private long m_rowsMoved;
        private int m_thisErrorCount;
        private int m_totalErrorCount;

        public DroneStateVector(String id) {
            this.setCurrentProcessState(DataMoveDrone.STATE_INITIALISING);
            this.setId(id);
            this.setCurrentTable(null);
            this.setRowsMoved(0L);
            this.setTableRowCount(0L);
            this.setThisErrorCount(0);
            this.setTotalErrorCount(0);
            this.setTotalTablesMoved(0);
        }

        public String getCurrentTable() {
            return this.m_currentTable;
        }

        public String getId() {
            return this.m_id;
        }

        public long getRowsMoved() {
            return this.m_rowsMoved;
        }

        public long getTableRowCount() {
            return this.m_tableRowCount;
        }

        public int getThisErrorCount() {
            return this.m_thisErrorCount;
        }

        public int getTotalErrorCount() {
            return this.m_totalErrorCount;
        }

        public int getTotalTablesMoved() {
            return this.m_totalTablesMoved;
        }

        public String getProcessState() {
            return this.m_currentProcessState;
        }

        public DroneState takeSnapshot() {
            DroneStateVector dsv = new DroneStateVector(this.getId());
            dsv.setCurrentProcessState(this.getProcessState());
            dsv.setCurrentTable(this.getCurrentTable());
            dsv.setRowsMoved(this.getRowsMoved());
            dsv.setTableRowCount(this.getTableRowCount());
            dsv.setThisErrorCount(this.getThisErrorCount());
            dsv.setTotalErrorCount(this.getTotalErrorCount());
            dsv.setTotalTablesMoved(this.getTotalTablesMoved());
            return dsv;
        }

        void setCurrentProcessState(String currentProcessState) {
            this.m_currentProcessState = currentProcessState;
        }

        void setCurrentTable(String currentTable) {
            this.m_currentTable = currentTable;
        }

        void setId(String id) {
            this.m_id = id;
        }

        void setRowsMoved(long rowsMoved) {
            this.m_rowsMoved = rowsMoved;
        }

        void setTableRowCount(long tableRowCount) {
            this.m_tableRowCount = tableRowCount;
        }

        void setThisErrorCount(int thisErrorCount) {
            this.m_thisErrorCount = thisErrorCount;
        }

        void setTotalErrorCount(int totalErrorCount) {
            this.m_totalErrorCount = totalErrorCount;
        }

        void setTotalTablesMoved(int totalTablesMoved) {
            this.m_totalTablesMoved = totalTablesMoved;
        }

        void incrementErrorCount() {
            ++this.m_thisErrorCount;
            ++this.m_totalErrorCount;
        }

        void newTable(String tableName) {
            this.setCurrentProcessState(DataMoveDrone.STATE_INITIALISING);
            this.setCurrentTable(tableName);
            this.setRowsMoved(0L);
            this.setTableRowCount(-1L);
            this.setThisErrorCount(0);
        }

        public String toLogString() {
            StringBuffer sBuf = new StringBuffer();
            sBuf.append("Data Move information:");
            sBuf.append("Rows : ");
            sBuf.append(this.m_rowsMoved);
            sBuf.append(" Errors: ");
            sBuf.append(this.m_thisErrorCount);
            return sBuf.toString();
        }
    }
}

