/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.migration.datamove.online.DataMoveDrone;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveListener;
import oracle.dbtools.migration.datamove.online.DroneState;
import oracle.dbtools.migration.datamove.online.ProgressCellRenderer;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;

public class DataMoveGui
implements DataMoveListener {
    private static final String[] S_CURRENT_ACTIVITY_HEADINGS = new String[]{MigrationAddinArb.getString(262), MigrationAddinArb.getString(263), MigrationAddinArb.getString(264), MigrationAddinArb.getString(265), MigrationAddinArb.getString(266), MigrationAddinArb.getString(267), MigrationAddinArb.getString(268)};
    private static final String[] S_FINISHED_ACTIVITY_HEADINGS = new String[]{MigrationAddinArb.getString(263), MigrationAddinArb.getString(265), MigrationAddinArb.getString(266), MigrationAddinArb.getString(267), MigrationAddinArb.getString(268)};
    private JPanel m_currentActivityPanel;
    private JTable m_currentActiviyTable;
    private DefaultTableModel m_currentActivityTableModel;
    private JPanel m_finishedActivityPanel;
    private JTable m_finishedActivityTable;
    private DefaultTableModel m_finishedActivityTableModel = new DefaultTableModel();

    public String[] getColumnNames() {
        return S_CURRENT_ACTIVITY_HEADINGS;
    }

    public String[] getBelowColumnNames() {
        return S_FINISHED_ACTIVITY_HEADINGS;
    }

    public void setTableCellRenderer() {
    }

    public int getPanelWidth() {
        return 500;
    }

    public JPanel getCurrentActivityPanel() {
        if (this.m_currentActivityPanel == null) {
            this.m_currentActivityPanel = new JPanel();
            BorderLayout layout = new BorderLayout();
            layout.setVgap(5);
            this.m_currentActivityPanel.setLayout(layout);
            this.m_currentActivityPanel.setPreferredSize(new Dimension(this.getPanelWidth(), 125));
            JScrollPane topPanelScrollPane = new JScrollPane();
            this.m_currentActivityPanel.add((Component)topPanelScrollPane, "Center");
            topPanelScrollPane.setHorizontalScrollBarPolicy(32);
            topPanelScrollPane.setVerticalScrollBarPolicy(22);
            this.m_currentActivityTableModel = new DefaultTableModel(null, S_CURRENT_ACTIVITY_HEADINGS){

                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.m_currentActiviyTable = new JTable(){

                public String getToolTipText(MouseEvent event) {
                    Object valueAt;
                    String tip = null;
                    Point p = event.getPoint();
                    int rowIndex = this.rowAtPoint(p);
                    int colIndex = this.columnAtPoint(p);
                    int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                    if ((realColumnIndex > 0 || realColumnIndex < 7) && (valueAt = this.getValueAt(rowIndex, 1)) != null) {
                        tip = valueAt.toString();
                    }
                    return tip;
                }
            };
            this.m_currentActiviyTable.setModel(this.m_currentActivityTableModel);
            ProgressCellRenderer progressCellRenderer = new ProgressCellRenderer();
            TableColumnModel tableColumnModel = this.m_currentActiviyTable.getColumnModel();
            tableColumnModel.getColumn(3).setCellRenderer(progressCellRenderer);
            topPanelScrollPane.setViewportView(this.m_currentActiviyTable);
            this.setTableCellRenderer();
            JLabel lab = new JLabel();
            lab.setText(MigrationAddinArb.getString(271));
            this.m_currentActivityPanel.add((Component)lab, "North");
        }
        return this.m_currentActivityPanel;
    }

    public JPanel getCompletedActivityPanel() {
        if (this.m_finishedActivityPanel == null) {
            BorderLayout layout = new BorderLayout();
            layout.setVgap(5);
            this.m_finishedActivityPanel = new JPanel(layout);
            this.m_finishedActivityPanel.setPreferredSize(new Dimension(this.getPanelWidth(), 125));
            JLabel lab = new JLabel();
            lab.setText(MigrationAddinArb.getString(272));
            this.m_finishedActivityPanel.add((Component)lab, "North");
            JScrollPane topPanelScrollPane = new JScrollPane();
            this.m_finishedActivityPanel.add((Component)topPanelScrollPane, "Center");
            topPanelScrollPane.setHorizontalScrollBarPolicy(32);
            topPanelScrollPane.setVerticalScrollBarPolicy(22);
            Object[] columnNames = this.getBelowColumnNames();
            this.m_finishedActivityTableModel = new DefaultTableModel(null, columnNames){

                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.m_finishedActivityTable = new JTable(){

                public String getToolTipText(MouseEvent event) {
                    String tip = null;
                    Point p = event.getPoint();
                    int rowIndex = this.rowAtPoint(p);
                    int colIndex = this.columnAtPoint(p);
                    int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                    if (realColumnIndex > 0 || realColumnIndex < 4) {
                        tip = this.getValueAt(rowIndex, 0).toString();
                    }
                    return tip;
                }
            };
            topPanelScrollPane.setViewportView(this.m_finishedActivityTable);
            this.m_finishedActivityTable.setModel(this.m_finishedActivityTableModel);
        }
        return this.m_finishedActivityPanel;
    }

    public void raiseEvent(DataMoveEvent event) {
        int totalTablesCompleted = 0;
        if (event.getEventId() == 3) {
            DroneState state;
            DataMoveDrone drone = (DataMoveDrone)event.getSupplementaryData();
            if (drone != null && (state = drone.getState()).getCurrentTable().length() != 0) {
                Vector<String> vec = new Vector<String>();
                vec.add(state.getCurrentTable());
                vec.add(new Long(state.getRowsMoved()).toString());
                String s = state.getTableRowCount() == -1L ? "unknown" : Long.valueOf(state.getTableRowCount());
                vec.add(s.toString());
                vec.add(new Long(state.getThisErrorCount()).toString());
                vec.add(new Long(state.getTotalErrorCount()).toString());
                this.m_finishedActivityTableModel.addRow(vec);
                this.m_finishedActivityTable.scrollRectToVisible(this.m_finishedActivityTable.getCellRect(this.m_finishedActivityTableModel.getRowCount() - 1, 0, true));
                this.m_finishedActivityTableModel.fireTableDataChanged();
            }
        } else {
            DroneState[] dsArray = (DroneState[])event.getSupplementaryData();
            if (dsArray != null) {
                while (this.m_currentActivityTableModel.getRowCount() < dsArray.length) {
                    Object[] row = new Object[this.getColumnNames().length];
                    this.m_currentActivityTableModel.addRow(row);
                }
                this.m_currentActivityTableModel.fireTableDataChanged();
                for (int i = 0; i < dsArray.length; ++i) {
                    totalTablesCompleted += dsArray[i].getTotalTablesMoved();
                    this.m_currentActivityTableModel.setValueAt(dsArray[i].getId(), i, 0);
                    this.m_currentActivityTableModel.setValueAt(dsArray[i].getCurrentTable(), i, 1);
                    this.m_currentActivityTableModel.setValueAt(dsArray[i].getProcessState(), i, 2);
                    this.m_currentActivityTableModel.setValueAt(dsArray[i].getRowsMoved(), i, 3);
                    this.m_currentActivityTableModel.setValueAt(dsArray[i].getTableRowCount() == -1L ? "unknown" : Long.valueOf(dsArray[i].getTableRowCount()), i, 4);
                    this.m_currentActivityTableModel.setValueAt(dsArray[i].getThisErrorCount(), i, 5);
                    this.m_currentActivityTableModel.setValueAt(dsArray[i].getTotalErrorCount(), i, 6);
                }
                this.m_currentActivityTableModel.fireTableDataChanged();
            }
        }
    }
}

