/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MgvAllTablesRec;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.datamove.DataMoveException;
import oracle.dbtools.migration.datamove.DataMoveMarshal;
import oracle.dbtools.migration.datamove.DataMoveUtils;
import oracle.dbtools.migration.datamove.online.ConstraintHandler;
import oracle.dbtools.migration.datamove.online.DataMoveAudience;
import oracle.dbtools.migration.datamove.online.DataMoveDrone;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveListener;
import oracle.dbtools.migration.datamove.online.DroneState;
import oracle.dbtools.migration.datamove.online.TriggerHandler;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.db.ConnectionException;

public class DataMoveWorker
implements DataMoveMarshal,
Cancelable {
    public static final String MY_ID = "DataMoveWorker";
    private PersistenceManager m_persistenceManager;
    private PersistenceUtility m_persistenceUtility;
    private String m_sourceConnectionName;
    private String m_targetConnectionName;
    private DBObjectId m_targetConnectionId;
    private DataMoveDrone[] m_drones;
    private CloseableIterator<MgvAllTablesRec> m_tables;
    private boolean m_cancelled = false;
    private DataMoveAudience m_audience;
    private boolean m_getCounts;
    private ConstraintHandler m_constraintHandler;
    private TriggerHandler m_triggerHandler;
    private boolean m_qualifyNames;
    private Connection m_targetMaster = null;

    public DataMoveWorker(PersistenceManager pman, String sourceConnectionName, String targetConnectionName, DBObjectId targetConnectionId, int maxThreads, boolean getCounts, int commitInterval, boolean qualifyNames) throws DataMoveException {
        if (commitInterval < 1) {
            throw new IllegalArgumentException("Commit interval must be at least 1");
        }
        if (maxThreads == 0) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.FINE, "DataMove.WONG_NUMBER_OF_THREADS");
            maxThreads = 1;
        }
        this.m_qualifyNames = qualifyNames;
        this.setPersistenceManager(pman);
        this.setPersistenceUtility(PersistenceUtility.getInstance(pman));
        this.setSourceConnectionName(sourceConnectionName);
        this.setTargetConnectionName(targetConnectionName);
        this.setTargetConnectionId(targetConnectionId);
        this.m_audience = new DataMoveAudience();
        this.m_getCounts = getCounts;
        try {
            this.createDrones(maxThreads, commitInterval, qualifyNames);
        }
        catch (CMException cmex) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.SEVERE, "DataMove.CLONE_CONNECTION_FAILED", cmex.getLocalizedMessage());
            throw new DataMoveException((Exception)((Object)cmex));
        }
    }

    public DataMoveWorker(PersistenceManager pman, String sourceConnectionName, String targetConnectionName, DBObjectId targetConnectionId, int maxThreads, int commitInterval, boolean qualifyNames) throws DataMoveException {
        this(pman, sourceConnectionName, targetConnectionName, targetConnectionId, maxThreads, true, commitInterval, qualifyNames);
    }

    public void addListener(DataMoveListener listener) {
        this.m_audience.addListener(listener);
    }

    protected void createDrones(int numToCreate, int commitInterval, boolean qualifyNames) throws CMException, DataMoveException {
        MigrationPlugin plugin = DataMoveUtils.findPluginUsed(this.m_targetConnectionId, this.m_persistenceManager);
        if (plugin == null) {
            throw new DataMoveException(new IllegalStateException(MigrationAddinArb.getString(270)));
        }
        Connections raptorConnectionManager = Connections.getInstance();
        Connection sourceMaster = null;
        try {
            sourceMaster = raptorConnectionManager.getConnection(this.m_sourceConnectionName);
            this.m_targetMaster = raptorConnectionManager.getConnection(this.m_targetConnectionName);
        }
        catch (DBException e) {
            // empty catch block
        }
        this.m_constraintHandler = new ConstraintHandler(this.m_targetConnectionId, this.getPersistenceManager());
        this.m_triggerHandler = new TriggerHandler(this.m_targetConnectionId, this.getPersistenceManager());
        this.m_drones = new DataMoveDrone[numToCreate];
        Connection source = null;
        Connection target = null;
        for (int i = 0; i < numToCreate; ++i) {
            DataMoveDrone drone;
            try {
                source = raptorConnectionManager.cloneConnection(sourceMaster);
                target = raptorConnectionManager.cloneConnection(this.m_targetMaster);
            }
            catch (ConnectionException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            this.m_drones[i] = drone = new DataMoveDrone("DataMove-" + i, this, source, target, plugin.getQuoter(), this.m_getCounts, commitInterval, this.m_audience, qualifyNames);
        }
    }

    public void doWork() throws PersistenceException {
        boolean complete = false;
        try {
            this.m_constraintHandler.disableConstraints(this.m_targetMaster, this.m_qualifyNames);
        }
        catch (SQLException sqlex) {
            this.m_constraintHandler.reenableConstraints(this.m_targetMaster, this.m_qualifyNames);
            return;
        }
        this.m_triggerHandler.disableTriggers(this.m_targetMaster, this.m_qualifyNames);
        this.m_tables = this.getPersistenceUtility().getTablesForConnectionId(this.m_targetConnectionId);
        for (DataMoveDrone drone : this.m_drones) {
            Thread t = new Thread((Runnable)drone, drone.getId());
            t.start();
        }
        while (!complete) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_cancelled) break;
            complete = this.reportState(1);
        }
        this.reportState(2);
        this.m_drones = null;
        this.m_constraintHandler.reenableConstraints(this.m_targetMaster, this.m_qualifyNames);
        this.m_triggerHandler.enableTriggers(this.m_targetMaster, this.m_qualifyNames);
    }

    private boolean reportState(int eventId) {
        boolean allFinished = true;
        if (this.m_drones != null) {
            DroneState[] currentStatus = new DroneState[this.m_drones.length];
            for (int i = 0; i < this.m_drones.length; ++i) {
                currentStatus[i] = this.m_drones[i].getState();
                if (currentStatus[i].getProcessState().equals("FINISHED")) continue;
                allFinished = false;
            }
            DataMoveEvent event = new DataMoveEvent(eventId, MY_ID, currentStatus);
            this.m_audience.fireListeners(event);
        }
        return allFinished;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    protected void setSourceConnectionName(String sourceConnectionName) {
        this.m_sourceConnectionName = sourceConnectionName;
    }

    protected void setTargetConnectionName(String targetConnectionName) {
        this.m_targetConnectionName = targetConnectionName;
    }

    protected void setTargetConnectionId(DBObjectId targetConnectionId) {
        this.m_targetConnectionId = targetConnectionId;
    }

    public synchronized DataMoveDescriptor getDescriptor() {
        if (!this.m_tables.hasNext()) {
            return null;
        }
        MgvAllTablesRec tableRec = (MgvAllTablesRec)this.m_tables.next();
        try {
            DataMoveDescriptor descriptor = DataMoveUtils.loadDescriptor(this.m_persistenceManager, tableRec.getTableId(), this.m_targetConnectionId);
            return descriptor;
        }
        catch (PersistenceException pex) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.SEVERE, "DataMove.RETRIEVE_DESCRIPTOR_FAILED", pex.getLocalizedMessage());
            return null;
        }
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected PersistenceUtility getPersistenceUtility() {
        return this.m_persistenceUtility;
    }

    protected void setPersistenceUtility(PersistenceUtility persistenceUtility) {
        this.m_persistenceUtility = persistenceUtility;
    }

    public void signalCancel() {
        this.m_cancelled = true;
        if (this.m_drones != null) {
            for (DataMoveDrone drone : this.m_drones) {
                drone.signalCancel();
            }
        }
        DataMoveEvent event = new DataMoveEvent(-1, MY_ID, null);
        this.m_audience.fireListeners(event);
    }

    public DataMoveAudience getAudience() {
        return this.m_audience;
    }
}

