/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;

public class TableMetaData {
    private MdTable m_table;
    private ArrayList<MdColumn> m_columns;
    private ArrayList<MdConstraint> m_constraints;

    public TableMetaData(MdTable table) {
        this(table, null);
    }

    public TableMetaData(MdTable table, MdColumn[] columns) {
        this.setTable(table);
        this.m_columns = new ArrayList();
        this.m_constraints = new ArrayList();
        if (columns != null) {
            for (MdColumn col : columns) {
                this.m_columns.add(col);
            }
        }
    }

    protected void setTable(MdTable table) {
        this.m_table = table;
    }

    public MdTable getTable() {
        return this.m_table;
    }

    public void addColumn(MdColumn column) {
        this.m_columns.add(column);
    }

    public void addConstraint(MdConstraint constraint) {
        this.m_constraints.add(constraint);
    }

    public MdColumn[] getColumns() {
        return this.m_columns.toArray(new MdColumn[this.m_columns.size()]);
    }

    public MdConstraint[] getConstraints() {
        return this.m_constraints.toArray(new MdConstraint[this.m_constraints.size()]);
    }

    public void loadUpDetails(PersistenceUtility util) throws PersistenceException {
        CloseableIterator cols = util.getColumnsForTableId(this.m_table.getKey());
        while (cols.hasNext()) {
            MdColumn col = (MdColumn)cols.next();
            this.addColumn(col);
        }
        CloseableIterator constraints = util.getConstraintsForTableId(this.m_table.getKey());
        while (constraints.hasNext()) {
            MdConstraint constraint = (MdConstraint)constraints.next();
            this.addConstraint(constraint);
        }
    }
}

