/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.offline.OfflineDatamoveOutputStream;

public class TriggerHandler {
    private static final int ORA_ERR_NO_SUCH_TRIGGER = 4080;
    private static Logger s_log = Logger.getLogger("oracle.dbtools.migration");
    private HashSet<TriggerInformation> m_disabledTriggers = new HashSet();
    private static final String GET_TRIGGERS_QUERY = "SELECT TRIGGER_NAME, SCHEMA_NAME FROM MGV_ALL_TABLE_TRIGGERS WHERE CONNECTION_ID = ?";
    private DBObjectId m_connectionId;
    private PersistenceManager m_persistenceManager;

    public TriggerHandler(DBObjectId connectionId, PersistenceManager pman) {
        this.setConnectionId(connectionId);
        this.setPersistenceManager(pman);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableTriggers(OfflineDatamoveOutputStream output, Connection conn, boolean qualifyNames) {
        if (output == null && conn == null) {
            throw new IllegalArgumentException("output and conn cannot both be null");
        }
        if (output != null && conn != null) {
            throw new IllegalArgumentException("both output and conn should not be set");
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.m_persistenceManager.getPreparedStatement(GET_TRIGGERS_QUERY);
                stmt.setLong(1, this.m_connectionId.getId());
                rs = stmt.executeQuery();
            }
            catch (SQLException sqlex) {
                s_log.warning(sqlex.getLocalizedMessage());
                Object var9_9 = null;
                CloseableResultSet.close(null, rs);
                return;
            }
            try {
                if (rs != null) {
                    while (rs.next()) {
                        boolean worked;
                        TriggerInformation ti = new TriggerInformation(rs);
                        if (conn != null) {
                            worked = this.issueTriggerStmt(conn, ti.getDisableStatment(qualifyNames));
                        } else {
                            output.println(ti.getDisableStatment(qualifyNames) + ";");
                            worked = true;
                        }
                        if (!worked) continue;
                        this.m_disabledTriggers.add(ti);
                    }
                }
                rs.close();
                stmt.close();
            }
            catch (SQLException sqlex) {
                s_log.warning(sqlex.getLocalizedMessage());
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            CloseableResultSet.close(null, rs);
            throw throwable;
        }
        CloseableResultSet.close(null, rs);
    }

    public void disableTriggers(OfflineDatamoveOutputStream output, boolean qualifyNames) {
        this.disableTriggers(output, null, qualifyNames);
    }

    public void disableTriggers(Connection conn, boolean qualifyNames) {
        this.disableTriggers(null, conn, qualifyNames);
    }

    private void enableTriggers(OfflineDatamoveOutputStream output, Connection conn, boolean qualifyNames) {
        for (TriggerInformation ti : this.m_disabledTriggers) {
            if (conn != null) {
                this.issueTriggerStmt(conn, ti.getEnableStatement(qualifyNames));
                continue;
            }
            output.println(ti.getEnableStatement(qualifyNames) + ";");
        }
    }

    public void enableTriggers(OfflineDatamoveOutputStream output, boolean qualifyNames) {
        this.enableTriggers(output, null, qualifyNames);
    }

    public void enableTriggers(Connection conn, boolean qualifyNames) {
        this.enableTriggers(null, conn, qualifyNames);
    }

    protected void setConnectionId(DBObjectId connectionId) {
        this.m_connectionId = connectionId;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    private boolean issueTriggerStmt(Connection conn, String sql) {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(sql);
            stmt.close();
            return true;
        }
        catch (SQLException sqlex) {
            if (sqlex.getErrorCode() != 4080) {
                s_log.warning(sqlex.getLocalizedMessage());
            }
            return false;
        }
    }

    private static class TriggerInformation {
        private String m_triggerName;
        private String m_schemaName;

        public TriggerInformation(ResultSet rs) throws SQLException {
            this.m_triggerName = rs.getString(1);
            this.m_schemaName = rs.getString(2);
        }

        private String getAlterStatement(boolean qualifyNames) {
            StringBuffer sBuf = new StringBuffer("ALTER TRIGGER ");
            if (qualifyNames) {
                sBuf.append(this.m_schemaName);
                sBuf.append('.');
            }
            sBuf.append(this.m_triggerName);
            return sBuf.toString();
        }

        public String getDisableStatment(boolean qualifyNames) {
            return this.getAlterStatement(qualifyNames) + " DISABLE";
        }

        public String getEnableStatement(boolean qualifyNames) {
            return this.getAlterStatement(qualifyNames) + " ENABLE";
        }
    }
}

