/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdPackage;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSequence;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdSynonym;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.generate.GenerateAudience;
import oracle.dbtools.migration.generate.GenerateEvent;
import oracle.dbtools.migration.generate.GenerateEventListener;
import oracle.dbtools.migration.generate.GenerateException;
import oracle.dbtools.migration.generate.GenerationOutputStream;
import oracle.dbtools.migration.generate.GroupsFromGroupIterator;
import oracle.dbtools.migration.generate.MigrGenerationOrderIterator;
import oracle.dbtools.migration.generate.SchemasFromGroupIterator;
import oracle.dbtools.migration.generate.UntranslatedStoredProgramsIterator;
import oracle.dbtools.migration.generate.UntranslatedTriggersIterator;
import oracle.dbtools.migration.generate.UntranslatedViewsIterator;
import oracle.dbtools.migration.persistence.MigrGenerationOrder;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateWorker
implements Cancelable {
    private PersistenceManager m_persistenceManager;
    private DBObjectId m_connectionId;
    private GenerationOutputStream m_outputStream;
    private StringTemplateGroup m_templateGroup;
    private PersistenceUtility m_persistenceUtility;
    private GenerateAudience m_audience;
    private boolean m_shouldCancel = false;
    private String m_templateName;
    private static final String DEFAULT_TEMPLATE_NAME = "10g";
    private MigrationObjectFilterList m_filters;
    private static final SimpleDateFormat S_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private ArrayList<String> m_viewsListForRecompile;
    private static Logger s_log = Logger.getLogger("oracle.dbtools.migration");
    private boolean m_tablesOnly = false;
    private Hashtable<DBObjectId, MdSchema> m_schemaCache = new Hashtable();
    private int m_numSchema;
    private String m_dataMoveUser;
    private boolean m_attemptLeastPrivilege;

    public GenerateWorker(PersistenceManager pman, DBObjectId connectionId, GenerationOutputStream outputStream, String templateName, MigrationObjectFilterList filters) {
        this.setPersistenceManager(pman);
        this.setPersistenceUtility(PersistenceUtility.getInstance(pman));
        this.setConnectionId(connectionId);
        this.setOutputStream(outputStream);
        this.loadTemplates();
        this.m_audience = new GenerateAudience();
        this.setTemplateName(templateName);
        this.setFilters(filters);
    }

    public GenerateWorker(PersistenceManager pman, DBObjectId connectionId, GenerationOutputStream outputStream, MigrationObjectFilterList filters) {
        this(pman, connectionId, outputStream, DEFAULT_TEMPLATE_NAME, filters);
    }

    private void loadTemplates() {
        CommonGroupLoader loader = new CommonGroupLoader("oracle/dbtools/migration/generate/templates", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)loader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
    }

    public boolean runGenerate(boolean attemptLeastPrivilege) throws GenerateException {
        try {
            MigrationLogUtil.startMigrationLogSession(this.getConnectionId());
            GenerateEvent generateEvent = new GenerateEvent(4, "", MigrationAddinArb.getString(161));
            this.fireEventListeners(generateEvent);
            this.m_attemptLeastPrivilege = attemptLeastPrivilege;
            this.m_numSchema = this.findSchemaCount();
            this.generateCreateUsers();
            this.generateSchema();
            if (this.shouldCancel()) {
                return false;
            }
            generateEvent.setEventId(5);
            this.fireEventListeners(generateEvent);
        }
        catch (PersistenceException pex) {
            GenerateEvent generateEvent = new GenerateEvent(6, "", pex.getLocalizedMessage());
            s_log.log(Level.SEVERE, "Generate", new Object[]{pex.getLocalizedMessage(), generateEvent.getEventSource(), new ClickableLogInfo(generateEvent.getEventSource(), "Generate")});
            this.fireEventListeners(generateEvent);
            return false;
        }
        catch (NoSuchObjectException nsoe) {
            GenerateEvent generateEvent = new GenerateEvent(6, "", nsoe.getLocalizedMessage());
            s_log.log(Level.SEVERE, "Generate", new Object[]{nsoe.getLocalizedMessage(), generateEvent.getEventSource(), new ClickableLogInfo(generateEvent.getEventSource(), "Generate")});
            this.fireEventListeners(generateEvent);
            return false;
        }
        return true;
    }

    public int findSchemaCount() throws PersistenceException {
        return this.getPersistenceUtility().getSchemaCountForConnectionId(this.getConnectionId(), this.m_filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCreateUsers() throws PersistenceException, NoSuchObjectException, GenerateException {
        String ddl;
        StringTemplate template;
        CloseableIterator<MgvAllCatalogsRec> allCatalogs = this.m_persistenceUtility.getCatalogsForConnectionId(this.getConnectionId(), this.m_filters);
        boolean generateCreateUser = this.m_numSchema != 1 || !this.m_attemptLeastPrivilege;
        MgvAllCatalogsRec catRec = (MgvAllCatalogsRec)allCatalogs.next();
        allCatalogs.close();
        CloseableIterator allSchemas = this.m_persistenceUtility.getSchemasforCatalogId(catRec.getCatalogId(), this.m_filters);
        try {
            this.getOutputStream().startPreamble("Generated-" + S_DATEFORMAT.format(Calendar.getInstance().getTime()));
        }
        catch (FileNotFoundException fnfe) {
            throw new GenerateException(fnfe);
        }
        catch (UnsupportedEncodingException uee) {
            throw new GenerateException(uee);
        }
        this.getOutputStream().println("SET SCAN OFF;");
        while (allSchemas.hasNext()) {
            Object var13_13;
            GenerateEvent event;
            if (this.shouldCancel()) {
                allSchemas.close();
                event = new GenerateEvent(3, null, null);
                this.fireEventListeners(event);
                return;
            }
            MdSchema schema = (MdSchema)allSchemas.next();
            if (this.m_dataMoveUser == null) {
                this.m_dataMoveUser = schema.getName() + "_DMU";
                while (this.m_dataMoveUser.length() > 30) {
                    this.m_dataMoveUser = this.m_dataMoveUser.substring(2);
                }
            }
            this.m_schemaCache.put(schema.getKey(), schema);
            event = new GenerateEvent(1, MigrationAddinArb.getString(144), schema.getName());
            try {
                this.fireEventListeners(event);
                if (generateCreateUser) {
                    Object var11_12;
                    template = this.getTemplateGroup().getInstanceOf("CreateUser");
                    template.setAttribute("mdschema", (Object)schema);
                    template.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                    ddl = template.toString();
                    this.getOutputStream().println(ddl);
                    template.reset();
                    CloseableIterator<MdGroup> allGroups = null;
                    try {
                        allGroups = this.m_persistenceUtility.getGroupsForSchemaId(schema.getKey(), this.m_filters);
                        if (allGroups.hasNext()) {
                            template = this.getTemplateGroup().getInstanceOf("GrantCreateRole");
                            template.setAttribute("mdschema", (Object)schema);
                            template.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                            ddl = template.toString();
                            this.getOutputStream().println(ddl);
                            template.reset();
                        }
                        var11_12 = null;
                        if (allGroups != null) {
                            allGroups.close();
                        }
                    }
                    catch (Throwable throwable) {
                        var11_12 = null;
                        if (allGroups != null) {
                            allGroups.close();
                        }
                        throw throwable;
                    }
                }
                var13_13 = null;
            }
            catch (Throwable throwable) {
                var13_13 = null;
                event.setEventId(2);
                this.fireEventListeners(event);
                throw throwable;
            }
            event.setEventId(2);
            this.fireEventListeners(event);
            {
            }
        }
        if (this.m_numSchema > 1 && MigrationAddin.getMigrationConfig().getGenerateDataMoveUserFlag()) {
            template = this.getTemplateGroup().getInstanceOf("CreateDataMoveUser");
            template.setAttribute("username", (Object)this.m_dataMoveUser);
            ddl = template.toString();
            this.getOutputStream().println(ddl);
        }
        this.getOutputStream().endPreamble();
        allSchemas.close();
    }

    protected void generateSchema() throws PersistenceException, NoSuchObjectException, GenerateException {
        CloseableIterator<MgvAllCatalogsRec> allCatalogs = this.m_persistenceUtility.getCatalogsForConnectionId(this.getConnectionId(), this.m_filters);
        MgvAllCatalogsRec catRec = (MgvAllCatalogsRec)allCatalogs.next();
        allCatalogs.close();
        CloseableIterator allSchemas = this.m_persistenceUtility.getSchemasforCatalogId(catRec.getCatalogId(), this.m_filters);
        while (allSchemas.hasNext()) {
            if (this.shouldCancel()) {
                allSchemas.close();
                GenerateEvent event = new GenerateEvent(3, null, null);
                this.fireEventListeners(event);
                return;
            }
            MdSchema schema = (MdSchema)allSchemas.next();
            if (this.m_numSchema != 1 || !this.m_attemptLeastPrivilege) {
                this.getOutputStream().startSchema(schema.getName());
            }
            this.generateIndividualSchema(schema);
            this.getOutputStream().endSchema();
        }
        allSchemas.close();
        this.generateTranslatedObjects();
        for (MdSchema schema : this.m_schemaCache.values()) {
            this.generateConnect(schema);
            if (this.m_numSchema != 1 || !this.m_attemptLeastPrivilege) {
                this.getOutputStream().startSchema(schema.getName());
                this.generateRoleMembers(schema);
            }
            this.generateForeignKeyConstraints(schema);
            this.generateTriggers(schema);
            this.generateViews(schema);
            this.generateUntranslatedStoredProcedures(schema);
            this.generateRecompileViews();
            this.getOutputStream().endSchema();
        }
        this.getOutputStream().finished();
    }

    protected void generateForeignKeyConstraints(MdSchema schema) {
        CloseableIterator iter = null;
        try {
            iter = this.getPersistenceUtility().getForeignKeyConstraintsForSchemaId(schema.getKey());
        }
        catch (PersistenceException pex) {
            s_log.log(Level.SEVERE, "Generate.FOREIGNKEYCONSTRAINT", new Object[]{pex.getLocalizedMessage(), schema.getName()});
            return;
        }
        while (iter.hasNext()) {
            MdConstraint constraint = (MdConstraint)iter.next();
            try {
                MdTable table = MdTable.retrieveExistingInstance(this.getPersistenceManager(), constraint.getTableId());
                this.generateIndividualForeignKeyConstraint(table, constraint);
            }
            catch (NoSuchObjectException nsoe) {
                s_log.log(Level.SEVERE, "Generate.FOREIGNKEYCONSTRAINT", new Object[]{nsoe.getLocalizedMessage(), constraint.getName(), new ClickableLogInfo(constraint, "Generate")});
            }
            catch (PersistenceException pex) {
                s_log.log(Level.SEVERE, "Generate.FOREIGNKEYCONSTRAINT", new Object[]{pex.getLocalizedMessage(), constraint.getName(), new ClickableLogInfo(constraint, "Generate")});
            }
        }
    }

    protected void generateIndividualSchema(MdSchema schema) throws PersistenceException, NoSuchObjectException, GenerateException {
        boolean needConnect = this.m_numSchema != 1 || !this.m_attemptLeastPrivilege;
        StringTemplate template = this.getTemplateGroup().getInstanceOf("ConnectUser");
        GenerateEvent event = new GenerateEvent(1, MigrationAddinArb.getString(141), schema.getName());
        this.getOutputStream().startDatabase(schema.getName());
        this.getAudience().fireListeners(event);
        this.getOutputStream().startObject(schema.getName(), "MD_SCHEMAS");
        if (needConnect) {
            template.setAttribute("mdschema", (Object)schema);
            String ddl = template.toString();
            this.getOutputStream().println(ddl);
            schema.setNativeSql(ddl);
        }
        event.setEventId(2);
        this.getAudience().fireListeners(event);
        this.getOutputStream().endObject();
        if (needConnect) {
            schema.save(this.getPersistenceManager());
        }
        if (!this.m_tablesOnly) {
            this.generateEmulationPackage(schema);
            this.generateSequences(schema);
        }
        this.generateClobToBlob(schema);
        this.generateAllTables(schema);
        if (!this.m_tablesOnly && needConnect) {
            this.generateRoles(schema);
        }
        this.getOutputStream().endDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateTranslatedObjects() throws PersistenceException {
        MigrGenerationOrderIterator iter = null;
        PersistableObject currentSchema = null;
        try {
            iter = new MigrGenerationOrderIterator(this.getPersistenceManager(), this.m_connectionId);
            while (iter.hasNext()) {
                MigrGenerationOrder mgo = (MigrGenerationOrder)iter.next();
                try {
                    boolean newSchema;
                    MdSchema parent;
                    PersistableObject pobj = this.getPersistenceUtility().loadPersistableObject(mgo.getObjectId(), mgo.getObjectType());
                    if (pobj.getObjectType().equals("MD_CONSTRAINTS") || (parent = this.findParentSchema(pobj)) == null) continue;
                    boolean bl = newSchema = currentSchema == null || !parent.getKey().equals(currentSchema.getKey());
                    if (newSchema) {
                        this.generateConnect(parent);
                        currentSchema = parent;
                    }
                    try {
                        if (this.m_numSchema != 1 || !this.m_attemptLeastPrivilege) {
                            this.getOutputStream().startSchema(parent.getName());
                        }
                        this.generateIndividualPersistableObject(pobj);
                        this.getOutputStream().endSchema();
                    }
                    catch (IOException e) {
                        s_log.log(Level.FINE, "Generate.EXCEPTION", new Object[]{e.getLocalizedMessage(), pobj.getObjectName(), new ClickableLogInfo(pobj, "Generate")});
                    }
                    catch (GenerateException e) {
                        s_log.log(Level.FINE, "Generation.EXCEPTION", new Object[]{e.getLocalizedMessage(), pobj.getObjectName(), new ClickableLogInfo(pobj, "Generate")});
                    }
                }
                catch (NoSuchObjectException nsoe) {
                    s_log.log(Level.FINE, "Generate.FAILEDTORETRIEVEOBJECT", new Object[]{nsoe.getLocalizedMessage(), mgo.getObjectName(), new ClickableLogInfo(mgo, "Generate")});
                }
            }
            Object var9_11 = null;
            if (iter != null) {
                iter.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (iter != null) {
                iter.close();
            }
            throw throwable;
        }
    }

    private void generateConnect(MdSchema schema) {
        boolean needConnect;
        boolean bl = needConnect = this.m_numSchema != 1 || !this.m_attemptLeastPrivilege;
        if (needConnect) {
            StringTemplate template = this.getTemplateGroup().getInstanceOf("ConnectUser");
            template.setAttribute("mdschema", (Object)schema);
            String ddl = template.toString();
            this.getOutputStream().startObject("connect-" + schema.getName(), "sql");
            this.getOutputStream().println(ddl);
            this.getOutputStream().endObject();
        }
    }

    protected void generateIndividualPersistableObject(PersistableObject pobj) throws IOException, PersistenceException, NoSuchObjectException, GenerateException {
        String sType = pobj.getObjectType();
        if (sType.equals("MD_STORED_PROGRAMS")) {
            this.generateIndividualStoredProcedure((MdStoredProgram)pobj);
        } else if (sType.equals("MD_TRIGGERS")) {
            this.generateIndividualTrigger((MdTrigger)pobj);
        } else if (sType.equals("MD_CONSTRAINTS")) {
            this.generateIndividualConstraint((MdConstraint)pobj);
        } else if (sType.equals("MD_VIEWS")) {
            this.generateIndividualView((MdView)pobj);
        } else if (sType.equals("MD_PACKAGES")) {
            // empty if block
        }
    }

    private MdSchema findParentSchema(PersistableObject pobj) {
        DBObjectId parentSchemaId = null;
        MdSchema ret = null;
        String sType = pobj.getObjectType();
        if (sType.equals("MD_STORED_PROGRAMS")) {
            MdStoredProgram prog = (MdStoredProgram)pobj;
            parentSchemaId = prog.getSchemaId();
        } else if (sType.equals("MD_TRIGGERS")) {
            MdTrigger trigger = (MdTrigger)pobj;
            parentSchemaId = this.findParentSchemaId(trigger);
        } else if (sType.equals("MD_CONSTRAINTS")) {
            MdConstraint constraint = (MdConstraint)pobj;
            parentSchemaId = this.findParentSchemaId(constraint);
        } else if (sType.equals("MD_VIEWS")) {
            MdView view = (MdView)pobj;
            parentSchemaId = view.getSchemaId();
        } else if (sType.equals("MD_PACKAGES")) {
            MdPackage mdpackage = (MdPackage)pobj;
            parentSchemaId = mdpackage.getSchemaId();
        } else if (sType.equals("MD_TABLES")) {
            MdTable table = (MdTable)pobj;
            parentSchemaId = table.getSchemaId();
        }
        if (parentSchemaId != null && (ret = this.m_schemaCache.get(parentSchemaId)) == null) {
            try {
                ret = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), parentSchemaId);
            }
            catch (NoSuchObjectException nsoe) {
                MigrationLogUtil.logThrowable(nsoe.getLocalizedMessage(), "Generate", (Throwable)nsoe);
            }
            catch (PersistenceException e) {
                MigrationLogUtil.logThrowable(e.getLocalizedMessage(), "Generate", (Throwable)e);
            }
        }
        return ret;
    }

    private DBObjectId findParentSchemaId(MdTrigger trigger) {
        try {
            if (trigger.getTriggerOnFlag().equals("T")) {
                MdTable table = MdTable.retrieveExistingInstance(this.getPersistenceManager(), trigger.getTableOrViewId());
                return table.getSchemaId();
            }
            MdView view = MdView.retrieveExistingInstance(this.getPersistenceManager(), trigger.getTableOrViewId());
            return view.getSchemaId();
        }
        catch (PersistenceException pex) {
            MigrationLogUtil.logThrowable(pex.getLocalizedMessage(), "Generate", (Throwable)pex);
        }
        catch (NoSuchObjectException nsoe) {
            MigrationLogUtil.logThrowable(nsoe.getLocalizedMessage(), "Generate", (Throwable)nsoe);
        }
        return null;
    }

    private DBObjectId findParentSchemaId(MdConstraint constraint) {
        try {
            MdTable table = MdTable.retrieveExistingInstance(this.getPersistenceManager(), constraint.getTableId());
            return table.getSchemaId();
        }
        catch (PersistenceException pex) {
            MigrationLogUtil.logThrowable(pex.getLocalizedMessage(), "Generate", (Throwable)pex);
        }
        catch (NoSuchObjectException nsoe) {
            MigrationLogUtil.logThrowable(nsoe.getLocalizedMessage(), "Generate", (Throwable)nsoe);
        }
        return null;
    }

    protected void generateRecompileViews() {
        List<String> listForRecompile = this.getListForRecompile();
        for (String viewName : listForRecompile) {
            String recomp = "ALTER VIEW " + viewName + " COMPILE;\n";
            StringTemplate template = this.getTemplateGroup().getInstanceOf("blindDump");
            template.reset();
            template.setAttribute("text", (Object)recomp);
            this.getOutputStream().startObject("recompile-" + viewName, "sql");
            this.getOutputStream().println(template.toString());
            this.getOutputStream().endObject();
        }
    }

    protected void generateClobToBlob(MdSchema schema) throws PersistenceException, GenerateException {
        MigrationPlugin mplugin = null;
        try {
            mplugin = MigrationUtils.getPluginForConnection(MdConnection.retrieveExistingInstance(this.getPersistenceManager(), this.m_connectionId));
        }
        catch (MigrationPluginException e) {
            mplugin = null;
        }
        catch (NoSuchObjectException e) {
            mplugin = null;
        }
        if (mplugin != null && mplugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob() && this.m_persistenceUtility.getHaveIaBlob(schema)) {
            String clobToBlob = "CREATE OR REPLACE PROCEDURE CLOBTOBLOB_sqldeveloper \n  ( \n    tableNameL      VARCHAR2 , \n    clobColumnNameL VARCHAR2, \n    blobColumnNameL VARCHAR2 ) \nAS \n  tableName      VARCHAR2 ( 500 ) := '';--to_UPPER(tableNameL); \n  clobColumnName VARCHAR2 ( 500 ) := '';--to_UPPER(clobColumNameL); \n  blobColumnName VARCHAR2 ( 500 ) := '';--to_UPPER(blobColumNameL); \n  tmpString      VARCHAR2 ( 500 ) := ''; \n  errorOut       BOOLEAN          := false; \n  inputLength    NUMBER; -- size of input CLOB \n  offSet         NUMBER := 1; \n  pieceMaxSize   NUMBER := 500;          -- the max size of each peice \n  piece          VARCHAR2 ( 500 CHAR ) ; -- these pieces will make up the entire CLOB \n  currentPlace   NUMBER := 1;            -- this is where were up to in the CLOB \n  blobLoc BLOB;                          -- blob locator in the table \n  clobLoc CLOB;                          -- clob locator pointsthis is the value from the dat file \n  myquery VARCHAR2 ( 2000 ) ; \n  -- THIS HAS TO BE CHANGED FOR SPECIFIC CUSTOMER TABLE \n  -- AND COLUMN NAMES \n  --CURSOR cur; \nTYPE cur_typ \nIS \n  REF \n  CURSOR; \n    cur cur_typ; \n    --cur_rec cur%ROWTYPE; \n  BEGIN \n    tableName      := UPPER ( tableNameL ) ; \n    clobColumnName := UPPER ( clobColumnNameL ) ; \n    blobColumnName := UPPER ( blobColumnNameL ) ; \n    BEGIN \n      EXECUTE immediate 'select table_name from user_tables where table_name = :1 ' INTO tmpString USING tableName; \n      IF ( tmpString != tableName ) THEN \n        errorOut     := true; \n      ELSE \n        BEGIN \n          EXECUTE immediate 'select COLUMN_NAME from user_tab_columns where table_name = :1 and COLUMN_NAME = :2 ' INTO tmpString USING tableName, clobColumnName; \n          IF ( tmpString != clobColumnName ) THEN \n            errorOut     := true; \n          ELSE \n            EXECUTE immediate 'select COLUMN_NAME from user_tab_columns where table_name = :1 and COLUMN_NAME = :2 ' INTO tmpString USING tableName, blobColumnName; \n            IF ( tmpString != blobColumnName ) THEN \n              errorOut     := true; \n            END IF; \n          END IF; \n        END; \n      END IF; \n    EXCEPTION \n    WHEN OTHERS THEN \n      errorOut := true; \n    END; \n    IF ( errorOut = true ) THEN \n      raise_application_error ( -20001, 'Invalid parameters' ) ; \n    END IF; \n    EXECUTE immediate 'update ' || tableName || ' set ' || blobColumnName || '= empty_blob() ' ; \n    myquery := 'SELECT '||clobColumnName||' clob_column , '||blobColumnName||' blob_column FROM ' || tableName || ' FOR UPDATE'; \n    OPEN cur FOR myquery;-- using clobColumName, blobColumnName ; \n    FETCH cur \n       INTO clobLoc, \n      blobLoc ; \n   \n  WHILE cur%FOUND \n  LOOP \n    --RETRIVE THE clobLoc and blobLoc \n    --clobLoc := cur_rec.clob_column; \n    --blobLoc := cur_rec.blob_column; \n    currentPlace := 1; -- reset evertime \n    -- find the lenght of the clob \n    inputLength := DBMS_LOB.getLength ( clobLoc ) ; \n    -- loop through each peice \n    LOOP \n      IF (inputLength > 0) \n      THEN \n      -- get the next piece and add it to the clob \n      piece := DBMS_LOB.subStr ( clobLoc,pieceMaxSize,currentPlace ) ; \n      -- append this piece to the BLOB \n      DBMS_LOB.WRITEAPPEND ( blobLoc, LENGTH ( piece ) /2, HEXTORAW ( piece ) ) ; \n      currentPlace := currentPlace                     + pieceMaxSize ; \n      END IF; \n      EXIT \n    WHEN inputLength < currentplace; \n    END LOOP; \n    FETCH cur \n       INTO clobLoc, \n      blobLoc ; \n  END LOOP; \n  EXECUTE immediate 'alter table ' || tableName || ' drop column ' || clobColumnName; \n  --unnecessary after ddl \n  COMMIT; \nEND CLOBtoBLOB_sqldeveloper;";
            GenerateEvent event = new GenerateEvent(1, MigrationAddinArb.getString(136), "");
            this.getOutputStream().startObject("CLOBTOBLOB_sqldeveloper", "MD_STORED_PROGRAMS");
            this.getAudience().fireListeners(event);
            StringTemplate template = this.getTemplateGroup().getInstanceOf("blindDump");
            template.setAttribute("text", (Object)clobToBlob);
            this.getOutputStream().println(template.toString());
            template.reset();
            template.setAttribute("text", (Object)"/\n");
            this.getOutputStream().println(template.toString());
            template.reset();
            template.setAttribute("text", (Object)"GRANT EXECUTE on CLOBTOBLOB_sqldeveloper TO PUBLIC;\n");
            this.getOutputStream().println(template.toString());
            template.reset();
            this.m_outputStream.endObject();
            event.setEventId(2);
            this.getAudience().fireListeners(event);
        }
    }

    protected void generateEmulationPackage(MdSchema schema) throws PersistenceException, GenerateException {
        try {
            MdPackage mdpackage = this.getPersistenceUtility().getEmulationPackageForSchema(schema.getKey());
            if (mdpackage != null) {
                GenerateEvent event = new GenerateEvent(1, MigrationAddinArb.getString(148), "");
                this.getOutputStream().startObject("Emulation", "MD_PACKAGES");
                this.getAudience().fireListeners(event);
                StringTemplate template = this.getTemplateGroup().getInstanceOf("blindDump");
                template.setAttribute("text", (Object)ConvertUtils.getClobAsString(mdpackage.getPackageHeader()));
                this.getOutputStream().println(template.toString());
                template.reset();
                template.setAttribute("text", (Object)"/\n");
                this.getOutputStream().println(template.toString());
                template.reset();
                template.setAttribute("text", (Object)ConvertUtils.getClobAsString(mdpackage.getNativeSql()));
                this.getOutputStream().println(template.toString());
                template.reset();
                template.setAttribute("text", (Object)"/\n");
                this.getOutputStream().println(template.toString());
                this.m_outputStream.endObject();
                event.setEventId(2);
                this.getAudience().fireListeners(event);
            } else {
                MdSynonym synonym = this.getPersistenceUtility().getEmulationSynonymForSchema(schema.getKey());
                if (synonym != null) {
                    GenerateEvent event = new GenerateEvent(1, MigrationAddinArb.getString(151), synonym.getName());
                    StringTemplate template = this.getTemplateGroup().getInstanceOf("blindDump");
                    template.setAttribute("text", (Object)synonym.getProperty("MIGRATIONEMULATION"));
                    this.getOutputStream().println(template.toString());
                    template.reset();
                }
            }
        }
        catch (PersistenceException pex) {
            MigrationLogUtil.logThrowable(pex.getLocalizedMessage(), "Generate", (Throwable)pex);
            throw new GenerateException(pex);
        }
        catch (NoSuchObjectException e) {
            MigrationLogUtil.logThrowable(e.getLocalizedMessage(), "Generate", (Throwable)e);
            throw new GenerateException(e);
        }
        catch (IOException ioe) {
            MigrationLogUtil.logThrowable(ioe.getLocalizedMessage(), "Generate", (Throwable)ioe);
            throw new GenerateException(ioe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void generateSequences(MdSchema schema) throws GenerateException {
        CloseableIterator<MdSequence> allSequences = null;
        try {
            try {
                allSequences = this.m_persistenceUtility.getSequencesForSchemaId(schema.getKey(), this.m_filters);
                while (true) {
                    if (allSequences.hasNext()) {
                        if (this.shouldCancel()) {
                            allSequences.close();
                            Object var7_7 = null;
                            if (allSequences == null) return;
                            allSequences.close();
                            return;
                        }
                        MdSequence sequence = (MdSequence)allSequences.next();
                        GenerateEvent event = new GenerateEvent(1, MigrationAddinArb.getString(149), sequence.getName());
                        this.getOutputStream().startObject(sequence.getName(), "MD_SEQUENCES");
                        this.getAudience().fireListeners(event);
                        StringTemplate template = this.getTemplateGroup().getInstanceOf("CreateSequence");
                        template.setAttribute("mdsequence", (Object)sequence);
                        template.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                        this.getOutputStream().println(template.toString());
                        this.getOutputStream().endObject();
                        event.setEventId(2);
                        this.getAudience().fireListeners(event);
                        template.reset();
                        continue;
                    }
                    break;
                }
            }
            catch (PersistenceException pex) {
                throw new GenerateException(pex);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (allSequences == null) throw throwable;
            allSequences.close();
            throw throwable;
        }
        Object var7_8 = null;
        if (allSequences == null) return;
        allSequences.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void generateRoles(MdSchema schema) throws GenerateException {
        CloseableIterator<MdGroup> allGroups = null;
        try {
            try {
                allGroups = this.m_persistenceUtility.getGroupsForSchemaId(schema.getKey(), this.m_filters);
                while (true) {
                    if (allGroups.hasNext()) {
                        if (this.shouldCancel()) {
                            allGroups.close();
                            Object var7_7 = null;
                            if (allGroups == null) return;
                            allGroups.close();
                            return;
                        }
                        MdGroup group = (MdGroup)allGroups.next();
                        if (group.getGroupFlag() == null || !group.getGroupFlag().equals("R")) continue;
                        GenerateEvent event = new GenerateEvent(1, MigrationAddinArb.getString(145), group.getGroupName());
                        this.getOutputStream().startObject(group.getGroupName(), "MD_GROUPS");
                        this.getAudience().fireListeners(event);
                        StringTemplate template = this.getTemplateGroup().getInstanceOf("CreateGroup");
                        template.setAttribute("mdgroup", (Object)group);
                        template.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                        this.getOutputStream().println(template.toString());
                        this.getOutputStream().endObject();
                        event.setEventId(2);
                        this.getAudience().fireListeners(event);
                        template.reset();
                        continue;
                    }
                    break;
                }
            }
            catch (PersistenceException pex) {
                throw new GenerateException(pex);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (allGroups == null) throw throwable;
            allGroups.close();
            throw throwable;
        }
        Object var7_8 = null;
        if (allGroups == null) return;
        allGroups.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateRoleMembers(MdSchema schema) throws GenerateException {
        CloseableIterator<MdGroup> allGroups = null;
        CloseableIterator allGroupsTo = null;
        CloseableIterator allSchemas = null;
        try {
            try {
                allGroups = this.m_persistenceUtility.getGroupsForSchemaId(schema.getKey(), this.m_filters);
                while (allGroups.hasNext()) {
                    StringTemplate template;
                    GenerateEvent event;
                    if (this.shouldCancel()) {
                        allGroups.close();
                        Object var10_10 = null;
                        if (allGroups != null) {
                            allGroups.close();
                        }
                        if (allSchemas != null) {
                            allSchemas.close();
                        }
                        if (allGroupsTo == null) return;
                        allGroupsTo.close();
                        return;
                    }
                    MdGroup group = (MdGroup)allGroups.next();
                    if (group.getGroupFlag() == null || !group.getGroupFlag().equals("R")) continue;
                    allSchemas = new SchemasFromGroupIterator(this.getPersistenceManager(), group.getKey(), this.m_filters);
                    while (allSchemas.hasNext()) {
                        MdSchema schemaTo = (MdSchema)allSchemas.next();
                        event = new GenerateEvent(1, MigrationAddinArb.getString(146), schemaTo.getName());
                        this.getOutputStream().startObject(group.getGroupName(), "MD_GROUP_MEMBERS");
                        this.getAudience().fireListeners(event);
                        template = this.getTemplateGroup().getInstanceOf("GrantRole");
                        template.setAttribute("mdgroup", (Object)group);
                        template.setAttribute("mdschema", (Object)schemaTo);
                        this.getOutputStream().println(template.toString());
                        this.getOutputStream().endObject();
                        event.setEventId(2);
                        this.getAudience().fireListeners(event);
                        template.reset();
                    }
                    if (allSchemas != null) {
                        allSchemas.close();
                    }
                    allGroupsTo = new GroupsFromGroupIterator(this.getPersistenceManager(), group.getKey(), this.m_filters);
                    while (allGroupsTo.hasNext()) {
                        MdGroup groupTo = (MdGroup)allGroupsTo.next();
                        event = new GenerateEvent(1, MigrationAddinArb.getString(146), groupTo.getGroupName());
                        this.getOutputStream().startObject(group.getGroupName(), "MD_GROUP_MEMBERS");
                        this.getAudience().fireListeners(event);
                        template = this.getTemplateGroup().getInstanceOf("GrantRoleToRole");
                        template.setAttribute("mdgroup", (Object)group);
                        template.setAttribute("mdgroupto", (Object)groupTo);
                        this.getOutputStream().println(template.toString());
                        this.getOutputStream().endObject();
                        event.setEventId(2);
                        this.getAudience().fireListeners(event);
                        template.reset();
                    }
                    if (allGroupsTo == null) continue;
                    allGroupsTo.close();
                }
            }
            catch (PersistenceException pex) {
                throw new GenerateException(pex);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (allGroups != null) {
                allGroups.close();
            }
            if (allSchemas != null) {
                allSchemas.close();
            }
            if (allGroupsTo == null) throw throwable;
            allGroupsTo.close();
            throw throwable;
        }
        Object var10_11 = null;
        if (allGroups != null) {
            allGroups.close();
        }
        if (allSchemas != null) {
            allSchemas.close();
        }
        if (allGroupsTo == null) return;
        allGroupsTo.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void generateTriggers(MdSchema schema) throws GenerateException {
        CloseableIterator allTriggers = null;
        try {
            try {
                allTriggers = new UntranslatedTriggersIterator(this.getPersistenceManager(), schema.getKey(), this.m_filters);
                while (true) {
                    if (allTriggers.hasNext()) {
                        if (this.shouldCancel()) {
                            allTriggers.close();
                            Object var5_6 = null;
                            if (allTriggers == null) return;
                            allTriggers.close();
                            return;
                        }
                        MdTrigger trigger = (MdTrigger)allTriggers.next();
                        this.generateIndividualTrigger(trigger);
                        continue;
                    }
                    break;
                }
            }
            catch (PersistenceException pex) {
                throw new GenerateException(pex);
            }
            catch (IOException ioe) {
                throw new GenerateException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (allTriggers == null) throw throwable;
            allTriggers.close();
            throw throwable;
        }
        Object var5_7 = null;
        if (allTriggers == null) return;
        allTriggers.close();
    }

    protected void generateIndividualTrigger(MdTrigger trigger) throws IOException {
        if (!trigger.getLanguage().equals("OracleSQL") && !MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
            s_log.log(Level.WARNING, "Generate.TRIGGERNOTCONVERTED", new Object[]{trigger.getTriggerName(), trigger.getLanguage(), new ClickableLogInfo(trigger, "Generate")});
        } else {
            GenerateEvent event = new GenerateEvent(1, MigrationAddinArb.getString(135), trigger.getTriggerName());
            this.getAudience().fireListeners(event);
            this.getOutputStream().startObject(trigger.getTriggerName(), "MD_TRIGGERS");
            StringTemplate template = this.getTemplateGroup().getInstanceOf("blindDump");
            template.setAttribute("text", (Object)ConvertUtils.getClobAsString(trigger.getNativeSql()));
            this.getOutputStream().println(template.toString());
            template.reset();
            template.setAttribute("text", (Object)"/\n");
            this.getOutputStream().println(template.toString());
            template.reset();
            this.getOutputStream().endObject();
            event.setEventId(2);
            this.getAudience().fireListeners(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateViews(MdSchema schema) throws PersistenceException, GenerateException {
        UntranslatedViewsIterator allViews = null;
        try {
            allViews = new UntranslatedViewsIterator(this.getPersistenceManager(), schema.getKey(), null);
            while (allViews.hasNext()) {
                if (this.shouldCancel()) {
                    allViews.close();
                    Object var6_4 = null;
                    if (allViews == null) return;
                    allViews.close();
                    return;
                }
                MdView view = (MdView)allViews.next();
                try {
                    this.generateIndividualView(view);
                }
                catch (IOException ioe) {
                    throw new GenerateException(ioe);
                }
            }
            Object var6_5 = null;
            if (allViews == null) return;
            allViews.close();
            return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (allViews == null) throw throwable;
            allViews.close();
            throw throwable;
        }
    }

    protected void generateIndividualView(MdView view) throws IOException {
        if (!view.getLanguage().equals("OracleSQL") && !MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
            s_log.log(Level.WARNING, "Generate.VIEWNOTCONVERTED", new Object[]{view.getViewName(), view.getLanguage(), new ClickableLogInfo(view, "Generate")});
            return;
        }
        List<String> listForRecompile = this.getListForRecompile();
        listForRecompile.add(view.getViewName());
        GenerateEvent event = new GenerateEvent(1, MigrationAddinArb.getString(137), view.getViewName());
        this.getAudience().fireListeners(event);
        this.getOutputStream().startObject(view.getViewName(), "MD_VIEWS");
        StringTemplate template = this.getTemplateGroup().getInstanceOf("blindDump");
        template.setAttribute("text", (Object)ConvertUtils.getClobAsString(view.getNativeSql()));
        this.getOutputStream().println(template.toString());
        template.reset();
        template.setAttribute("text", (Object)"\n");
        this.getOutputStream().println(template.toString());
        this.getOutputStream().endObject();
        event.setEventId(2);
        this.getAudience().fireListeners(event);
    }

    private List<String> getListForRecompile() {
        if (this.m_viewsListForRecompile == null) {
            this.m_viewsListForRecompile = new ArrayList();
        }
        return this.m_viewsListForRecompile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateUntranslatedStoredProcedures(MdSchema schema) throws PersistenceException, GenerateException {
        CloseableIterator allStoredProcs = null;
        try {
            allStoredProcs = new UntranslatedStoredProgramsIterator(this.getPersistenceManager(), schema.getKey(), this.m_filters);
            while (allStoredProcs.hasNext()) {
                if (this.shouldCancel()) {
                    allStoredProcs.close();
                    Object var5_5 = null;
                    if (allStoredProcs == null) return;
                    allStoredProcs.close();
                    return;
                }
                try {
                    MdStoredProgram program = (MdStoredProgram)allStoredProcs.next();
                    this.generateIndividualStoredProcedure(program);
                }
                catch (IOException ioe) {
                    throw new GenerateException(ioe);
                }
            }
            Object var5_6 = null;
            if (allStoredProcs == null) return;
            allStoredProcs.close();
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (allStoredProcs == null) throw throwable;
            allStoredProcs.close();
            throw throwable;
        }
    }

    protected void generateIndividualStoredProcedure(MdStoredProgram program) throws IOException {
        if (!program.getLanguage().equals("OracleSQL") && !MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, "Generate.PROCNOTCONVERTED", new Object[]{program.getName(), program.getLanguage(), new ClickableLogInfo(program, "Generate")});
            return;
        }
        GenerateEvent event = new GenerateEvent(1, MigrationAddinArb.getString(136), program.getName());
        this.getAudience().fireListeners(event);
        this.getOutputStream().startObject(program.getName(), "MD_STORED_PROGRAMS");
        StringTemplate template = this.getTemplateGroup().getInstanceOf("blindDump");
        template.setAttribute("text", (Object)ConvertUtils.getClobAsString(program.getNativeSql()));
        this.getOutputStream().println(template.toString());
        template.reset();
        template.setAttribute("text", (Object)"/");
        this.getOutputStream().println(template.toString());
        this.getOutputStream().endObject();
        event.setEventId(2);
        this.getAudience().fireListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void generateAllTables(MdSchema schema) throws PersistenceException {
        CloseableIterator allTables = this.m_persistenceUtility.getTablesForSchemaId(schema.getKey(), this.m_filters);
        try {
            while (true) {
                if (allTables.hasNext()) {
                    if (this.shouldCancel()) {
                        allTables.close();
                        Object var6_5 = null;
                        if (allTables == null) return;
                        allTables.close();
                        return;
                    }
                    MdTable table = (MdTable)allTables.next();
                    GenerateEvent event = new GenerateEvent(1, MigrationAddinArb.getString(138), table.getTableName());
                    this.fireEventListeners(event);
                    this.getOutputStream().startObject(table.getTableName(), "MD_TABLES");
                    this.generateIndividualTable(table);
                    this.getOutputStream().endObject();
                    event.setEventId(2);
                    this.fireEventListeners(event);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (allTables == null) throw throwable;
            allTables.close();
            throw throwable;
        }
        Object var6_6 = null;
        if (allTables == null) return;
        allTables.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateIndividualTable(MdTable table) throws PersistenceException {
        CloseableIterator cols = this.m_persistenceUtility.getColumnsForTableId(table.getKey());
        ArrayList<MdColumn> colArray = new ArrayList<MdColumn>();
        try {
            while (true) {
                if (cols.hasNext()) {
                    if (this.shouldCancel()) {
                        cols.close();
                        Object var6_5 = null;
                        cols.close();
                        return;
                    }
                    MdColumn column = (MdColumn)cols.next();
                    colArray.add(column);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            cols.close();
            throw throwable;
        }
        Object var6_6 = null;
        cols.close();
        StringTemplate template = this.getTemplateGroup().getInstanceOf("CreateTable");
        template.setAttribute("mdtable", (Object)table);
        template.setAttribute("colList", colArray);
        template.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
        String ddl = template.toString();
        this.getOutputStream().println(ddl);
        this.getOutputStream().println("");
        if (table.getComments() != null && table.getComments().length() > 0) {
            template = this.getTemplateGroup().getInstanceOf("TableComment");
            template.setAttribute("tableName", (Object)table.getTableName());
            template.setAttribute("comment", (Object)this.removeSingleQuotes(table.getComments()));
            ddl = template.toString();
            this.getOutputStream().println(ddl);
            this.getOutputStream().println("");
        }
        table.setNativeSql(ddl);
        table.save(this.getPersistenceManager());
        if (!this.m_tablesOnly) {
            this.generateColumnComments(table, colArray);
            this.generateTableConstraints(table, colArray);
            this.generateIndexes(table, colArray);
            template = this.getTemplateGroup().getInstanceOf("GrantOtherUser");
            for (MdSchema schema : this.m_schemaCache.values()) {
                if (schema.getKey().equals(table.getSchemaId())) continue;
                template.setAttribute("objtogrant", (Object)table.getTableName());
                template.setAttribute("usertograntto", (Object)schema.getName());
                ddl = template.toString();
                template.reset();
                this.getOutputStream().println(ddl);
            }
            this.getOutputStream().println("");
            if (MigrationAddin.getMigrationConfig().getGenerateDataMoveUserFlag() && this.m_numSchema > 1 && this.m_dataMoveUser != null) {
                template = this.getTemplateGroup().getInstanceOf("GrantDataMoveUser");
                template.setAttribute("objtogrant", (Object)table.getTableName());
                template.setAttribute("usertograntto", (Object)this.m_dataMoveUser);
                ddl = template.toString();
                this.getOutputStream().println(ddl);
                this.getOutputStream().println("");
            }
        }
    }

    private void generateColumnComments(MdTable table, ArrayList<MdColumn> colArray) {
        for (MdColumn column : colArray) {
            String comments = column.getComments();
            if (comments == null || comments.length() <= 0) continue;
            StringTemplate template = this.getTemplateGroup().getInstanceOf("ColumnComment");
            template.setAttribute("tableName", (Object)table.getTableName());
            template.setAttribute("columnName", (Object)column.getObjectName());
            template.setAttribute("comment", (Object)this.removeSingleQuotes(comments));
            String ddl = template.toString();
            this.getOutputStream().println(ddl);
            this.getOutputStream().println("");
        }
    }

    private String removeSingleQuotes(String comments) {
        if (comments.indexOf("'") == -1) {
            return comments;
        }
        return comments.replace("'", "''");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateTableConstraints(MdTable table, ArrayList<MdColumn> colArray) throws PersistenceException {
        CloseableIterator constraints = this.m_persistenceUtility.getConstraintsForTableId(table.getKey(), this.m_filters);
        try {
            while (true) {
                if (constraints.hasNext()) {
                    if (this.shouldCancel()) {
                        constraints.close();
                        Object var6_5 = null;
                        constraints.close();
                        return;
                    }
                    MdConstraint constraint = (MdConstraint)constraints.next();
                    if (constraint.getConstraintType() != null) {
                        if (constraint.getConstraintType().equals("PK")) {
                            this.generateIndividualPrimaryKeyConstraint(table, constraint, colArray);
                            continue;
                        }
                        if (!constraint.getConstraintType().equals("CHECK") && !constraint.getConstraintType().equals("UNIQUE")) continue;
                        this.generateIndividualConstraint(constraint, table, false);
                        continue;
                    }
                    s_log.log(Level.WARNING, "Generate.NOCONSTRAINTTYPE", new Object[]{"No constraint type", constraint.getName(), new ClickableLogInfo(constraint, "Generate")});
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            constraints.close();
            throw throwable;
        }
        Object var6_6 = null;
        constraints.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateIndividualPrimaryKeyConstraint(MdTable table, MdConstraint constraint, ArrayList<MdColumn> colArray) throws PersistenceException {
        StringTemplate template;
        CloseableIterator constraintDetails = this.m_persistenceUtility.getConstraintDetails(constraint.getKey());
        ArrayList<MdColumn> pkColArray = new ArrayList<MdColumn>();
        try {
            template = this.getTemplateGroup().getInstanceOf("CreatePrimaryKey");
            template.setAttribute("mdtable", (Object)table);
            template.setAttribute("mdconstraint", (Object)constraint);
            block2: while (constraintDetails.hasNext()) {
                if (this.shouldCancel()) {
                    constraintDetails.close();
                    break;
                }
                MdConstraintDetail detail = (MdConstraintDetail)constraintDetails.next();
                for (MdColumn search : colArray) {
                    if (!search.getKey().equals(detail.getColumnId())) continue;
                    pkColArray.add(search);
                    continue block2;
                }
            }
            Object var12_10 = null;
            constraintDetails.close();
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            constraintDetails.close();
            throw throwable;
        }
        template.setAttribute("collist", pkColArray);
        String ddl = template.toString();
        this.getOutputStream().println(ddl);
        constraint.setConstraintText(ddl);
        constraint.save(this.getPersistenceManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateIndexes(MdTable table, ArrayList<MdColumn> colArray) throws PersistenceException {
        CloseableIterator indexes = this.m_persistenceUtility.getIndexesForTableId(table.getKey(), this.m_filters);
        try {
            while (true) {
                Object var13_12;
                StringTemplate template;
                if (!indexes.hasNext()) break;
                if (this.shouldCancel()) {
                    indexes.close();
                    Object var15_13 = null;
                    indexes.close();
                    return;
                }
                MdIndexe index = (MdIndexe)indexes.next();
                CloseableIterator indextDetails = this.m_persistenceUtility.getIndexDetails(index.getKey());
                ArrayList<MdColumn> indexColArray = new ArrayList<MdColumn>();
                try {
                    template = index.getIndexType().equals("UNIQUE") ? this.getTemplateGroup().getInstanceOf("CreateUniqueIndex") : this.getTemplateGroup().getInstanceOf("CreateIndex");
                    template.setAttribute("mdtable", (Object)table);
                    template.setAttribute("mdindex", (Object)index);
                    template.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                    template.setAttribute("extindextype", (Object)index.getProperty("EXTENDEDINDEXTYPE"));
                    block5: while (indextDetails.hasNext()) {
                        if (this.shouldCancel()) {
                            indextDetails.close();
                            break;
                        }
                        MdIndexDetail detail = (MdIndexDetail)indextDetails.next();
                        for (MdColumn search : colArray) {
                            if (!search.getKey().equals(detail.getColumnId())) continue;
                            indexColArray.add(search);
                            continue block5;
                        }
                    }
                    var13_12 = null;
                    indextDetails.close();
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    indextDetails.close();
                    throw throwable;
                }
                template.setAttribute("collist", indexColArray);
                String ddl = template.toString();
                this.getOutputStream().println(ddl);
                index.setNativeSql(ddl);
                index.save(this.getPersistenceManager());
            }
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            indexes.close();
            throw throwable;
        }
        Object var15_14 = null;
        indexes.close();
    }

    protected void generateIndividualConstraint(MdConstraint constraint, MdTable table, boolean openNewStream) {
        String sfailReason = null;
        try {
            if (constraint.getConstraintType().equals("FOREIGN KEY")) {
                this.generateIndividualForeignKeyConstraint(table, constraint);
            } else if (constraint.getConstraintType().equals("CHECK")) {
                this.generateCheckConstraint(table, constraint, openNewStream);
            } else if (constraint.getConstraintType().equals("UNIQUE")) {
                this.generateUniqueConstraint(table, constraint);
            }
        }
        catch (NoSuchObjectException nsoe) {
            sfailReason = nsoe.getLocalizedMessage();
        }
        catch (PersistenceException pex) {
            sfailReason = pex.getLocalizedMessage();
        }
        if (sfailReason != null) {
            s_log.log(Level.SEVERE, "Generate.GENERATECONSTRAINTFAILED", new Object[]{sfailReason, constraint.getName(), new ClickableLogInfo(constraint, "Generate")});
        }
    }

    protected void generateIndividualConstraint(MdConstraint constraint) throws PersistenceException, NoSuchObjectException, GenerateException {
        MdTable table = MdTable.retrieveExistingInstance(this.getPersistenceManager(), constraint.getTableId());
        this.generateIndividualConstraint(constraint, table, false);
    }

    protected void generateCheckConstraint(MdTable table, MdConstraint constraint, boolean openNewStream) throws PersistenceException {
        if (!constraint.getLanguage().equals("OracleSQL") && !MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
            s_log.log(Level.WARNING, "Generate.CONSTRAINTNOTCONVERTED", new Object[]{constraint.getName(), constraint.getLanguage(), new ClickableLogInfo(constraint, "Generate")});
            return;
        }
        String condition = MigrationUtils.findCheckConstraintCondition(constraint, this.getPersistenceManager());
        StringTemplate template = this.getTemplateGroup().getInstanceOf("CreateCheckConstraint");
        template.setAttribute("mdconstraint", (Object)constraint);
        template.setAttribute("mdtable", (Object)table);
        template.setAttribute("condition", (Object)condition);
        GenerateEvent event = new GenerateEvent(1, MigrationAddinArb.getString(139), constraint.getName());
        this.getAudience().fireListeners(event);
        if (openNewStream) {
            this.getOutputStream().startObject(constraint.getName(), "MD_CONSTRAINTS");
        }
        String ddl = template.toString();
        this.getOutputStream().println(ddl);
        if (openNewStream) {
            this.getOutputStream().endObject();
        }
        event.setEventId(2);
        this.getAudience().fireListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateIndividualForeignKeyConstraint(MdTable table, MdConstraint constraint) throws PersistenceException, NoSuchObjectException {
        ArrayList<MdColumn> sourceCols = new ArrayList<MdColumn>();
        ArrayList<MdColumn> referencedCols = new ArrayList<MdColumn>();
        MdTable referencedTable = MdTable.retrieveExistingInstance(this.getPersistenceManager(), constraint.getReftableId());
        CloseableIterator constraintDetails = this.m_persistenceUtility.getConstraintDetails(constraint.getKey());
        try {
            GenerateEvent event;
            while (constraintDetails.hasNext()) {
                if (this.shouldCancel()) {
                    constraintDetails.close();
                    event = new GenerateEvent(3, null, null);
                    this.fireEventListeners(event);
                    break;
                }
                MdConstraintDetail detail = (MdConstraintDetail)constraintDetails.next();
                MdColumn col = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), detail.getColumnId());
                if (detail.getRefFlag().equals("N")) {
                    sourceCols.add(col);
                    continue;
                }
                referencedCols.add(col);
            }
            StringTemplate template = null;
            if (constraint.getDeleteClause() != null) {
                template = this.getTemplateGroup().getInstanceOf("CreateForeignKeyWithDeleteClause");
                template.setAttribute("delClause", (Object)constraint.getDeleteClause());
            } else {
                template = this.getTemplateGroup().getInstanceOf("CreateForeignKey");
            }
            template.setAttribute("mdconstraint", (Object)constraint);
            template.setAttribute("mdtable", (Object)table);
            if (table.getSchemaId().equals(referencedTable.getSchemaId())) {
                template.setAttribute("reftablename", (Object)referencedTable.getTableName());
            } else {
                MdSchema refSchema = this.findParentSchema(referencedTable);
                if (refSchema != null) {
                    String sQualifiedName = refSchema.getName() + "." + referencedTable.getTableName();
                    template.setAttribute("reftablename", (Object)sQualifiedName);
                } else {
                    s_log.log(Level.FINE, "Generate.CANTLOCATEREFSCHEMA", new Object[]{"CAN NOT FIND SCHEMA", constraint.getName(), new ClickableLogInfo(constraint, "Generate")});
                    Object var12_11 = null;
                    constraintDetails.close();
                    return;
                }
            }
            template.setAttribute("collist", sourceCols);
            template.setAttribute("refcols", referencedCols);
            event = new GenerateEvent(1, MigrationAddinArb.getString(139), constraint.getName());
            this.getAudience().fireListeners(event);
            this.getOutputStream().startObject(constraint.getName(), "MD_CONSTRAINTS");
            String ddl = template.toString();
            this.getOutputStream().println(ddl);
            this.getOutputStream().endObject();
            event.setEventId(2);
            this.getAudience().fireListeners(event);
            constraint.setConstraintText(ddl);
            constraint.save(this.getPersistenceManager());
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            constraintDetails.close();
            throw throwable;
        }
        Object var12_12 = null;
        constraintDetails.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateUniqueConstraint(MdTable table, MdConstraint constraint) throws PersistenceException, NoSuchObjectException {
        ArrayList<MdColumn> sourceCols = new ArrayList<MdColumn>();
        CloseableIterator constraintDetails = this.m_persistenceUtility.getConstraintDetails(constraint.getKey());
        try {
            GenerateEvent event;
            while (constraintDetails.hasNext()) {
                if (this.shouldCancel()) {
                    constraintDetails.close();
                    event = new GenerateEvent(3, null, null);
                    this.fireEventListeners(event);
                    break;
                }
                MdConstraintDetail detail = (MdConstraintDetail)constraintDetails.next();
                MdColumn col = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), detail.getColumnId());
                sourceCols.add(col);
            }
            StringTemplate template = this.getTemplateGroup().getInstanceOf("CreateUniqueConstraint");
            template.setAttribute("mdconstraint", (Object)constraint);
            template.setAttribute("mdtable", (Object)table);
            template.setAttribute("collist", sourceCols);
            event = new GenerateEvent(1, MigrationAddinArb.getString(139), constraint.getName());
            this.getAudience().fireListeners(event);
            this.getOutputStream().startObject(constraint.getName(), "MD_CONSTRAINTS");
            String ddl = template.toString();
            this.getOutputStream().println(ddl);
            this.getOutputStream().endObject();
            event.setEventId(2);
            this.getAudience().fireListeners(event);
            constraint.setConstraintText(ddl);
            constraint.save(this.getPersistenceManager());
            Object var9_8 = null;
            constraintDetails.close();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            constraintDetails.close();
            throw throwable;
        }
    }

    protected DBObjectId getConnectionId() {
        return this.m_connectionId;
    }

    protected void setConnectionId(DBObjectId connectionId) {
        this.m_connectionId = connectionId;
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    protected GenerationOutputStream getOutputStream() {
        return this.m_outputStream;
    }

    protected void setOutputStream(GenerationOutputStream outputStream) {
        this.m_outputStream = outputStream;
    }

    protected StringTemplateGroup getTemplateGroup() {
        return this.m_templateGroup;
    }

    protected void setTemplateGroup(StringTemplateGroup templateGroup) {
        this.m_templateGroup = templateGroup;
    }

    protected PersistenceUtility getPersistenceUtility() {
        return this.m_persistenceUtility;
    }

    protected void setPersistenceUtility(PersistenceUtility persistenceUtility) {
        this.m_persistenceUtility = persistenceUtility;
    }

    protected GenerateAudience getAudience() {
        return this.m_audience;
    }

    protected void setAudience(GenerateAudience audience) {
        this.m_audience = audience;
    }

    public void addEventListener(GenerateEventListener listener) {
        this.getAudience().addListener(listener);
    }

    @Override
    public void signalCancel() {
        this.m_shouldCancel = true;
    }

    protected boolean shouldCancel() {
        return this.m_shouldCancel;
    }

    private void fireEventListeners(GenerateEvent event) {
        this.getAudience().fireListeners(event);
    }

    public String getTemplateName() {
        return this.m_templateName;
    }

    public void setTemplateName(String templateName) {
        this.m_templateName = templateName;
        this.setTemplateGroup(StringTemplateGroup.loadGroup((String)templateName));
    }

    protected void setFilters(MigrationObjectFilterList filters) {
        this.m_filters = filters;
    }
}

