/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class GroupsFromGroupIterator
extends PersistableObjectIterator {
    private static final String QUERY_GROUPS_FROM_GROUP = "SELECT DISTINCT MD_GROUPS.ID FROM MD_GROUPS, MD_GROUP_MEMBERS  WHERE MD_GROUP_MEMBERS.GROUP_ID_FK=? AND  MD_GROUP_MEMBERS.GROUP_MEMBER_ID_FK = MD_GROUPS.ID ";
    private PreparedStatement m_myStatement;

    public GroupsFromGroupIterator(PersistenceManager pman, DBObjectId groupId, MigrationObjectFilterList filterList) throws PersistenceException {
        super(MdGroup.class, pman);
        MigrationObjectFilter filter;
        String sql = QUERY_GROUPS_FROM_GROUP;
        String filterCondition = null;
        if (filterList != null && (filter = filterList.getFilterForType("MD_GROUPS")) != null) {
            filterCondition = filter.toConditionClause("MD_GROUPS.GROUP_NAME", "MD_GROUPS.ID");
        }
        if (filterCondition != null) {
            sql = sql + " AND " + filterCondition;
        }
        try {
            this.m_myStatement = pman.getPreparedStatement(sql);
            this.m_myStatement.setLong(1, groupId.getId());
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    protected PreparedStatement getPreparedStatement() throws SQLException {
        return this.m_myStatement;
    }
}

