/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.generate.GenerationOutputStream;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.Ide;

public class OfflineGenerationOutputStream
implements GenerationOutputStream {
    private MigrationConfig m_generationOptions;
    private long m_linesWritten = 0L;
    private int m_fileIndex = 0;
    private PrintStream m_currentStream;
    private String m_fileBase;
    private String m_fileExtension;
    private String m_currentObjectType;
    private String m_currentSchemaName = null;
    private ArrayList<String> m_createdFiles;
    private String m_controllingScriptName;
    private String m_encoding;
    private static final TypeToExtensionTuple[] FILE_EXTENSION_MAP = new TypeToExtensionTuple[]{new TypeToExtensionTuple("MD_SCHEMAS", "db"), new TypeToExtensionTuple("MD_CATALOGS", "cat"), new TypeToExtensionTuple("MD_CONSTRAINTS", "cons"), new TypeToExtensionTuple("MD_GROUPS", "grp"), new TypeToExtensionTuple("MD_INDEXES", "ind"), new TypeToExtensionTuple("MD_PACKAGES", "pks"), new TypeToExtensionTuple("MD_OTHER_OBJECTS", "sql"), new TypeToExtensionTuple("MD_PRIVILEGES", "prv"), new TypeToExtensionTuple("MD_SEQUENCES", "seq"), new TypeToExtensionTuple("MD_STORED_PROGRAMS", "sql"), new TypeToExtensionTuple("MD_TABLES", "tbl"), new TypeToExtensionTuple("MD_USERS", "user"), new TypeToExtensionTuple("MD_VIEWS", "view"), new TypeToExtensionTuple("MD_TRIGGERS", "trg")};

    public OfflineGenerationOutputStream(MigrationConfig options) {
        this.setGenerationOptions(options);
        this.m_encoding = Ide.getEnvironOptions().getEncoding();
    }

    private void closeCurrentStream() {
        this.m_currentStream.close();
        this.m_currentStream = null;
    }

    public void endObject() {
        if (this.m_generationOptions.getFileOutputOption() == 2) {
            this.closeCurrentStream();
        }
        this.m_currentObjectType = null;
    }

    private static int countLines(String toCheck) {
        if (toCheck == null || toCheck.length() == 0) {
            return 0;
        }
        int count = 1;
        for (int i = 0; i < toCheck.length(); ++i) {
            if (toCheck.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    public void println(String toPrint) {
        assert (this.m_currentStream != null);
        int numLines = OfflineGenerationOutputStream.countLines(toPrint);
        int maxLines = this.m_generationOptions.getMaxNumberOfLines();
        if (maxLines != -1 && this.m_linesWritten + (long)numLines > (long)maxLines) {
            try {
                this.openNewStream(this.m_fileBase, ++this.m_fileIndex, this.m_fileExtension);
            }
            catch (FileNotFoundException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (UnsupportedEncodingException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        this.m_currentStream.println(toPrint);
        this.m_linesWritten += (long)numLines;
    }

    public void startObject(String objectName, String objectType) {
        this.m_currentObjectType = objectType;
        if (this.m_generationOptions.getFileOutputOption() == 2) {
            try {
                this.openStream(objectName, objectType, 0);
            }
            catch (FileNotFoundException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (UnsupportedEncodingException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    private void openStream(String name, String type, int fileIndex) throws FileNotFoundException, UnsupportedEncodingException {
        String extension = this.getExtensionForType(type);
        this.m_fileIndex = fileIndex;
        StringBuffer fileName = new StringBuffer(this.m_generationOptions.getOfflineGenerationDirectory());
        fileName.append(File.separatorChar);
        if (this.m_currentSchemaName != null) {
            fileName.append(this.m_currentSchemaName);
            fileName.append(File.separatorChar);
        }
        fileName.append(name);
        this.openNewStream(fileName.toString(), fileIndex, extension);
    }

    private void openSingleStream(int fileIndex) throws FileNotFoundException, UnsupportedEncodingException {
        String outputFileName = this.m_generationOptions.getOfflineGenerationDirectory();
        int dotPos = outputFileName.lastIndexOf(46);
        if (dotPos != -1 && dotPos > 1) {
            this.openNewStream(outputFileName.substring(0, dotPos - 1), fileIndex, outputFileName.substring(dotPos + 1));
        } else {
            this.openNewStream(outputFileName, fileIndex, null);
        }
    }

    private void openNewStream(String base, int index, String extn) throws FileNotFoundException, UnsupportedEncodingException {
        this.m_fileBase = base;
        this.m_fileIndex = index;
        this.m_fileExtension = extn;
        StringBuffer fileName = new StringBuffer();
        fileName.append(base);
        if (this.m_fileIndex != 0) {
            fileName.append(this.m_fileIndex);
        }
        if (this.m_fileExtension != null) {
            fileName.append('.');
            fileName.append(this.m_fileExtension);
        }
        this.m_currentStream = this.m_encoding == null ? new PrintStream(new File(fileName.toString())) : new PrintStream(new File(fileName.toString()), this.m_encoding);
        this.m_createdFiles.add(fileName.toString());
    }

    public void finished() {
        if (this.m_generationOptions.getGenerateControllingScript()) {
            try {
                this.openStream(this.m_controllingScriptName, "ctl", 0);
                this.m_createdFiles.remove(this.m_createdFiles.size() - 1);
                for (String s : this.m_createdFiles) {
                    this.m_currentStream.println("@" + s);
                }
                this.closeCurrentStream();
            }
            catch (FileNotFoundException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (UnsupportedEncodingException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    protected MigrationConfig getGenerationOptions() {
        return this.m_generationOptions;
    }

    protected void setGenerationOptions(MigrationConfig generationOptions) {
        this.m_generationOptions = generationOptions;
    }

    public void startSchema(String schemaName) {
        this.m_currentSchemaName = schemaName;
        if (this.m_currentSchemaName != null) {
            File f;
            StringBuffer fileName = new StringBuffer(this.m_generationOptions.getOfflineGenerationDirectory());
            fileName.append(File.separatorChar);
            if (this.m_currentSchemaName != null) {
                fileName.append(this.m_currentSchemaName);
            }
            if ((f = new File(fileName.toString())).exists() && !f.isDirectory()) {
                Exception e = new Exception(fileName.toString());
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            } else if (!f.exists()) {
                f.mkdir();
            }
        }
    }

    public void endSchema() {
        this.m_currentSchemaName = null;
    }

    public void endDatabase() {
    }

    public void startDatabase(String databaseName) {
    }

    public void endPreamble() {
        if (this.m_generationOptions.getFileOutputOption() != 0) {
            this.closeCurrentStream();
        }
    }

    public void startPreamble(String name) throws FileNotFoundException, UnsupportedEncodingException {
        this.m_createdFiles = new ArrayList();
        this.m_controllingScriptName = name;
        this.openStream(name + "_USERS", "sql", 0);
    }

    private String getExtensionForType(String type) {
        for (TypeToExtensionTuple tuple : FILE_EXTENSION_MAP) {
            if (!tuple.getType().equals(type)) continue;
            return tuple.getExtension();
        }
        return type;
    }

    private static class TypeToExtensionTuple {
        private String m_type;
        private String m_extension;

        public TypeToExtensionTuple(String type, String extension) {
            this.setType(type);
            this.setExtension(extension);
        }

        public String getExtension() {
            return this.m_extension;
        }

        public String getType() {
            return this.m_type;
        }

        protected void setExtension(String extension) {
            this.m_extension = extension;
        }

        protected void setType(String type) {
            this.m_type = type;
        }
    }
}

