/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class SchemasFromGroupIterator
extends PersistableObjectIterator {
    private static final String QUERY_SCHEMAS_FROM_GROUP = "SELECT DISTINCT MD_SCHEMAS.ID FROM MD_SCHEMAS, MD_GROUP_MEMBERS,  MD_USERS WHERE MD_GROUP_MEMBERS.GROUP_ID_FK=? AND  MD_GROUP_MEMBERS.USER_ID_FK = MD_USERS.ID AND MD_USERS.SCHEMA_ID_FK =  MD_SCHEMAS.ID";
    private PreparedStatement m_myStatement;

    public SchemasFromGroupIterator(PersistenceManager pman, DBObjectId groupId, MigrationObjectFilterList filterList) throws PersistenceException {
        super(MdSchema.class, pman);
        MigrationObjectFilter filter;
        String sql = QUERY_SCHEMAS_FROM_GROUP;
        String filterCondition = null;
        if (filterList != null && (filter = filterList.getFilterForType("MD_SCHEMAS")) != null) {
            filterCondition = filter.toConditionClause("MD_SCHEMAS.NAME", "MD_SCHEMAS.ID");
        }
        if (filterCondition != null) {
            sql = sql + " AND " + filterCondition;
        }
        try {
            this.m_myStatement = pman.getPreparedStatement(sql);
            this.m_myStatement.setLong(1, groupId.getId());
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    protected PreparedStatement getPreparedStatement() throws SQLException {
        return this.m_myStatement;
    }
}

