/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class UntranslatedStoredProgramsIterator
extends PersistableObjectIterator {
    private static final String QUERY_UNTRANSLATED_PROGRAMS = "SELECT STORED_PROGRAM_ID FROM MGV_ALL_STORED_PROGRAMS A WHERE SCHEMA_ID = ? AND STORED_PROGRAM_ID NOT IN   (SELECT OBJECT_ID FROM MIGR_GENERATION_ORDER WHERE OBJECT_TYPE = 'MD_STORED_PROGRAMS'    AND CONNECTION_ID_FK = A.CONNECTION_ID)";
    private PreparedStatement m_myStatement;

    public UntranslatedStoredProgramsIterator(PersistenceManager pman, DBObjectId schemaId, MigrationObjectFilterList filterList) throws PersistenceException {
        super(MdStoredProgram.class, pman);
        MigrationObjectFilter filter;
        String sql = QUERY_UNTRANSLATED_PROGRAMS;
        String filterCondition = null;
        if (filterList != null && (filter = filterList.getFilterForType("MD_STORED_PROGRAMS")) != null) {
            filterCondition = filter.toConditionClause("STORED_PROGRAM_NAME", "STORED_PROGRAM_ID");
        }
        if (filterCondition != null) {
            sql = sql + " AND " + filterCondition;
        }
        try {
            this.m_myStatement = pman.getPreparedStatement(sql);
            this.m_myStatement.setLong(1, schemaId.getId());
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    protected PreparedStatement getPreparedStatement() throws SQLException {
        return this.m_myStatement;
    }
}

