/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class UntranslatedViewsIterator
extends PersistableObjectIterator {
    private static final String QUERY_UNTRANSLATED_VIEWS = "SELECT ID FROM MD_VIEWS WHERE SCHEMA_ID = ? AND ID NOT IN (SELECT OBJECT_ID FROM MIGR_GENERATION_ORDER WHERE OBJECT_TYPE = 'MD_VIEWS' AND CONNECTION_ID_FK IN (SELECT CONNECTION_ID FROM MGV_ALL_SCHEMA WHERE SCHEMA_ID = ?)";
    private PreparedStatement m_myStatement;

    public UntranslatedViewsIterator(PersistenceManager pman, DBObjectId schemaId, MigrationObjectFilterList filterList) throws PersistenceException {
        super(MdView.class, pman);
        MigrationObjectFilter filter;
        String sql = QUERY_UNTRANSLATED_VIEWS;
        String filterCondition = null;
        if (filterList != null && (filter = filterList.getFilterForType("MD_VIEWS")) != null) {
            filterCondition = filter.toConditionClause("VIEW_NAME", "ID");
        }
        if (filterCondition != null) {
            sql = sql + " AND " + filterCondition;
        }
        try {
            this.m_myStatement = pman.getPreparedStatement(sql);
            this.m_myStatement.setLong(1, schemaId.getId());
            this.m_myStatement.setLong(2, schemaId.getId());
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    protected PreparedStatement getPreparedStatement() {
        return this.m_myStatement;
    }
}

