/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MigrDatatypeTransformRule
extends PersistableObject {
    public static final String TABLE_NAME = "MIGR_DATATYPE_TRANSFORM_RULE";
    public static final String COLNAME_MAP_ID_FK = "MAP_ID_FK";
    public static final String COLNAME_SOURCE_DATA_TYPE_NAME = "SOURCE_DATA_TYPE_NAME";
    public static final String COLNAME_SOURCE_PRECISION = "SOURCE_PRECISION";
    public static final String COLNAME_SOURCE_SCALE = "SOURCE_SCALE";
    public static final String COLNAME_TARGET_DATA_TYPE_NAME = "TARGET_DATA_TYPE_NAME";
    public static final String COLNAME_TARGET_PRECISION = "TARGET_PRECISION";
    public static final String COLNAME_TARGET_SCALE = "TARGET_SCALE";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MigrDatatypeTransformRule(DBObjectId mapId, String sourceDataTypeName, String targetDataTypeName) {
        this.setMapId(mapId);
        this.setSourceDataTypeName(sourceDataTypeName);
        this.setTargetDataTypeName(targetDataTypeName);
    }

    public static MigrDatatypeTransformRule getExistingInstance(DBObjectId key) {
        MigrDatatypeTransformRule ret = new MigrDatatypeTransformRule();
        ret.setKey(key);
        return ret;
    }

    private MigrDatatypeTransformRule() {
    }

    public static MigrDatatypeTransformRule retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MigrDatatypeTransformRule ret = MigrDatatypeTransformRule.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    protected void setMapId(DBObjectId mapId) {
        Field f = new Field(COLNAME_MAP_ID_FK, "DBOBJECTID");
        f.setValue(mapId);
        this.setField(f);
    }

    protected void setSourceDataTypeName(String sourceDataTypeName) {
        Field f = new Field(COLNAME_SOURCE_DATA_TYPE_NAME, "STRING");
        f.setValue(sourceDataTypeName);
        this.setField(f);
    }

    public void setSourcePrecision(Integer sourcePrecision) {
        Field f = new Field(COLNAME_SOURCE_PRECISION, "INTEGER");
        f.setValue(sourcePrecision);
        this.setField(f);
    }

    public void setSourceScale(Integer sourceScale) {
        Field f = new Field(COLNAME_SOURCE_SCALE, "INTEGER");
        f.setValue(sourceScale);
        this.setField(f);
    }

    protected void setTargetDataTypeName(String targetDataTypeName) {
        Field f = new Field(COLNAME_TARGET_DATA_TYPE_NAME, "STRING");
        f.setValue(targetDataTypeName);
        this.setField(f);
    }

    public void setTargetPrecision(Integer targetPrecision) {
        Field f = new Field(COLNAME_TARGET_PRECISION, "INTEGER");
        f.setValue(targetPrecision);
        this.setField(f);
    }

    public void setTargetScale(Integer targetScale) {
        Field f = new Field(COLNAME_TARGET_SCALE, "INTEGER");
        f.setValue(targetScale);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public DBObjectId getMapId() {
        Field f = this.getField(COLNAME_MAP_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getSourceDataTypeName() {
        Field f = this.getField(COLNAME_SOURCE_DATA_TYPE_NAME);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Integer getSourcePrecision() {
        Field f = this.getField(COLNAME_SOURCE_PRECISION);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getSourceScale() {
        Field f = this.getField(COLNAME_SOURCE_SCALE);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public String getTargetDataTypeName() {
        Field f = this.getField(COLNAME_TARGET_DATA_TYPE_NAME);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Integer getTargetPrecision() {
        Field f = this.getField(COLNAME_TARGET_PRECISION);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getTargetScale() {
        Field f = this.getField(COLNAME_TARGET_SCALE);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            this.setMapId(new DBObjectId(rs.getLong(COLNAME_MAP_ID_FK)));
            this.setSourceDataTypeName(rs.getString(COLNAME_SOURCE_DATA_TYPE_NAME));
            Object o = rs.getInt(COLNAME_SOURCE_PRECISION);
            if (rs.wasNull()) {
                this.setSourcePrecision(null);
            } else {
                this.setSourcePrecision((Integer)o);
            }
            o = rs.getInt(COLNAME_SOURCE_SCALE);
            if (rs.wasNull()) {
                this.setSourceScale(null);
            } else {
                this.setSourceScale((Integer)o);
            }
            this.setTargetDataTypeName(rs.getString(COLNAME_TARGET_DATA_TYPE_NAME));
            o = rs.getInt(COLNAME_TARGET_PRECISION);
            if (rs.wasNull()) {
                this.setTargetPrecision(null);
            } else {
                this.setTargetPrecision((Integer)o);
            }
            o = rs.getInt(COLNAME_TARGET_SCALE);
            if (rs.wasNull()) {
                this.setTargetScale(null);
            } else {
                this.setTargetScale((Integer)o);
            }
            o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

