/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.persistence;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MigrGenerationOrder
extends PersistableObject {
    public static final String TABLE_NAME = "MIGR_GENERATION_ORDER";
    public static final String COLNAME_CONNECTION_ID_FK = "CONNECTION_ID_FK";
    public static final String COLNAME_OBJECT_ID = "OBJECT_ID";
    public static final String COLNAME_OBJECT_TYPE = "OBJECT_TYPE";
    public static final String COLNAME_GENERATION_ORDER = "GENERATION_ORDER";

    public MigrGenerationOrder(DBObjectId connectionId, DBObjectId objectId, String objectType, Integer generationOrder) {
        this.setConnectionId(connectionId);
        this.setObjectId(objectId);
        this.setObjectType(objectType);
        this.setGenerationOrder(generationOrder);
    }

    public static MigrGenerationOrder getExistingInstance(DBObjectId key) {
        MigrGenerationOrder ret = new MigrGenerationOrder();
        ret.setKey(key);
        return ret;
    }

    private MigrGenerationOrder() {
    }

    public static MigrGenerationOrder retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MigrGenerationOrder ret = MigrGenerationOrder.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    protected void setConnectionId(DBObjectId connectionId) {
        Field f = new Field(COLNAME_CONNECTION_ID_FK, "DBOBJECTID");
        f.setValue(connectionId);
        this.setField(f);
    }

    protected void setObjectId(DBObjectId objectId) {
        Field f = new Field(COLNAME_OBJECT_ID, "DBOBJECTID");
        f.setValue(objectId);
        this.setField(f);
    }

    protected void setObjectType(String objectType) {
        Field f = new Field(COLNAME_OBJECT_TYPE, "STRING");
        f.setValue(objectType);
        this.setField(f);
    }

    protected void setGenerationOrder(Integer generationOrder) {
        Field f = new Field(COLNAME_GENERATION_ORDER, "INTEGER");
        f.setValue(generationOrder);
        this.setField(f);
    }

    public DBObjectId getConnectionId() {
        Field f = this.getField(COLNAME_CONNECTION_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public DBObjectId getObjectId() {
        Field f = this.getField(COLNAME_OBJECT_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getObjectType() {
        Field f = this.getField(COLNAME_OBJECT_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Integer getGenerationOrder() {
        Field f = this.getField(COLNAME_GENERATION_ORDER);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            try {
                this.setConnectionId(new DBObjectId(rs.getLong(COLNAME_CONNECTION_ID_FK)));
                this.setObjectId(new DBObjectId(rs.getLong(COLNAME_OBJECT_ID)));
                this.setObjectType(rs.getString(COLNAME_OBJECT_TYPE));
                this.setGenerationOrder(rs.getInt(COLNAME_GENERATION_ORDER));
            }
            catch (SQLException sqlex) {
                throw new PersistenceException(sqlex);
            }
            Object var6_4 = null;
            crs.close();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            crs.close();
            throw throwable;
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

