/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.persistence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class Migrlog
extends PersistableObject {
    public static final String TABLE_NAME = "MIGRLOG";
    public static final String COLNAME_PARENT_LOG_ID = "PARENT_LOG_ID";
    public static final String COLNAME_LOG_DATE = "LOG_DATE";
    public static final String COLNAME_SEVERITY = "SEVERITY";
    public static final String COLNAME_LOGTEXT = "LOGTEXT";
    public static final String COLNAME_PHASE = "PHASE";
    public static final String COLNAME_REF_OBJECT_ID = "REF_OBJECT_ID";
    public static final String COLNAME_REF_OBJECT_TYPE = "REF_OBJECT_TYPE";

    public Migrlog(Timestamp logDate, Integer severity) {
        this.setLogDate(logDate);
        this.setSeverity(severity);
    }

    public static Migrlog getExistingInstance(DBObjectId key) {
        Migrlog ret = new Migrlog();
        ret.setKey(key);
        return ret;
    }

    private Migrlog() {
    }

    public static Migrlog retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        Migrlog ret = Migrlog.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    public void setParentLogId(DBObjectId parentLogId) {
        Field f = new Field(COLNAME_PARENT_LOG_ID, "DBOBJECTID");
        f.setValue(parentLogId);
        this.setField(f);
    }

    protected void setLogDate(Timestamp logDate) {
        Field f = new Field(COLNAME_LOG_DATE, "TIMESTAMP", false);
        f.setValue(logDate);
        this.setField(f);
    }

    protected void setSeverity(Integer severity) {
        Field f = new Field(COLNAME_SEVERITY, "INTEGER", false);
        f.setValue(severity);
        this.setField(f);
    }

    public void setLogtext(String logtext) {
        Field f = new Field(COLNAME_LOGTEXT, "STRING");
        f.setValue(logtext);
        this.setField(f);
    }

    public void setPhase(String phase) {
        Field f = new Field(COLNAME_PHASE, "STRING");
        f.setValue(phase);
        this.setField(f);
    }

    public void setRefObjectId(DBObjectId refObjectId) {
        Field f = new Field(COLNAME_REF_OBJECT_ID, "DBOBJECTID");
        f.setValue(refObjectId);
        this.setField(f);
    }

    public void setRefObjectType(String refObjectType) {
        Field f = new Field(COLNAME_REF_OBJECT_TYPE, "STRING");
        f.setValue(refObjectType);
        this.setField(f);
    }

    public DBObjectId getParentLogId() {
        Field f = this.getField(COLNAME_PARENT_LOG_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Timestamp getLogDate() {
        Field f = this.getField(COLNAME_LOG_DATE);
        if (f == null) {
            return null;
        }
        return f.getTimestamp();
    }

    public Integer getSeverity() {
        Field f = this.getField(COLNAME_SEVERITY);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public String getLogtext() {
        Field f = this.getField(COLNAME_LOGTEXT);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getPhase() {
        Field f = this.getField(COLNAME_PHASE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getRefObjectId() {
        Field f = this.getField(COLNAME_REF_OBJECT_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getRefObjectType() {
        Field f = this.getField(COLNAME_REF_OBJECT_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            block13: {
                try {
                    Object o = new DBObjectId(rs.getLong(COLNAME_PARENT_LOG_ID));
                    if (rs.wasNull()) {
                        this.setParentLogId(null);
                    } else {
                        this.setParentLogId((DBObjectId)o);
                    }
                    this.setLogDate(rs.getTimestamp(COLNAME_LOG_DATE));
                    this.setSeverity(rs.getInt(COLNAME_SEVERITY));
                    o = rs.getString(COLNAME_LOGTEXT);
                    if (rs.wasNull()) {
                        this.setLogtext(null);
                    } else {
                        this.setLogtext((String)o);
                    }
                    o = rs.getString(COLNAME_PHASE);
                    if (rs.wasNull()) {
                        this.setPhase(null);
                    } else {
                        this.setPhase((String)o);
                    }
                    o = new DBObjectId(rs.getLong(COLNAME_REF_OBJECT_ID));
                    if (rs.wasNull()) {
                        this.setRefObjectId(null);
                    } else {
                        this.setRefObjectId((DBObjectId)o);
                    }
                    o = rs.getString(COLNAME_REF_OBJECT_TYPE);
                    if (rs.wasNull()) {
                        this.setRefObjectType(null);
                        break block13;
                    }
                    this.setRefObjectType((String)o);
                }
                catch (SQLException sqlex) {
                    throw new PersistenceException(sqlex);
                }
            }
            Object var7_5 = null;
            crs.close();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            crs.close();
            throw throwable;
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

