/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.convert.XMLSupportedDataTypesMap;
import oracle.dbtools.migration.workbench.core.AbstractQuoter;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import org.xml.sax.SAXException;

public abstract class AbstractMigrationPlugin
implements MigrationPlugin {
    private SupportedDataTypesMap m_supportedDataTypesMap;

    public abstract String getPlatformName();

    public abstract String getPluginName();

    public abstract String getVersionNumber();

    public abstract MigrationPluginPreferences getPreferencePanel();

    public void initialize() {
        try {
            MigrationAddin.registerPlugin(this);
            this.registerMenuItems();
            this.registerPreferencesPanel();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void registerPreferencesPanel() {
        MigrationPluginPreferences panel = this.getPreferencePanel();
        if (panel != null) {
            // empty if block
        }
    }

    public abstract void registerMenuItems();

    protected String getSupportedMapsXMLFileName() {
        return "SupportedDataTypesMap.xml";
    }

    protected void loadSupportedDataTypesMap() throws MigrationPluginException {
        InputStream stream = this.getClass().getResourceAsStream(this.getSupportedMapsXMLFileName());
        try {
            this.m_supportedDataTypesMap = new XMLSupportedDataTypesMap(stream);
        }
        catch (SAXException saxe) {
            throw new MigrationPluginException(saxe);
        }
        catch (IOException ioe) {
            throw new MigrationPluginException(ioe);
        }
    }

    public SupportedDataTypesMap getSupportedDataTypesMap() throws MigrationPluginException {
        if (this.m_supportedDataTypesMap == null) {
            this.loadSupportedDataTypesMap();
        }
        return this.m_supportedDataTypesMap;
    }

    public abstract MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String var1, int var2, int var3, String var4);

    public Icon getIcon() {
        String sFileName = this.getIconFileName();
        if (sFileName == null) {
            return null;
        }
        URL imageUrl = this.getClass().getResource(sFileName);
        if (imageUrl == null) {
            return null;
        }
        try {
            ImageIcon imageIcon = new ImageIcon(imageUrl);
            return imageIcon;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getIconFileName() {
        return null;
    }

    public Quoter getQuoter() {
        return new AbstractQuoter();
    }

    public String maybeUnqualifyTable(String qualifiedTable) {
        return qualifiedTable;
    }

    public boolean usesClobToBlob() {
        return false;
    }

    public boolean doIReturnUnloadScripts() {
        return true;
    }

    public int getPlatformMask() {
        return 0;
    }

    public OfflineCapturer getOfflineCapturer() {
        return null;
    }
}

