/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationStorer;

public class BasicMigrationStorer
implements MigrationStorer {
    private PersistenceManager m_persistenceManager;

    public BasicMigrationStorer(PersistenceManager persistenceManager) {
        if (persistenceManager == null) {
            throw new IllegalArgumentException("Persistence Manager cannot be null");
        }
        this.setPersistenceManager(persistenceManager);
    }

    public PersistableObject storeObject(PersistableObject persistableObject) throws PersistenceException {
        persistableObject.save(this.getPersistenceManager());
        return persistableObject;
    }

    public PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    public PersistenceUtility getPersistenceUtility() {
        return PersistenceUtility.getInstance(this.getPersistenceManager());
    }

    public void commit() throws SQLException {
        this.getPersistenceManager().commit();
    }

    public void rollback() throws SQLException {
        this.getPersistenceManager().rollback();
    }
}

