/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.capture.OnlineCaptureWorker;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.ui.CaptureRunner;
import oracle.dbtools.migration.workbench.core.ui.SingleDropdownDialog;
import oracle.dbtools.migration.workbench.core.util.IncrementalMigrationStorer;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class CaptureInitiator
extends AbstractMenuAction {
    private boolean m_incremental;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void launch() {
        MigrationObjectFilterList filter = null;
        DBObject clickedObj = this.getDBObject();
        MigrationPlugin plugin = this.getMigrationPlugin(clickedObj);
        if (plugin == null) {
            return;
        }
        ThirdPartyDbProvider provider = null;
        Context ctx = this.getContext();
        filter = MigrationFilterUtil.generateFilters(ctx);
        try {
            provider = plugin.getProvider(clickedObj.getConnection());
            PersistenceManager pman = MigrationAddin.getPersistenceManager();
            if (pman == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(219), (String)MigrationAddinArb.getString(218), (String)"help_must_connect_before_capture");
                return;
            }
            BasicMigrationStorer storer = null;
            MdConnection targetConnection = null;
            if (this.m_incremental) {
                targetConnection = this.getTargetConnection(ctx);
                if (targetConnection == null) return;
                storer = new IncrementalMigrationStorer(MigrationAddin.getPersistenceManager(), targetConnection);
            } else {
                storer = new BasicMigrationStorer(MigrationAddin.getPersistenceManager());
            }
            OnlineCaptureWorker worker = new OnlineCaptureWorker(provider.getCapturer(storer), plugin.getPlatformName(), plugin.getClass().getName(), filter);
            if (targetConnection != null) {
                worker.setTargetConnection(targetConnection);
            }
            CaptureRunner captureRunner = new CaptureRunner(worker, plugin.getPlatformMask());
            captureRunner.start(true);
            return;
        }
        catch (MigrationPluginException e) {
            MigrationLogUtil.logThrowable(e.getMessage(), "Capture", (Throwable)e);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return;
        }
        catch (SQLException e) {
            MigrationLogUtil.logThrowable(e.getMessage(), "Capture", (Throwable)e);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return;
        }
        catch (Exception e) {
            MigrationLogUtil.logThrowable(e.getMessage(), "Capture", (Throwable)e);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private MdConnection getTargetConnection(Context ctx) {
        Element el = ctx.getElement();
        Element[] elements = ctx.getSelection();
        String connName = null;
        if (elements.length > 0) {
            CatalogFolder item;
            Element element = elements[0];
            if (element instanceof CatalogFolder) {
                item = (CatalogFolder)element;
                connName = DBURLFormatHelper.getConnectionName((URL)item.getURL());
            } else if (element instanceof SchemaFolder) {
                item = (SchemaFolder)element;
                connName = DBURLFormatHelper.getConnectionName((URL)item.getURL());
            } else if (element instanceof ObjectFolder) {
                item = (ObjectFolder)element;
                connName = DBURLFormatHelper.getConnectionName((URL)item.getURL());
            } else if (element instanceof ObjectNode) {
                item = (ObjectNode)element;
                connName = DBURLFormatHelper.getConnectionName((URL)item.getURL());
            } else {
                return null;
            }
        }
        try {
            Connection conn = null;
            try {
                Connections.getInstance().getConnection(connName);
            }
            catch (DBException e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            if (conn == null) {
                conn = this.getDBObject().getConnection();
            }
            String uRL = conn.getMetaData().getURL();
            MigrationConnectionNode[] capturedNodes = CapturedDatabases.getInstance().findMatchingConnections(uRL);
            if (capturedNodes.length == 0) {
                return null;
            }
            if (capturedNodes.length == 1) {
                return capturedNodes[0].getMdConnection();
            }
            SingleDropdownDialog dlg = new SingleDropdownDialog((Frame)Ide.getMainWindow(), MigrationAddinArb.getString(313), MigrationAddinArb.getString(314), MigrationAddinArb.getString(315), (Object[])capturedNodes);
            dlg.setHelpId("f1_choosetargetmodel");
            if (!dlg.runDialog()) {
                return null;
            }
            return ((MigrationConnectionNode)((Object)dlg.getSelectedItem())).getMdConnection();
        }
        catch (SQLException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return null;
        }
    }

    protected MigrationPlugin getMigrationPlugin(DBObject object) {
        return MigrationAddin.getPluginForConnection(object.getConnection());
    }

    public void setArgs(String args) {
        if (args != null && args.equals("INCREMENTAL")) {
            this.m_incremental = true;
        }
    }
}

