/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorController;
import oracle.dbtools.raptor.plsql.PLSQLController;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuFilter;
import oracle.ide.model.Element;
import oracle.jdeveloper.compiler.JCompiler;

public final class CapturedNodeMenuFilter
implements MenuFilter {
    private static final String MENU_EDIT_AND_RECONVERT = "Edit and Reconvert";
    private static final String MENU_EDIT = "Edit";
    private final ContextMenu menu;

    public CapturedNodeMenuFilter(ContextMenu menu) {
        this.menu = menu;
    }

    public boolean accept(Component component) {
        Context ctx = this.menu.getContext();
        Element[] els = ctx.getSelection();
        if (els.length >= 1 && els[0] instanceof CapturedNode) {
            if (component instanceof JMenuItem && ((JMenuItem)component).getAction() != null && ((JMenuItem)component).getAction() instanceof IdeAction) {
                int commandID = ((IdeAction)((JMenuItem)component).getAction()).getCommandId();
                if (commandID == PLSQLController.COMPILE_DEBUG_COMMAND || commandID == DatabaseNavigatorController.EDIT_OBJECT_CMD_ID || commandID == JCompiler.MAKE_SELECTED_CMD_ID) {
                    return false;
                }
                String text = ((JMenuItem)component).getText().trim();
                if (els.length > 1 && (MENU_EDIT.equals(text) || MENU_EDIT_AND_RECONVERT.equals(text))) {
                    return false;
                }
            } else if (component instanceof JPopupMenu.Separator && ((JPopupMenu.Separator)component).getComponentCount() == 0) {
                return false;
            }
        }
        return true;
    }
}

