/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.convert.ConverterWorker;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.persistence.MigrDatatypeTransformMap;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.ConvertRunner;
import oracle.dbtools.migration.workbench.core.ui.DataMapPanel;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;

public class ConvertInitiator
extends AbstractMenuAction {
    public void launch() {
        try {
            MdConnection mdConnection;
            Context ctx = this.getContext();
            MigrationObjectFilterList filterList = MigrationFilterUtil.generateFilters(ctx);
            Element[] e = ctx.getSelection();
            if (e == null || e.length == 0) {
                DBObject dbo = this.getDBObject();
                mdConnection = MigrationUtils.getConnforDBObject(dbo);
            } else {
                mdConnection = MigrationUtils.getConnforElement(e[0]);
            }
            String sPluginId = "";
            if (mdConnection != null) {
                sPluginId = MigrationUtils.getPluginIdForConnection(mdConnection);
            }
            if (sPluginId.equals("")) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(221), (String)MigrationAddinArb.getString(220), (String)"help_migr_no_plugin_saved");
                return;
            }
            MigrationPlugin plugin = MigrationAddin.findPlugin(sPluginId);
            if (plugin == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(222), (String)MigrationAddinArb.getString(220), (String)"help_migr_plugin_unavailable");
                return;
            }
            Converter converter = plugin.getConverter();
            SupportedDataTypesMap dtm = plugin.getSupportedDataTypesMap();
            DBObjectId mapId = this.getMapId(MigrationAddin.getPersistenceManager(), mdConnection.getKey(), mdConnection.getProjectId(), dtm);
            if (mapId == null) {
                return;
            }
            ConverterWorker worker = new ConverterWorker(MigrationAddin.getPersistenceManager(), mdConnection.getKey(), converter, mapId, filterList);
            ConvertRunner runner = new ConvertRunner(worker);
            runner.start(true);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = "MigrationLog.UNKNOWN_ERROR";
            }
            MigrationLogUtil.logThrowable(message, "Convert", (Throwable)e);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private DBObjectId getMapId(PersistenceManager pman, DBObjectId connectionId, DBObjectId projectId, SupportedDataTypesMap supportedMap) throws PersistenceException {
        MigrDatatypeTransformMap map = ConvertUtils.getMapForProjectId(pman, projectId);
        if (map == null) {
            return this.getDataTypeMapFromUser(pman, connectionId, supportedMap);
        }
        return map.getKey();
    }

    public void setArgs(String args) {
    }

    private DBObjectId getDataTypeMapFromUser(PersistenceManager pman, DBObjectId connectionId, SupportedDataTypesMap supportedMap) throws PersistenceException {
        PersistenceUtility util = PersistenceUtility.getInstance(pman);
        String[] dataTypeNamesInModel = util.getAllDataTypesForConnection(connectionId);
        DataTypeSpecification[] usedDataTypes = new DataTypeSpecification[dataTypeNamesInModel.length];
        for (int i = 0; i < dataTypeNamesInModel.length; ++i) {
            usedDataTypes[i] = new DataTypeSpecification(dataTypeNamesInModel[i]);
        }
        final DataMapPanel dataMapPanel = new DataMapPanel(supportedMap, usedDataTypes);
        int buttonMask = 14;
        ActionListener close = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBObject dbObject;
                DBObjectId dbObjId;
                if (e.getActionCommand() == "apply" && (dbObjId = dataMapPanel.save(dbObject = ConvertInitiator.this.getDBObject())) != null) {
                    ((JEWTDialog)e.getSource()).closeDialog(true);
                }
            }
        };
        String title = MigrationAddinArb.getString(194);
        UIUtils.showPanelAsDialog((JPanel)dataMapPanel, (String)title, (ActionListener)close, (int)buttonMask, (boolean)true);
        return dataMapPanel.getSavedMapId();
    }
}

