/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbObjectSpecification {
    private String _type = null;
    private String _name = null;
    private Hashtable<String, ArrayList<DbObjectSpecification>> _links = null;
    private boolean _createMe;
    private boolean _created;
    private DbObjectSpecification _ownerDbObjectSpecification = null;

    public DbObjectSpecification() {
    }

    public DbObjectSpecification(String type, String name, boolean createme, DbObjectSpecification node) {
        this.setType(type);
        this.setName(name);
        this.setCreateMe(createme);
        this.setCreated(false);
        this.setOwnerDbObjectSpecification(node);
    }

    public void addDbObjectSpecification(String type, DbObjectSpecification node) {
        ArrayList<Object> list;
        if (this._links == null) {
            this._links = new Hashtable();
        }
        if (this._links.containsKey(type)) {
            list = this._links.get(type);
        } else {
            list = new ArrayList();
            this._links.put(type, list);
        }
        list.add(node);
    }

    public Set<String> getObjectTypes() {
        HashSet<String> retVal = new HashSet<String>();
        ArrayList<DbObjectSpecification> open = new ArrayList<DbObjectSpecification>();
        ArrayList<DbObjectSpecification> closed = new ArrayList<DbObjectSpecification>();
        DbObjectSpecification tempDbObjectSpecification = this;
        while (tempDbObjectSpecification.getOwnerDbObjectSpecification() != null) {
            tempDbObjectSpecification = tempDbObjectSpecification.getOwnerDbObjectSpecification();
        }
        if (tempDbObjectSpecification == null) {
            return retVal;
        }
        open.add(tempDbObjectSpecification);
        while (open.size() != 0) {
            DbObjectSpecification current = (DbObjectSpecification)open.remove(0);
            for (DbObjectSpecification n : current.getSubDbObjectSpecifications()) {
                open.add(n);
            }
            closed.add(current);
            retVal.add(current.getType());
        }
        return retVal;
    }

    public ArrayList<DbObjectSpecification> getObjectsForType(String type) {
        ArrayList<DbObjectSpecification> open = new ArrayList<DbObjectSpecification>();
        ArrayList<DbObjectSpecification> closed = new ArrayList<DbObjectSpecification>();
        ArrayList<DbObjectSpecification> matched = new ArrayList<DbObjectSpecification>();
        DbObjectSpecification tempDbObjectSpecification = this;
        while (tempDbObjectSpecification.getOwnerDbObjectSpecification() != null) {
            tempDbObjectSpecification = tempDbObjectSpecification.getOwnerDbObjectSpecification();
        }
        if (tempDbObjectSpecification == null) {
            return matched;
        }
        open.add(tempDbObjectSpecification);
        while (open.size() != 0) {
            DbObjectSpecification current = (DbObjectSpecification)open.remove(0);
            for (DbObjectSpecification n : current.getSubDbObjectSpecifications()) {
                open.add(n);
            }
            closed.add(current);
            if (!current.getType().equals(type)) continue;
            matched.add(current);
        }
        return matched;
    }

    public ArrayList<DbObjectSpecification> getSubDbObjectSpecifications() {
        if (this.getLinks() == null) {
            return new ArrayList<DbObjectSpecification>();
        }
        Enumeration<ArrayList<DbObjectSpecification>> e = this.getLinks().elements();
        ArrayList<DbObjectSpecification> nodes = new ArrayList<DbObjectSpecification>();
        while (e.hasMoreElements()) {
            ArrayList<DbObjectSpecification> al = e.nextElement();
            for (DbObjectSpecification n : al) {
                nodes.add(n);
            }
        }
        return nodes;
    }

    public DbObjectSpecification getOwnerDbObjectSpecification() {
        return this._ownerDbObjectSpecification;
    }

    public void setOwnerDbObjectSpecification(DbObjectSpecification node) {
        this._ownerDbObjectSpecification = node;
    }

    public boolean isCreated() {
        return this._created;
    }

    public void setCreated(boolean created) {
        this._created = created;
    }

    public boolean isCreateMe() {
        return this._createMe;
    }

    public void setCreateMe(boolean me) {
        this._createMe = me;
    }

    public Hashtable<String, ArrayList<DbObjectSpecification>> getLinks() {
        return this._links;
    }

    public void setLinks(Hashtable<String, ArrayList<DbObjectSpecification>> links) {
        this._links = links;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }
}

