/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.generate.GenerationOutputStream;
import oracle.dbtools.migration.generate.SimpleGenerationOutputStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.GenerateRunner;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.Assert;

public class GenerateInitiator
extends AbstractMenuAction {
    private URL m_url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch() {
        Context ctx = this.getContext();
        MdConnection mdConnection = MigrationUtils.getMdConnection(ctx);
        try {
            try {
                GenerationOutputStream outputStream = this.createPrintStream();
                MigrationObjectFilterList filterList = MigrationFilterUtil.generateFilters(ctx);
                GenerateWorker worker = new GenerateWorker(MigrationAddin.getPersistenceManager(), mdConnection.getKey(), outputStream, filterList);
                GenerateRunner runner = new GenerateRunner(worker, this.m_url);
                runner.start(true);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                Object var8_9 = null;
                MigrationLogUtil.endMigrationLogSession();
                return;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            MigrationLogUtil.endMigrationLogSession();
            throw throwable;
        }
        MigrationLogUtil.endMigrationLogSession();
    }

    public void setArgs(String args) {
    }

    private GenerationOutputStream createPrintStream() throws IOException, UnsupportedEncodingException {
        File tempFile = File.createTempFile("generated-", "sql");
        tempFile.deleteOnExit();
        this.m_url = tempFile.toURL();
        SimpleGenerationOutputStream retVal = null;
        String encoding = Ide.getEnvironOptions().getEncoding();
        retVal = encoding == null ? new SimpleGenerationOutputStream(new PrintStream(tempFile)) : new SimpleGenerationOutputStream(new PrintStream(tempFile, encoding));
        return retVal;
    }
}

