/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.db.DBException;

public class IncrementalCaptureController
implements Controller {
    public static final String INCREMENTAL_FLAG = "INCREMENTAL";

    public boolean handleEvent(IdeAction action, Context ctx) {
        return false;
    }

    public boolean update(IdeAction action, Context ctx) {
        ObjectAction oa = (ObjectAction)action.getValue("ObjectAction.KEY");
        oa.getAction().setEnabled(false);
        oa.getMenuItem().setEnabled(false);
        String ctxConnName = (String)ctx.getProperty("ObjectAction.CONN_NAME");
        if (ctxConnName == null) {
            ctxConnName = (String)ctx.getProperty("Connections.db_name");
        }
        if (ctxConnName != null) {
            try {
                Connection conn = Connections.getInstance().getConnection(ctxConnName);
                String uRL = conn.getMetaData().getURL();
                MigrationConnectionNode[] capturedNodes = CapturedDatabases.getInstance().findMatchingConnections(uRL);
                if (capturedNodes.length > 0) {
                    oa.getAction().setEnabled(true);
                    oa.getMenuItem().setEnabled(true);
                    oa.setClassArgs(INCREMENTAL_FLAG);
                }
            }
            catch (DBException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (SQLException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return true;
    }
}

