/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.CapturedNodeMenuFilter;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationMenuManager;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryManager;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryStateListener;
import oracle.dbtools.migration.workbench.core.WorkbenchController;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CaptureRepositoryDatabaseManager;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.ConnectionsAdapter;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedRepositoryDatabaseManager;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFileSystemHelper;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.migration.workbench.core.preferences.DataMovePreferencesPane;
import oracle.dbtools.migration.workbench.core.preferences.GeneratePreferencesPanel;
import oracle.dbtools.migration.workbench.core.preferences.IdentitiferPreferencesPanel;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPreferences;
import oracle.dbtools.migration.workbench.core.preferences.PluginPreferencesPanel;
import oracle.dbtools.raptor.config.NonUserConfigOptions;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.dialogs.BasicObjectModifier;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.report.addin.ReportAddin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.util.Assert;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationAddin
implements Addin {
    private static HashSet<String> s_registeredCapturedMenus = new HashSet();
    private static final String MIGRATION_CORE_ID = "oracle.dbtools.migration";
    public static final String MIGRATION_MENU_ID = "MigrationMenu";
    public static final String ACTION_OFFLINE_DATA_MOVE = "MigrationOfflineDataMove";
    public static final String ACTION_DATA_MOVE = "MigrationDataMove";
    public static final String ACTION_QUICK_MIGRATE = "MigrationQuickMigrate";
    public static final String ACTION_DISCONNECT_REPO = "DisconnectMigrationRepository";
    public static final String ACTION_GENERATE_ORACLE_SCRIPTS = "GenerateOracleScripts";
    public static final String ACTION_CREATE_REPOSITORY = "CreateRepository";
    public static final String ACTION_DELETE_REPOSITORY = "DropRepository";
    public static final String ACTION_TRUNCATE_REPO = "TruncateRepository";
    public static final String ACTION_SELECT_REPO = "SelectRepository";
    public static final String ACTION_CREATE_OFFLINE_SCRIPTS = "CreateOfflineScripts";
    public static final String ACTION_READ_OFFLINE_OUTPUT = "ReadOfflineOutput";
    private static Map<String, MigrationPlugin> s_loadedPlugins = new HashMap<String, MigrationPlugin>();
    private static MigrationMenuManager s_migrationMenuManager;
    private static MigrationRepositoryManager s_repositoryManager;
    private static Navigable s_pluginsPrefNavigable;
    private static Navigable s_migrationCoreSettingsPane;
    private static MigrationConfig s_migrationConfig;
    private static ArrayList<MigrationRepositoryStateListener> s_repositoryListeners;

    public static void registerPlugin(MigrationPlugin plugin) {
        String uniqueName = plugin.getClass().getName();
        if (!s_loadedPlugins.containsKey(uniqueName)) {
            s_loadedPlugins.put(uniqueName, plugin);
            MigrationAddin.registerCaptureMenuItem(plugin.getPlatformName());
        }
    }

    private static synchronized void registerCaptureMenuItem(String platformName) {
        if (!s_registeredCapturedMenus.contains(platformName)) {
            String captureLabel = "";
            captureLabel = platformName.equals("sql server") ? "Capture Sybase" : "Capture " + platformName;
            ObjectAction action = new ObjectAction("CONNECTION", null, captureLabel, "help_id", "oracle.dbtools.migration.workbench.core.CaptureInitiator", null, null, null, "oracle.dbtools.migration.workbench.core.CaptureMenuController");
            action.setConnType(platformName);
            action.setSelectionMode(ObjectAction.SINGLE_SELECT);
            XMLBasedObjectAction.getInstance().addAction(action);
            action = new ObjectAction("USER", null, MigrationAddinArb.getString(217), "help_id", "oracle.dbtools.migration.workbench.core.CaptureInitiator", captureLabel, null, null, "oracle.dbtools.migration.workbench.core.CaptureMenuController");
            action.setConnType(platformName);
            action.setSelectionMode(ObjectAction.BOTH_SELECT);
            XMLBasedObjectAction.getInstance().addAction(action);
            s_registeredCapturedMenus.add(platformName);
            action = new ObjectAction("CATALOG", null, MigrationAddinArb.getString(217), "help_id", "oracle.dbtools.migration.workbench.core.CaptureInitiator", captureLabel, null, null, "oracle.dbtools.migration.workbench.core.CaptureMenuController");
            action.setConnType(platformName);
            action.setSelectionMode(ObjectAction.BOTH_SELECT);
            XMLBasedObjectAction.getInstance().addAction(action);
            s_registeredCapturedMenus.add(platformName);
        }
    }

    public void initialize() {
        this.createPreferences();
        this.createMigrationReports();
        this.registerObjectViewers();
        this.registerTreeActions();
        this.setupMigrationURLHelper();
        this.createConnectionsAdapter();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                MigrationAddin.this.updateUserAgentString();
            }
        });
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void addinsLoaded(IdeEvent e) {
            }

            public void mainWindowClosing(IdeEvent e) {
            }

            public void mainWindowOpened(IdeEvent e) {
                MigrationAddin.this.addToMenuStructure();
                MigrationAddin.this.createMigrationLogWindow();
                MigrationAddin.this.createCaptureModelNavigator();
                MigrationAddin.this.createConvertedModelNavigator();
            }
        });
    }

    private void createConnectionsAdapter() {
        Connections.getInstance().addConnectionListener((ConnectionListener)new ConnectionsAdapter());
    }

    private void setupMigrationURLHelper() {
        URLFileSystem.registerHelper((String)"sqldev.migration", (URLFileSystemHelper)new MigrationURLFileSystemHelper());
    }

    private void registerTreeActions() {
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.core.actions.OracleNavMenus");
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.core.actions.CapNavMenus");
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.core.actions.ConnNavMenus");
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.core.actions");
    }

    private void registerObjectViewers() {
        ViewerAddin.registerPackage((String)"oracle.dbtools.migration.workbench.core.objectviewer");
    }

    private void createCaptureModelNavigator() {
        NavigatorManager capRepDbMgr = CaptureRepositoryDatabaseManager.getInstance();
        capRepDbMgr.initialize();
        capRepDbMgr.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), CapturedConnectionNode.class);
        capRepDbMgr.addContextMenuListener(new ContextMenuListener(){

            public boolean handleDefaultAction(Context context) {
                return false;
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public void menuWillShow(ContextMenu contextMenu) {
                contextMenu.addMenuFilter((MenuFilter)new CapturedNodeMenuFilter(contextMenu));
            }
        }, CapturedNode.class);
        EditorManager.getEditorManager().addEditorListener(new EditorListener(){

            public void editorActivated(Editor editor) {
            }

            public void editorClosed(Editor editor) {
            }

            public void editorDeactivated(Editor editor) {
            }

            public void editorOpened(Editor editor) {
                if (editor instanceof CodeEditor && editor.getContext().getNode() instanceof CapturedNode) {
                    editor.getToolbar().removeAll();
                    ContextMenu contextMenu = editor.getContextMenu();
                    contextMenu.addMenuFilter((MenuFilter)new CapturedNodeMenuFilter(contextMenu));
                }
            }
        });
    }

    private void createConvertedModelNavigator() {
        NavigatorManager convertedRepDbMgr = ConvertedRepositoryDatabaseManager.getInstance();
        convertedRepDbMgr.initialize();
        convertedRepDbMgr.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), ConvertedConnectionNode.class);
    }

    private void createMigrationReports() {
        ReportAddin.registerReportPackage((String)"oracle/dbtools/migration/workbench/core/reports/");
    }

    private void createPreferences() {
        s_migrationCoreSettingsPane = new Navigable("Migration", MigrationPreferences.class);
        s_migrationCoreSettingsPane.setChildComparator(null);
        Navigable migrationGenerateSettingsPane = new Navigable(GeneratePreferencesPanel.TITLE, GeneratePreferencesPanel.class);
        s_migrationCoreSettingsPane.addChildNavigable(migrationGenerateSettingsPane);
        Navigable migrationDataMoveSettingsPane = new Navigable(DataMovePreferencesPane.TITLE, DataMovePreferencesPane.class);
        s_migrationCoreSettingsPane.addChildNavigable(migrationDataMoveSettingsPane);
        Navigable migrationIndetifierSettingsPane = new Navigable(IdentitiferPreferencesPanel.TITLE, IdentitiferPreferencesPanel.class);
        s_migrationCoreSettingsPane.addChildNavigable(migrationIndetifierSettingsPane);
        IdeSettings.registerUI((Navigable)s_migrationCoreSettingsPane);
    }

    private void createMigrationLogWindow() {
        MigrationLogUtil.registerLog();
    }

    private void addToMenuStructure() {
        Menubar menubar;
        try {
            menubar = Ide.getMenubar();
            if (menubar == null) {
                throw new IllegalStateException("Menu is unavailable - cannot initialise");
            }
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("Ide is unavailable - cannot initialise");
        }
        JMenu migrationMenu = menubar.createMenu(MigrationAddinArb.getString(11), Integer.valueOf(MigrationAddinArb.getMnemonic(12)), MenuConstants.WEIGHT_ADDITIONAL_MENU);
        menubar.add((Component)migrationMenu);
        MenuManager.setMenuId((JMenu)migrationMenu, (String)MIGRATION_MENU_ID);
        MigrationAddin.storeMigrationMenu(migrationMenu);
        WorkbenchController controller = new WorkbenchController();
        JMenuItem quickMigrateMenuItem = this.createMigrationMenuItem(menubar, controller, ACTION_QUICK_MIGRATE, MigrationAddinArb.getString(15), MigrationAddinArb.getMnemonic(16));
        s_migrationMenuManager.addMenuItem(quickMigrateMenuItem, false, 0);
        JMenuItem dataMoveMenuItem = this.createMigrationMenuItem(menubar, controller, ACTION_DATA_MOVE, MigrationAddinArb.getString(174), MigrationAddinArb.getMnemonic(173));
        s_migrationMenuManager.addMenuItem(dataMoveMenuItem, true, 99);
        this.addGenerationMenu(menubar, controller);
        this.addRepositoryMenus(menubar, controller);
        this.addOfflineMenus(menubar, controller);
    }

    private void addGenerationMenu(Menubar menubar, WorkbenchController controller) {
        JMenu menu = new JMenu(StringUtils.stripMnemonic((String)MigrationAddinArb.getString(57)));
        menu.setMnemonic(MigrationAddinArb.getMnemonic(57));
        menu.setIcon(this.getIcon(MigrationAddinArb.getString(8)));
        JMenuItem offlineDataMoveItem = this.createMigrationMenuItem(menubar, controller, ACTION_OFFLINE_DATA_MOVE, MigrationAddinArb.getString(274), MigrationAddinArb.getMnemonic(280));
        offlineDataMoveItem.setIcon(this.getIcon(MigrationAddinArb.getString(9)));
        JMenuItem generateOracleScripts = this.createMigrationMenuItem(menubar, controller, ACTION_GENERATE_ORACLE_SCRIPTS, MigrationAddinArb.getString(297), MigrationAddinArb.getMnemonic(298));
        generateOracleScripts.setIcon(this.getIcon(MigrationAddinArb.getString(10)));
        menu.add(generateOracleScripts);
        menu.add(offlineDataMoveItem);
        s_migrationMenuManager.addMenuItem(menu, true, 30);
    }

    private void addRepositoryMenus(Menubar menubar, WorkbenchController controller) {
        JMenu menu = new JMenu(StringUtils.stripMnemonic((String)MigrationAddinArb.getString(41)));
        menu.setMnemonic(MigrationAddinArb.getMnemonic(41));
        menu.setIcon(this.getIcon(MigrationAddinArb.getString(2)));
        JMenuItem createRepositoryItem = this.createMigrationMenuItem(menubar, controller, ACTION_CREATE_REPOSITORY, MigrationAddinArb.getString(42), MigrationAddinArb.getMnemonic(44));
        createRepositoryItem.setIcon(this.getIcon(MigrationAddinArb.getString(3)));
        JMenuItem deleteRepositoryItem = this.createMigrationMenuItem(menubar, controller, ACTION_DELETE_REPOSITORY, MigrationAddinArb.getString(45), MigrationAddinArb.getMnemonic(47));
        deleteRepositoryItem.setIcon(this.getIcon(MigrationAddinArb.getString(4)));
        JMenuItem disconnectRepositoryMenuItem = this.createMigrationMenuItem(menubar, controller, ACTION_DISCONNECT_REPO, MigrationAddinArb.getString(31), MigrationAddinArb.getMnemonic(32));
        disconnectRepositoryMenuItem.setIcon(this.getIcon(MigrationAddinArb.getString(6)));
        JMenuItem selectRepositoryMenuItem = this.createMigrationMenuItem(menubar, controller, ACTION_SELECT_REPO, MigrationAddinArb.getString(49), MigrationAddinArb.getMnemonic(51));
        selectRepositoryMenuItem.setIcon(this.getIcon(MigrationAddinArb.getString(5)));
        JMenuItem clearRepositoryMenuItem = this.createMigrationMenuItem(menubar, controller, ACTION_TRUNCATE_REPO, MigrationAddinArb.getString(52), MigrationAddinArb.getMnemonic(54));
        clearRepositoryMenuItem.setIcon(this.getIcon(MigrationAddinArb.getString(7)));
        menu.add(createRepositoryItem);
        menu.add(deleteRepositoryItem);
        menu.add(selectRepositoryMenuItem);
        menu.add(clearRepositoryMenuItem);
        menu.add(disconnectRepositoryMenuItem);
        s_migrationMenuManager.addMenuItem(menu, false, 1);
    }

    private void addOfflineMenus(Menubar menubar, WorkbenchController controller) {
        JMenu menu = new JMenu(StringUtils.stripMnemonic((String)MigrationAddinArb.getString(316)));
        menu.setMnemonic(MigrationAddinArb.getMnemonic(316));
        JMenuItem createScriptsItem = this.createMigrationMenuItem(menubar, controller, ACTION_CREATE_OFFLINE_SCRIPTS, MigrationAddinArb.getString(317), MigrationAddinArb.getMnemonic(318));
        JMenuItem parseOutputItem = this.createMigrationMenuItem(menubar, controller, ACTION_READ_OFFLINE_OUTPUT, MigrationAddinArb.getString(319), MigrationAddinArb.getMnemonic(320));
        menu.add(createScriptsItem);
        menu.add(parseOutputItem);
        s_migrationMenuManager.addMenuItem(menu, false, 3);
        s_migrationMenuManager.flagSubMenuItem(parseOutputItem, true);
    }

    private JMenuItem createMigrationMenuItem(Menubar menubar, Controller controller, String commandName, String menuLabel, int mnemonic) {
        int aid = Ide.findOrCreateCmdID((String)commandName);
        IdeAction firstAction = IdeAction.get((int)aid, null, (String)StringUtils.stripMnemonic((String)menuLabel), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)StringUtils.getMnemonicKeyCode((String)menuLabel), (ResourceBundle)MigrationAddinArb.getInstance(), null, null, (boolean)true);
        firstAction.addController(controller);
        JMenuItem ret = new JMenuItem((Action)firstAction);
        return ret;
    }

    public static Collection<MigrationPlugin> getPlugins() {
        return s_loadedPlugins.values();
    }

    public static MigrationPlugin findPlugin(String pluginId) {
        return s_loadedPlugins.get(pluginId);
    }

    private static void storeMigrationMenu(JMenu menu) {
        if (s_migrationMenuManager == null) {
            s_migrationMenuManager = new MigrationMenuManager(menu);
            MigrationAddin.addMigrationRepositoryStateListener(s_migrationMenuManager);
        }
    }

    public static MigrationMenuManager getMigrationMenuManager() {
        return s_migrationMenuManager;
    }

    private static MigrationRepositoryManager getRepositoryManager() {
        if (s_repositoryManager == null) {
            s_repositoryManager = new MigrationRepositoryManager();
        }
        return s_repositoryManager;
    }

    public static boolean isRepositoryOpen() {
        return MigrationAddin.getRepositoryManager().isConnected();
    }

    public static String getRepositoryConnectionName() {
        if (MigrationAddin.getRepositoryManager().isConnected()) {
            return MigrationAddin.getRepositoryManager().getName();
        }
        return null;
    }

    public static PersistenceManager getPersistenceManager() {
        MigrationRepositoryManager repoManager = MigrationAddin.getRepositoryManager();
        if (!repoManager.isConnected()) {
            return null;
        }
        return repoManager.getPersistenceManager();
    }

    public static void disconnectRepository() {
        MigrationAddin.getRepositoryManager().closeConnections();
        s_repositoryManager = null;
        if (s_repositoryListeners != null) {
            for (MigrationRepositoryStateListener listener : s_repositoryListeners) {
                listener.repositoryClosed();
            }
        }
    }

    public static void openRepository(String connName) {
        if (MigrationAddin.getRepositoryManager().openConnections(connName) && s_repositoryListeners != null) {
            for (MigrationRepositoryStateListener listener : s_repositoryListeners) {
                listener.repositoryOpened(connName);
            }
        }
    }

    public static PersistenceManager getCaptureExplorerConnection() {
        return MigrationAddin.getRepositoryManager().getCaptureConnection();
    }

    public static PersistenceManager getConvertedExplorerConnection() {
        return MigrationAddin.getRepositoryManager().getConvertConnection();
    }

    public static PersistenceManager getLogPersistenceConnection() {
        return MigrationAddin.getRepositoryManager().getLoggerPersistenceManager();
    }

    public static MigrationPlugin getPluginForConnection(Connection connection) {
        try {
            if (connection == null) {
                return null;
            }
            MigrationPlugin partialMatch = null;
            int major = -1;
            int minor = -1;
            String productversion = null;
            String platform = null;
            DatabaseMetaData dbmd = connection.getMetaData();
            try {
                platform = dbmd.getDatabaseProductName();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                major = dbmd.getDatabaseMajorVersion();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                minor = dbmd.getDatabaseMinorVersion();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                productversion = dbmd.getDatabaseProductVersion();
            }
            catch (Exception e) {
                // empty catch block
            }
            for (MigrationPlugin plugin : MigrationAddin.getPlugins()) {
                MigrationPlugin.PluginSupportLevel level = plugin.getPlatformSupportLevel(platform, major, minor, productversion);
                if (level == MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION) {
                    return plugin;
                }
                if (level != MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_YES) continue;
                partialMatch = plugin;
            }
            return partialMatch;
        }
        catch (SQLException sqlex) {
            Assert.printStackTrace((Throwable)sqlex);
            return null;
        }
    }

    public static synchronized void registerPluginPreferences(PluginPreferencesPanel panel) {
        if (s_pluginsPrefNavigable == null) {
            Navigable plugNavigable;
            s_pluginsPrefNavigable = plugNavigable = new Navigable(PluginPreferencesPanel.TITLE, PluginPreferencesPanel.class);
            s_migrationCoreSettingsPane.addChildNavigable(plugNavigable);
        }
        Navigable navPane = new Navigable(panel.getTitle(), ((Object)((Object)panel)).getClass());
        s_pluginsPrefNavigable.addChildNavigable(navPane);
    }

    public static void registerGenericPreferences(DefaultTraversablePanel panel) {
        Navigable navPane = new Navigable(panel.getDefaultTitle(), panel.getClass());
        s_migrationCoreSettingsPane.addChildNavigable(navPane);
    }

    public static MigrationConfig getMigrationConfig() {
        if (s_migrationConfig == null) {
            Preferences p = Preferences.getPreferences();
            s_migrationConfig = MigrationConfig.getInstance((PropertyStorage)p);
            s_migrationConfig.addStructureChangeListener(new MyChangeListener());
        }
        return s_migrationConfig;
    }

    private void updateUserAgentString() {
        MigrationConfig config = MigrationAddin.getMigrationConfig();
        String UAString = NonUserConfigOptions.get((String)"raptor.user.agent.extras");
        if (UAString != null) {
            Pattern p = Pattern.compile("MWB_[0-9]+");
            Matcher m = p.matcher(UAString);
            while (m.find()) {
                String match = m.group();
                NonUserConfigOptions.removeUserAgent((String)match);
                UAString = NonUserConfigOptions.get((String)"raptor.user.agent.extras");
                if (UAString == null) break;
                m = p.matcher(UAString);
            }
        }
        NonUserConfigOptions.addUserAgent((String)("MWB_" + config.getUACode()));
    }

    public static String getDefaultMigrationRepository() {
        return MigrationAddin.getMigrationConfig().getDefaultRepository();
    }

    public static void addMigrationRepositoryStateListener(MigrationRepositoryStateListener listener) {
        if (s_repositoryListeners == null) {
            s_repositoryListeners = new ArrayList();
        }
        s_repositoryListeners.add(listener);
    }

    private Icon getIcon(String iconName) {
        if (iconName == null) {
            return null;
        }
        URL imageUrl = this.getClass().getResource(iconName);
        if (imageUrl == null) {
            return null;
        }
        try {
            ImageIcon imageIcon = new ImageIcon(imageUrl);
            return imageIcon;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        s_migrationConfig = null;
    }

    private static class MyChangeListener
    extends StructureChangeListener {
        private MyChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent changeEvent) {
            ChangeInfo[] changes;
            for (ChangeInfo change : changes = changeEvent.getChangeDetails()) {
                if (change.getChangeType() != 0 || !change.getPropertyName().equals("DefaultRepository")) continue;
                MigrationAddin.disconnectRepository();
                String newDefault = change.getNewValueAsString();
                if (!Connections.getInstance().isConnectionOpen(newDefault)) continue;
                MigrationAddin.openRepository(newDefault);
                MigrationUtils.resetDateFormatter();
            }
        }
    }
}

