/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.migration.capture.CaptureWorker;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.NavigatorNodeMap;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.ide.Context;
import oracle.ide.model.Element;

public final class MigrationFilterUtil {
    private static MigrationObjectFilter[] s_schemaChildFilters = new MigrationObjectFilter[CaptureWorker.CAPTURE_ORDER.length - 2];

    private MigrationFilterUtil() {
    }

    public static MigrationObjectFilterList generateFilters(Context ctx) {
        HashMap objectLists = new HashMap();
        MigrationObjectFilterList filter = new MigrationObjectFilterList();
        NavigatorNodeMap nodeMap = new NavigatorNodeMap();
        MigrationObjectFilter filterElement = null;
        ArrayList<String> schemas = new ArrayList<String>();
        ArrayList<String> catalogs = new ArrayList<String>();
        Element[] elements = ctx.getSelection();
        if ((elements == null || elements.length == 0) && ctx.getNode() instanceof ViewerNode) {
            elements = new Element[1];
            ViewerNode vn = (ViewerNode)ctx.getNode();
            elements[0] = vn.getBaseNode();
        }
        Properties map = nodeMap.getMap();
        boolean bAddSchemaChildren = false;
        boolean bAddCatalogChildren = false;
        for (int i = 0; i < elements.length; ++i) {
            String[] folders;
            String type;
            MigrationObjectFilter[] folderFilters;
            String schemaName;
            if (elements[i] instanceof CatalogFolder) {
                CatalogFolder cf = (CatalogFolder)elements[i];
                URL url = cf.getURL();
                String catalogName = DBURLFormatHelper.getCatalog((URL)url);
                catalogs.add(catalogName);
                bAddCatalogChildren = true;
                bAddSchemaChildren = true;
                continue;
            }
            if (elements[i] instanceof SchemaFolder) {
                String catalogName = (String)((SchemaFolder)elements[i]).getProperty("CATALOG");
                if (catalogName != null && catalogName.length() > 0 && !catalogs.contains(catalogName)) {
                    catalogs.add(catalogName);
                }
                schemaName = ((SchemaFolder)elements[i]).getShortLabel();
                schemas.add(schemaName);
                bAddSchemaChildren = true;
                continue;
            }
            if (elements[i] instanceof ObjectFolder) {
                ObjectFolder of = (ObjectFolder)elements[i];
                schemaName = MigrationURLFormatHelper.getSchema((URL)of.getURL());
                String folderType = ((ObjectFolder)elements[i]).getObjectType();
                if (!schemas.contains(schemaName) && schemaName.length() > 0) {
                    schemas.add(schemaName);
                }
                Object o = ((ObjectFolder)elements[i]).getProperty("CATALOG");
                String catalogName = null;
                if (o != null) {
                    catalogName = (String)o;
                }
                if (catalogName == null && ((catalogName = DBURLFormatHelper.getCatalog((URL)((ObjectFolder)elements[i]).getURL())) == null || catalogName.length() == 0)) {
                    catalogName = MigrationURLFormatHelper.getCatalog((URL)((ObjectFolder)elements[i]).getURL());
                }
                if (catalogName != null && !catalogs.contains(catalogName) && catalogName.length() > 0) {
                    catalogs.add(catalogName);
                }
                for (MigrationObjectFilter f : folderFilters = MigrationFilterUtil.generateFilter(map.getProperty(folderType, folderType))) {
                    filter.addFilter(f);
                }
                continue;
            }
            if (elements[i] instanceof ObjectNode) {
                String catalogName;
                ObjectNode on = (ObjectNode)elements[i];
                type = (String)on.getProperty("TYPE");
                String schemaName2 = (String)on.getProperty("SCHEMA");
                if (!schemas.contains(schemaName2)) {
                    schemas.add(schemaName2);
                }
                if ((catalogName = (String)on.getProperty("CATALOG")) != null && catalogName.length() > 0 && !catalogs.contains(catalogName)) {
                    catalogs.add(catalogName);
                }
                ObjectNode node = (ObjectNode)elements[i];
                String objectName = node.getShortLabel();
                if (objectLists.get(type) == null) {
                    objectLists.put(type, new ArrayList());
                    ((ArrayList)objectLists.get(type)).add(objectName);
                    continue;
                }
                ((ArrayList)objectLists.get(type)).add(objectName);
                continue;
            }
            if (elements[i] instanceof CapturedNode) {
                String catalogName;
                CapturedNode node = (CapturedNode)elements[i];
                type = (String)node.getProperty("TYPE");
                String schemaName3 = (String)node.getProperty("SCHEMA");
                if (!schemas.contains(schemaName3)) {
                    schemas.add(schemaName3);
                }
                if ((catalogName = (String)node.getProperty("CATALOG")) != null && catalogName.length() > 0 && !catalogs.contains(catalogName)) {
                    catalogs.add(catalogName);
                }
                String objectName = node.getShortLabel();
                if (objectLists.get(type) == null) {
                    objectLists.put(type, new ArrayList());
                    ((ArrayList)objectLists.get(type)).add(objectName);
                    continue;
                }
                ((ArrayList)objectLists.get(type)).add(objectName);
                continue;
            }
            if (!(elements[i] instanceof MigrationConnectionNode)) continue;
            filterElement = new MigrationObjectFilter("MD_CATALOGS");
            filter.addFilter(filterElement);
            filterElement = new MigrationObjectFilter("MD_SCHEMAS");
            filter.addFilter(filterElement);
            for (String type2 : folders = new String[]{"MD_TABLES", "MD_VIEWS", "MD_FUNCTION", "MD_PROCEDURE", "MD_STORED_PROGRAMS", "MD_SEQUENCES", "MD_TRIGGERS", "MD_INDEXES", "MD_USERS"}) {
                for (MigrationObjectFilter f : folderFilters = MigrationFilterUtil.generateFilter(type2)) {
                    filter.addFilter(f);
                }
            }
        }
        if (schemas.size() > 0) {
            String[] schemaArray = schemas.toArray(new String[schemas.size()]);
            filterElement = new MigrationObjectFilter("MD_SCHEMAS", schemaArray);
            filter.addFilter(filterElement);
            if (catalogs.size() == 0) {
                filterElement = new MigrationObjectFilter("MD_CATALOGS");
                filter.addFilter(filterElement);
            }
        }
        if (catalogs.size() > 0) {
            String[] catalogArray = catalogs.toArray(new String[catalogs.size()]);
            filterElement = new MigrationObjectFilter("MD_CATALOGS", catalogArray);
            filter.addFilter(filterElement);
        }
        for (Map.Entry entry : objectLists.entrySet()) {
            String key = (String)entry.getKey();
            ArrayList values = (ArrayList)entry.getValue();
            String omwbType = map.getProperty(key, key);
            filterElement = new MigrationObjectFilter(omwbType, values.toArray(new String[values.size()]));
            filter.addFilter(filterElement);
            if (omwbType.equals("MD_TABLES")) {
                filterElement = new MigrationObjectFilter("MD_COLUMNS");
                filter.addFilter(filterElement);
                filterElement = new MigrationObjectFilter("MD_INDEXES");
                filter.addFilter(filterElement);
                filterElement = new MigrationObjectFilter("MD_INDEX_DETAILS");
                filter.addFilter(filterElement);
                filterElement = new MigrationObjectFilter("MD_CONSTRAINTS");
                filter.addFilter(filterElement);
                filterElement = new MigrationObjectFilter("MD_CONSTRAINT_DETAILS");
                filter.addFilter(filterElement);
                filterElement = new MigrationObjectFilter("MD_TRIGGERS");
                filter.addFilter(filterElement);
            }
            if (omwbType.equals("MD_VIEWS")) {
                filterElement = new MigrationObjectFilter("MD_VIEWS");
                filter.addFilter(filterElement);
                filterElement = new MigrationObjectFilter("MD_TRIGGERS");
                filter.addFilter(filterElement);
            }
            if (!omwbType.equals("MD_STORED_PROGRAMS") && !omwbType.equals("MD_PROCEDURE") && !omwbType.equals("MD_FUNCTION")) continue;
            filterElement = new MigrationObjectFilter("MD_STORED_PROGRAMS", values.toArray(new String[values.size()]));
            filter.addFilter(filterElement);
        }
        if (bAddCatalogChildren) {
            filterElement = new MigrationObjectFilter("MD_SCHEMAS");
            filter.addFilter(filterElement);
        }
        if (bAddSchemaChildren) {
            for (MigrationObjectFilter f : s_schemaChildFilters) {
                filter.addFilter(f);
            }
        }
        if (filter.size() == 0) {
            return null;
        }
        return filter;
    }

    private static MigrationObjectFilter[] generateFilter(String folderType) {
        ArrayList<MigrationObjectFilter> ret = new ArrayList<MigrationObjectFilter>();
        MigrationObjectFilter filterElement = folderType.equals("MD_STORED_PROGRAMS") || folderType.equals("MD_PROCEDURE") || folderType.equals("MD_FUNCTION") ? new MigrationObjectFilter(0, "MD_STORED_PROGRAMS") : new MigrationObjectFilter(0, folderType);
        ret.add(filterElement);
        if (folderType.equals("MD_TABLES")) {
            filterElement = new MigrationObjectFilter("MD_COLUMNS");
            ret.add(filterElement);
            filterElement = new MigrationObjectFilter("MD_INDEXES");
            ret.add(filterElement);
            filterElement = new MigrationObjectFilter("MD_INDEX_DETAILS");
            ret.add(filterElement);
            filterElement = new MigrationObjectFilter("MD_CONSTRAINTS");
            ret.add(filterElement);
            filterElement = new MigrationObjectFilter("MD_CONSTRAINT_DETAILS");
            ret.add(filterElement);
            filterElement = new MigrationObjectFilter("MD_TRIGGERS");
            ret.add(filterElement);
        }
        return ret.toArray(new MigrationObjectFilter[ret.size()]);
    }

    public static MigrationObjectFilterList getFullFilter() {
        String[] folders = new String[]{"MD_TABLES", "MD_VIEWS", "MD_FUNCTION", "MD_PROCEDURE", "MD_STORED_PROGRAMS", "MD_SEQUENCES", "MD_TRIGGERS", "MD_INDEXES", "MD_USERS"};
        return MigrationFilterUtil.getFilter(folders);
    }

    public static MigrationObjectFilterList getProgramLessFilter() {
        String[] folders = new String[]{"MD_TABLES", "MD_SEQUENCES", "MD_INDEXES", "MD_USERS"};
        return MigrationFilterUtil.getFilter(folders);
    }

    public static MigrationObjectFilterList getFilter(String[] folders) {
        MigrationObjectFilterList filter = new MigrationObjectFilterList();
        MigrationObjectFilter filterElement = null;
        filterElement = new MigrationObjectFilter("MD_CATALOGS");
        filter.addFilter(filterElement);
        filterElement = new MigrationObjectFilter("MD_SCHEMAS");
        filter.addFilter(filterElement);
        for (String type : folders) {
            MigrationObjectFilter[] folderFilters;
            for (MigrationObjectFilter f : folderFilters = MigrationFilterUtil.generateFilter(type)) {
                filter.addFilter(f);
            }
        }
        return filter;
    }

    static {
        int i = 0;
        for (String s : CaptureWorker.CAPTURE_ORDER) {
            if (s.equals("MD_CATALOGS") || s.equals("MD_SCHEMAS")) continue;
            MigrationFilterUtil.s_schemaChildFilters[i++] = new MigrationObjectFilter(s);
        }
    }
}

