/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.util.HashSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryStateListener;

public class MigrationMenuManager
implements MigrationRepositoryStateListener {
    private HashSet<JMenuItem> m_itemsRequiringRepo = new HashSet();
    private boolean m_connected = false;
    private JMenu m_actualMenu;

    public MigrationMenuManager(JMenu actualMenu) {
        this.m_actualMenu = actualMenu;
    }

    public JMenuItem addMenuItem(JMenuItem item, boolean bNeedRepo, int proposedPosition) {
        JMenuItem ret = proposedPosition == -1 ? this.m_actualMenu.add(item) : this.m_actualMenu.insert(item, proposedPosition);
        if (bNeedRepo) {
            this.m_itemsRequiringRepo.add(item);
            item.setEnabled(this.m_connected);
        }
        return ret;
    }

    private void refresh() {
        for (JMenuItem item : this.m_itemsRequiringRepo) {
            item.setEnabled(this.m_connected);
        }
    }

    public void repositoryClosed() {
        this.m_connected = false;
        this.refresh();
    }

    public void repositoryOpened(String name) {
        this.m_connected = true;
        this.refresh();
    }

    public void flagSubMenuItem(JMenuItem item, boolean bNeedRepo) {
        if (bNeedRepo && !this.m_itemsRequiringRepo.contains(item)) {
            this.m_itemsRequiringRepo.add(item);
            item.setEnabled(this.m_connected);
        }
    }
}

