/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationModel {
    private String _name;
    private Map<String, Set<DBObject>> _storedObjects = new Hashtable<String, Set<DBObject>>();

    public MigrationModel(String name) {
        this._name = name;
    }

    public void addDBObject(DBObject dbobject) {
        Set<Object> set;
        String type = dbobject.getType();
        if (this._storedObjects.containsKey(type)) {
            set = this._storedObjects.get(type);
        } else {
            set = new HashSet();
            this._storedObjects.put(type, set);
        }
        set.add(dbobject);
    }

    public Set<String> getObjectTypes() {
        return this._storedObjects.keySet();
    }

    public Set<DBObject> getDBObjects() {
        HashSet<DBObject> s = new HashSet<DBObject>();
        for (String type : this._storedObjects.keySet()) {
            Set<DBObject> set = this.getDBObjectsForType(type);
            s.addAll(set);
        }
        return s;
    }

    public String getName() {
        return this._name;
    }

    public Set<DBObject> getDBObjectsForType(String type) {
        if (!this._storedObjects.containsKey(type)) {
            return null;
        }
        return this._storedObjects.get(type);
    }
}

