/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.util.ArrayList;
import java.util.ListIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;

public class MigrationObjectFilter {
    public static final int FILTERTYPE_ALL = 0;
    public static final int FILTERTYPE_NAMELIST = 1;
    public static final int FILTERTYPE_WHERECLAUSE = 2;
    public static final int FILTERTYPE_OBJECTIDLIST = 3;
    private String m_objectType;
    private ArrayList<String> m_objectNames;
    private String m_whereClause;
    private ArrayList<DBObjectId> m_objectIdList;
    private int m_filterType;
    private static final MigrationRepoMeta[] S_REPOINFO = new MigrationRepoMeta[]{new MigrationRepoMeta("MD_CATALOGS", "CATALOG_NAME"), new MigrationRepoMeta("MD_COLUMNS", "COLUMN_NAME"), new MigrationRepoMeta("MD_CONSTRAINTS"), new MigrationRepoMeta("MD_GROUPS", "GROUP_NAME"), new MigrationRepoMeta("MD_INDEXES", "INDEX_NAME"), new MigrationRepoMeta("MD_OTHER_OBJECTS"), new MigrationRepoMeta("MD_PACKAGES"), new MigrationRepoMeta("MD_PRIVILEGES", "PRIVILEGE_NAME"), new MigrationRepoMeta("MD_SCHEMAS"), new MigrationRepoMeta("MD_SEQUENCES"), new MigrationRepoMeta("MD_STORED_PROGRAMS"), new MigrationRepoMeta("MD_SYNONYMS"), new MigrationRepoMeta("MD_TABLES", "TABLE_NAME"), new MigrationRepoMeta("MD_TABLESPACES", "TABLESPACE_NAME"), new MigrationRepoMeta("MD_TRIGGERS", "TRIGGER_NAME"), new MigrationRepoMeta("MD_USER_DEFINED_DATA_TYPES", "DATA_TYPE_NAME"), new MigrationRepoMeta("MD_USERS", "USERNAME"), new MigrationRepoMeta("MD_VIEWS", "VIEW_NAME")};

    protected MigrationObjectFilter(int filterType, String objectType) {
        this.setFilterType(filterType);
        this.setObjectType(objectType);
    }

    public MigrationObjectFilter(String objectType) {
        this(0, objectType);
    }

    public MigrationObjectFilter(String objectType, String[] names) {
        this(1, objectType);
        this.m_objectNames = new ArrayList();
        for (String name : names) {
            this.addObjectName(name);
        }
    }

    public MigrationObjectFilter(String objectType, String whereClause) {
        this(2, objectType);
        this.setWhereClause(whereClause);
    }

    public MigrationObjectFilter(String objectType, DBObjectId[] objectIds) {
        this(3, objectType);
        this.m_objectIdList = new ArrayList();
        for (DBObjectId id : objectIds) {
            this.addObjectId(id);
        }
    }

    public int getFilterType() {
        return this.m_filterType;
    }

    protected void setFilterType(int filterType) {
        this.m_filterType = filterType;
    }

    public String[] getObjectNames() {
        if (this.getFilterType() != 1) {
            throw new IllegalStateException("Filter is not a list filter");
        }
        return this.m_objectNames.toArray(new String[this.m_objectNames.size()]);
    }

    public DBObjectId[] getObjectIds() {
        if (this.getFilterType() != 3) {
            throw new IllegalStateException("Filter is not an object id list filter");
        }
        return this.m_objectIdList.toArray(new DBObjectId[this.m_objectIdList.size()]);
    }

    public String getObjectType() {
        return this.m_objectType;
    }

    protected void setObjectType(String objectType) {
        this.m_objectType = objectType;
    }

    public String getWhereClause() {
        if (this.getFilterType() != 2) {
            throw new IllegalStateException("Filter is not a  whereclause filter");
        }
        return this.m_whereClause;
    }

    public void setWhereClause(String whereClause) {
        if (this.getFilterType() != 2) {
            throw new IllegalStateException("Filter is not a whereclause filter");
        }
        this.m_whereClause = whereClause;
    }

    public void addObjectName(String name) {
        if (this.getFilterType() != 1) {
            throw new IllegalStateException("Filter is not a list filter");
        }
        this.m_objectNames.add(name);
    }

    public void addObjectId(DBObjectId id) {
        if (this.getFilterType() != 3) {
            throw new IllegalStateException("Filter is not an object id list filter");
        }
        this.m_objectIdList.add(id);
    }

    private String getQuotedNameList() {
        if (this.m_objectNames.size() == 0) {
            return "";
        }
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("IN (");
        ListIterator<String> li = this.m_objectNames.listIterator();
        while (li.hasNext()) {
            String s = li.next();
            if (s.length() > 0) {
                sBuf.append('\'');
                sBuf.append(s);
                sBuf.append('\'');
            }
            if (!li.hasNext()) continue;
            sBuf.append(", ");
        }
        sBuf.append(')');
        return sBuf.toString();
    }

    private String getObjectIdInClause() {
        if (this.m_objectIdList.size() == 0) {
            return "";
        }
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("IN (");
        ListIterator<DBObjectId> li = this.m_objectIdList.listIterator();
        while (li.hasNext()) {
            DBObjectId id = li.next();
            sBuf.append(id.getId());
            if (!li.hasNext()) continue;
            sBuf.append(", ");
        }
        sBuf.append(')');
        return sBuf.toString();
    }

    private String toWhereCondition(String colNameToFilter) {
        if (this.getFilterType() == 0) {
            return "1=1";
        }
        StringBuffer sBuf = new StringBuffer();
        sBuf.append(colNameToFilter);
        sBuf.append(' ');
        if (this.getFilterType() == 2) {
            sBuf.append(this.getWhereClause());
        } else if (this.getFilterType() == 1) {
            sBuf.append(this.getQuotedNameList());
        } else {
            sBuf.append(this.getObjectIdInClause());
        }
        return sBuf.toString();
    }

    public String toWhereClause(String colNameToFilter) {
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("WHERE ");
        sBuf.append(this.toWhereCondition(colNameToFilter));
        return sBuf.toString();
    }

    public String toConditionClause(String nameField, String idField) {
        if (this.getFilterType() == 3) {
            return this.toWhereCondition(idField);
        }
        return this.toWhereCondition(nameField);
    }

    public String toWhereConditionForMigrationRepository() {
        String nameField = this.findNameField();
        String idField = this.findIdField();
        if (nameField == null || idField == null) {
            throw new IllegalStateException("filter type not known");
        }
        return this.toConditionClause(nameField, idField);
    }

    private String findNameField() {
        for (MigrationRepoMeta rm : S_REPOINFO) {
            if (!rm.m_tableName.equals(this.getObjectType())) continue;
            return rm.m_nameField;
        }
        return null;
    }

    private String findIdField() {
        for (MigrationRepoMeta rm : S_REPOINFO) {
            if (!rm.m_tableName.equals(this.getObjectType())) continue;
            return rm.m_idField;
        }
        return null;
    }

    private static class MigrationRepoMeta {
        public String m_tableName;
        public String m_nameField;
        public String m_idField;

        public MigrationRepoMeta(String tableName, String nameField, String idField) {
            this.m_tableName = tableName;
            this.m_nameField = nameField;
            this.m_idField = idField;
        }

        public MigrationRepoMeta(String tableName, String nameField) {
            this(tableName, nameField, "ID");
        }

        public MigrationRepoMeta(String tableName) {
            this(tableName, "NAME");
        }
    }
}

