/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.db.ConnectionException;

public class MigrationRepositoryManager {
    private Connection m_connection;
    private String m_name;
    private Connection m_captureConnection;
    private Connection m_convertConnection;
    private Connection m_loggerConnection;
    private PersistenceManager m_persistenceManager;
    private PersistenceManager m_capturedPersistenceManager;
    private PersistenceManager m_convertedPersistenceManager;
    private PersistenceManager m_loggerPersistenceManager;

    public PersistenceManager getCaptureConnection() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Migration repsitory is not connected");
        }
        if (this.m_capturedPersistenceManager == null) {
            this.m_capturedPersistenceManager = new PersistenceManager(this.m_captureConnection);
        }
        return this.m_capturedPersistenceManager;
    }

    public PersistenceManager getLoggerPersistenceManager() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Migration repsitory is not connected");
        }
        if (this.m_loggerPersistenceManager == null) {
            this.m_loggerPersistenceManager = new PersistenceManager(this.m_loggerConnection);
        }
        return this.m_loggerPersistenceManager;
    }

    public PersistenceManager getPersistenceManager() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Migration repository is not connected");
        }
        if (this.m_persistenceManager == null) {
            this.m_persistenceManager = new PersistenceManager(this.m_connection);
        }
        return this.m_persistenceManager;
    }

    public PersistenceManager getConvertConnection() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Migration repository is not connected");
        }
        if (this.m_convertedPersistenceManager == null) {
            this.m_convertedPersistenceManager = new PersistenceManager(this.m_convertConnection);
        }
        return this.m_convertedPersistenceManager;
    }

    public boolean isConnected() {
        if (this.m_name == null) {
            return false;
        }
        return this.m_connection != null && this.m_captureConnection != null && this.m_convertConnection != null;
    }

    protected String getName() {
        return this.m_name;
    }

    protected void setName(String name) {
        this.m_name = name;
    }

    public void closeConnections() {
        this.closeConnection(this.m_persistenceManager, this.m_connection);
        this.closeConnection(this.m_capturedPersistenceManager, this.m_captureConnection);
        this.closeConnection(this.m_convertedPersistenceManager, this.m_convertConnection);
        this.closeConnection(this.m_loggerPersistenceManager, this.m_loggerConnection);
        this.m_captureConnection = null;
        this.m_capturedPersistenceManager = null;
        this.m_convertConnection = null;
        this.m_convertedPersistenceManager = null;
        this.m_connection = null;
        this.m_persistenceManager = null;
        this.m_loggerConnection = null;
        this.m_loggerPersistenceManager = null;
        this.setName(null);
    }

    private void closeConnection(PersistenceManager persistenceManager, Connection connection) {
        if (connection != null) {
            try {
                if (persistenceManager != null) {
                    persistenceManager.releaseCache();
                }
                connection.close();
            }
            catch (SQLException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    public boolean openConnections(String connName) {
        Connections raptorConnectionManager;
        if (this.isConnected()) {
            if (this.getName().equals(connName)) {
                return true;
            }
            this.closeConnections();
        }
        if ((raptorConnectionManager = Connections.getInstance()).isConnectionOpen(connName)) {
            try {
                Connection mainConnection = raptorConnectionManager.getConnection(connName);
                int currentRepoVersion = RepositoryManager.getCurentRepoVersion(mainConnection);
                if (currentRepoVersion < 19) {
                    URL u = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)connName);
                    DBObject object = new DBObject(u);
                    RepositoryManager.upgradeRepository(object.getConnectionName(), currentRepoVersion);
                }
                this.m_connection = raptorConnectionManager.cloneConnection(mainConnection);
                this.m_captureConnection = raptorConnectionManager.cloneConnection(mainConnection);
                this.m_convertConnection = raptorConnectionManager.cloneConnection(mainConnection);
                this.m_loggerConnection = raptorConnectionManager.cloneConnection(mainConnection);
                try {
                    Statement stmt = this.m_connection.createStatement();
                    stmt.execute("begin dbms_application_info.set_module('SQL Developer MigrationWorkbench','Main connection'); end;");
                    stmt.close();
                    stmt = this.m_captureConnection.createStatement();
                    stmt.execute("begin dbms_application_info.set_module('SQL Developer MigrationWorkbench','Capture connection'); end;");
                    stmt.close();
                    stmt = this.m_convertConnection.createStatement();
                    stmt.execute("begin dbms_application_info.set_module('SQL Developer MigrationWorkbench','Convert connection'); end;");
                    stmt.close();
                    stmt = this.m_loggerConnection.createStatement();
                    stmt.execute("begin dbms_application_info.set_module('SQL Developer MigrationWorkbench','Migraion log connection'); end;");
                    stmt.close();
                }
                catch (SQLException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
                this.setName(connName);
                return true;
            }
            catch (DBException dbe) {
                dbe.printStackTrace(System.err);
            }
            catch (ConnectionException ce) {
                ce.printStackTrace(System.err);
            }
        }
        return false;
    }
}

