/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class OfflineCaptureOptionsDialog {
    private JEWTDialog m_dlg;
    private boolean m_cancelled = false;
    private String m_outputDirectory = null;
    private JLabel m_lblOutputDir = new JLabel();
    private JLabel m_outputDirVal = new JLabel();
    private JButton m_btnBrowse = new JButton();
    private JLabel m_lblGenerateFor = new JLabel();
    private JRadioButton m_rdoWindows = new JRadioButton();
    private JRadioButton m_rdoLinux = new JRadioButton();
    private JLabel m_lblPlatform = new JLabel();
    private JComboBox m_comboPlatform = new JComboBox();
    private ButtonGroup m_radioGroup = new ButtonGroup();
    private final String SYBASE12 = "Sybase 12";
    private final String SQLSERVER = "SQL Server";
    private boolean m_sybase12Included = false;

    public OfflineCaptureOptionsDialog(Frame parent) {
        try {
            this.jbInit(parent);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void show() {
        Dimension dim = this.m_dlg.getContentPane().getPreferredSize();
        int h = (int)dim.getHeight() + 20;
        int w = (int)dim.getWidth() + 20;
        this.m_dlg.setSize(w, h);
        this.m_dlg.setPreferredSize(w, h);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.m_dlg);
        this.setOKButtonState(this.m_outputDirVal.getText());
        this.m_dlg.setVisible(true);
    }

    private void jbInit(Frame parent) throws Exception {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        Dimension d = new Dimension(400, 120);
        panel.setSize(d);
        panel.setPreferredSize(d);
        this.m_comboPlatform.setRenderer(new PluginRenderer());
        this.m_comboPlatform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OfflineCaptureOptionsDialog.this.switchOffLinux();
            }
        });
        this.switchOffLinux();
        this.m_lblOutputDir.setText(MigrationAddinArb.getString(322));
        this.m_lblOutputDir.setBounds(new Rectangle(0, 5, 95, 25));
        this.m_outputDirVal.setText(MigrationAddinArb.getString(323));
        this.m_outputDirVal.setBounds(new Rectangle(100, 5, 150, 25));
        this.m_btnBrowse.setText(MigrationAddinArb.getString(325));
        this.m_btnBrowse.setMnemonic(MigrationAddinArb.getMnemonic(326));
        this.m_btnBrowse.setBounds(new Rectangle(270, 5, 105, 25));
        this.m_btnBrowse.setPreferredSize(new Dimension(76, 25));
        this.m_btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OfflineCaptureOptionsDialog.this.chooseOutputDirectory();
            }
        });
        this.m_lblGenerateFor.setText(MigrationAddinArb.getString(327));
        this.m_rdoWindows.setText(MigrationAddinArb.getString(328));
        this.m_rdoWindows.setMnemonic(MigrationAddinArb.getMnemonic(329));
        this.m_rdoWindows.setSelected(true);
        this.m_rdoLinux.setText(MigrationAddinArb.getString(330));
        this.m_rdoLinux.setMnemonic(MigrationAddinArb.getMnemonic(331));
        this.m_radioGroup.add(this.m_rdoLinux);
        this.m_radioGroup.add(this.m_rdoWindows);
        this.m_lblPlatform.setText(MigrationAddinArb.getString(332));
        this.m_lblPlatform.setLabelFor(this.m_comboPlatform);
        this.m_lblPlatform.setDisplayedMnemonic(MigrationAddinArb.getMnemonic(333));
        panel.add((Component)this.m_btnBrowse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_outputDirVal, new GridBagConstraints(1, 0, 1, 1, 50.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_lblOutputDir, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_lblGenerateFor, new GridBagConstraints(0, 1, 1, 2, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_rdoWindows, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.m_rdoLinux, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_lblPlatform, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_comboPlatform, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_offline_capture_initiator_html");
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)parent, (Component)panel, null, (String)MigrationAddinArb.getString(321), (int)7);
        this.m_dlg.setOKButtonMnemonic((int)MigrationAddinArb.getMnemonic(334));
        this.m_dlg.setCancelButtonMnemonic((int)MigrationAddinArb.getMnemonic(335));
    }

    protected void switchOffLinux() {
        MigrationPlugin mp = this.getPluginChoice();
        if (mp == null) {
            return;
        }
        if (mp.getPlatformName().toLowerCase().indexOf("microsoft") != -1) {
            this.m_rdoWindows.setSelected(true);
            this.m_rdoLinux.setEnabled(false);
        } else {
            this.m_rdoLinux.setEnabled(true);
        }
    }

    protected void chooseOutputDirectory() {
        JFileChooser jf = new JFileChooser();
        jf.setFileSelectionMode(1);
        int state = jf.showOpenDialog((Component)this.m_dlg);
        switch (state) {
            case 0: {
                this.m_outputDirectory = jf.getSelectedFile().getAbsolutePath();
                if (jf.getSelectedFile().isDirectory()) {
                    this.m_outputDirVal.setText(this.m_outputDirectory);
                    this.m_outputDirVal.setToolTipText(this.m_outputDirectory);
                    this.setOKButtonState(this.m_outputDirVal.getText());
                    break;
                }
                this.m_outputDirVal.setText(MigrationAddinArb.getString(324));
                this.m_dlg.setOKButtonEnabled(false);
                break;
            }
        }
    }

    private void setOKButtonState(String outputDirectoryVal) {
        File file = new File(outputDirectoryVal);
        if (file.exists()) {
            this.m_dlg.setOKButtonEnabled(true);
        } else {
            this.m_dlg.setOKButtonEnabled(false);
        }
    }

    public boolean isCancelled() {
        return this.m_dlg.isCancelled();
    }

    public String getOutputDir() {
        return this.m_outputDirectory;
    }

    public int getOutputScriptChoice() {
        if (this.m_rdoLinux.isSelected()) {
            return 2;
        }
        return 1;
    }

    public MigrationPlugin getPluginChoice() {
        if (this.m_cancelled) {
            return null;
        }
        if (this.m_comboPlatform.getSelectedItem() == "Sybase 12") {
            MigrationPlugin[] pluginsArray;
            Collection<MigrationPlugin> plugins = MigrationAddin.getPlugins();
            for (MigrationPlugin plugin : pluginsArray = plugins.toArray(new MigrationPlugin[plugins.size()])) {
                if (plugin.getOfflineCapturer() == null || !plugin.getPluginName().equalsIgnoreCase("Sybase 12.0")) continue;
                return plugin;
            }
        }
        return (MigrationPlugin)this.m_comboPlatform.getSelectedItem();
    }

    public void addPlugin(MigrationPlugin plugin) {
        if (plugin.getPlatformName().equalsIgnoreCase("SQL Server")) {
            if (!this.m_sybase12Included) {
                this.m_comboPlatform.addItem("Sybase 12");
                this.m_sybase12Included = true;
            }
        } else {
            this.m_comboPlatform.addItem(plugin);
        }
    }

    private static class PluginRenderer
    extends DefaultListCellRenderer {
        private PluginRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null || !(value instanceof MigrationPlugin)) {
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
            MigrationPlugin plugin = (MigrationPlugin)value;
            StringBuffer sBuf = new StringBuffer();
            sBuf.append(plugin.getPlatformName());
            sBuf.append(" (");
            sBuf.append(plugin.getPublishedVersion());
            sBuf.append(")");
            return super.getListCellRendererComponent((JList<?>)list, sBuf.toString(), index, isSelected, cellHasFocus);
        }
    }
}

