/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import oracle.dbtools.migration.capture.OfflineCaptureWorker;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.OfflineCaptureOptionsDialog;
import oracle.dbtools.migration.workbench.core.QMLauncher;
import oracle.dbtools.migration.workbench.core.ui.CaptureRunner;
import oracle.dbtools.migration.workbench.core.ui.ClearRepositoryDialog;
import oracle.dbtools.migration.workbench.core.ui.CreateRepositoryDialog;
import oracle.dbtools.migration.workbench.core.ui.DataMoveDialog;
import oracle.dbtools.migration.workbench.core.ui.DeleteRepositoryDialog;
import oracle.dbtools.migration.workbench.core.ui.OfflineDatamoveDialog;
import oracle.dbtools.migration.workbench.core.ui.OfflineOracleGenerationDialog;
import oracle.dbtools.migration.workbench.core.ui.SelectRepositoryDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.dialogs.MessageDialog;

public class WorkbenchController
implements Controller {
    private static final int BLOCKSIZE = 2048;
    private static final String GETTING_STARTED_HELPID = "migr_quick_steps.htm-CHDIJEBC";
    private static OfflineCaptureOptionsDialog s_offlineCaptureOptionsDialog = null;

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("MigrationDataMove")) {
            DataMoveDialog dmd = new DataMoveDialog();
            dmd.setVisible(true);
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("DisconnectMigrationRepository")) {
            String repositoryConnectionName = MigrationAddin.getRepositoryConnectionName();
            String disconnectRepoMsg = MigrationAddinArb.getString(37);
            String message = MessageFormat.format(disconnectRepoMsg, Connections.getDisplayName((String)repositoryConnectionName));
            MigrationAddin.disconnectRepository();
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)MigrationAddinArb.getString(38), null);
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("MigrationOfflineDataMove")) {
            OfflineDatamoveDialog odd = new OfflineDatamoveDialog();
            odd.launchunknownMenu();
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("GenerateOracleScripts")) {
            OfflineOracleGenerationDialog oogd = new OfflineOracleGenerationDialog();
            oogd.launch();
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("CreateRepository")) {
            CreateRepositoryDialog cd = new CreateRepositoryDialog();
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("DropRepository")) {
            DeleteRepositoryDialog dd = new DeleteRepositoryDialog();
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("SelectRepository")) {
            SelectRepositoryDialog sd = new SelectRepositoryDialog();
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("TruncateRepository")) {
            ClearRepositoryDialog cd = new ClearRepositoryDialog();
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("CreateOfflineScripts")) {
            this.launchOfflineCapture();
        } else if (Ide.findCmdName((int)ideAction.getCommandId()).equals("ReadOfflineOutput")) {
            this.processOfflineOutput();
        } else if (Ide.findCmdName((int)ideAction.getCommandId()).equals("MigrationQuickMigrate")) {
            QMLauncher init = new QMLauncher();
            init.setContext(context);
            init.launch();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processOfflineOutput() {
        block20: {
            block19: {
                block18: {
                    block17: {
                        jfc = new JFileChooser();
                        jfc.setAcceptAllFileFilterUsed(false);
                        jfc.setFileSelectionMode(0);
                        jfc.setMultiSelectionEnabled(false);
                        jfc.setAcceptAllFileFilterUsed(false);
                        jfc.setFileFilter(new PropertiesFileFilter());
                        ret = jfc.showOpenDialog((Component)Ide.getMainWindow());
                        if (ret != 0) return;
                        f = jfc.getSelectedFile();
                        try {
                            is = new FileInputStream(f);
                        }
                        catch (FileNotFoundException e) {
                            errMsg = MigrationAddinArb.format(337, f.getName());
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)errMsg, (String)MigrationAddinArb.getString(338), (String)"help_file_missing");
                            return;
                        }
                        props = new Properties();
                        try {
                            try {
                                props.load(is);
                                pluginId = props.getProperty("OfflinePluginIdentifier");
                                if (pluginId == null || pluginId.trim().length() == 0) {
                                    errMsg = MigrationAddinArb.format(341, f.getName());
                                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)errMsg, (String)MigrationAddinArb.getString(342), (String)"help_invalid_ocp_format");
                                    var10_13 = null;
                                    break block17;
                                }
                                plugin = MigrationAddin.findPlugin(pluginId);
                                if (plugin == null) {
                                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(222), (String)MigrationAddinArb.getString(343), (String)"help_migr_plugin_unavailable");
                                    break block18;
                                }
                                offlineCapturer = plugin.getOfflineCapturer();
                                if (offlineCapturer == null) {
                                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(344), (String)MigrationAddinArb.getString(345), (String)"help_offline_unsupported");
                                    break block19;
                                }
                                this.doOfflineCapture(f.getParent(), offlineCapturer, props, pluginId, plugin.getPlatformMask());
                                break block20;
                            }
                            catch (IOException e) {
                                errMsg = MigrationAddinArb.format(339, new Object[]{f.getName(), e.getMessage()});
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)errMsg, (String)MigrationAddinArb.getString(340), (String)"file_read_offline_output_failed");
                                var10_17 = null;
                                try {
                                    is.close();
                                    return;
                                }
                                catch (IOException e) {
                                    return;
                                }
                            }
                        }
                        catch (Throwable var9_26) {
                            var10_18 = null;
                            ** try [egrp 3[TRYBLOCK] [11 : 336->344)] { 
lbl54:
                            // 1 sources

                            is.close();
                            throw var9_26;
lbl56:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            throw var9_26;
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [11 : 336->344)] { 
lbl61:
                    // 1 sources

                    is.close();
                    return;
lbl63:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                var10_14 = null;
                ** try [egrp 3[TRYBLOCK] [11 : 336->344)] { 
lbl69:
                // 1 sources

                is.close();
                return;
lbl71:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            var10_15 = null;
            ** try [egrp 3[TRYBLOCK] [11 : 336->344)] { 
lbl77:
            // 1 sources

            is.close();
            return;
lbl79:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        var10_16 = null;
        try {}
        catch (IOException e) {}
        is.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doOfflineCapture(String inputDir, OfflineCapturer offlineCapturer, Properties props, String pluginId, int uaMask) {
        block11: {
            Logger logger = Logger.getLogger("oracle.dbtools.migration");
            BasicMigrationStorer storer = new BasicMigrationStorer(MigrationAddin.getPersistenceManager());
            String projectName = offlineCapturer.captureInitialize(inputDir, props, storer);
            if (projectName == null) {
                throw new OfflineCaptureException(new NullPointerException());
            }
            OfflineCaptureWorker worker = new OfflineCaptureWorker(offlineCapturer, projectName, pluginId);
            CaptureRunner captureRunner = new CaptureRunner(worker, uaMask);
            try {
                captureRunner.start(true);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage());
            }
            Object var13_13 = null;
            try {
                offlineCapturer.cleanUp();
            }
            catch (OfflineCaptureException ofc2) {
                logger.log(Level.WARNING, ofc2.getMessage());
            }
            break block11;
            {
                catch (OfflineCaptureException ofc1) {
                    logger.log(Level.WARNING, ofc1.getMessage());
                    Object var13_14 = null;
                    try {
                        offlineCapturer.cleanUp();
                    }
                    catch (OfflineCaptureException ofc2) {
                        logger.log(Level.WARNING, ofc2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    offlineCapturer.cleanUp();
                }
                catch (OfflineCaptureException ofc2) {
                    logger.log(Level.WARNING, ofc2.getMessage());
                }
                throw throwable;
            }
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    private void launchOfflineCapture() {
        String[] generatedFiles = null;
        OfflineCaptureOptionsDialog dialog = WorkbenchController.getOfflineCaptureDialog();
        dialog.show();
        if (dialog.isCancelled()) {
            return;
        }
        MigrationPlugin plugin = dialog.getPluginChoice();
        OfflineCapturer capturer = plugin.getOfflineCapturer();
        try {
            String[] scripts = capturer.getScriptFiles(dialog.getOutputScriptChoice());
            generatedFiles = scripts != null && scripts.length > 0 ? this.extractScripts(scripts, capturer.getClass(), dialog.getOutputDir()) : capturer.generateScripts(dialog.getOutputDir(), dialog.getOutputScriptChoice());
            if (generatedFiles != null) {
                StringBuffer sBuf = new StringBuffer();
                sBuf.append(MigrationAddinArb.getString(397));
                for (String s : generatedFiles) {
                    sBuf.append('\n');
                    sBuf.append(s);
                }
                sBuf.append('\n');
                sBuf.append(MigrationAddinArb.format(398, generatedFiles[0]));
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)sBuf.toString(), (String)MigrationAddinArb.getString(399), (String)"help_scripts_generated");
            }
        }
        catch (OfflineCaptureException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    /*
     * Loose catch block
     */
    private String[] extractScripts(String[] scriptNames, Class clazz, String outputDir) throws OfflineCaptureException {
        if (scriptNames == null || scriptNames.length == 0) {
            new IllegalArgumentException("scriptNames cannot be null, or empty");
        }
        ArrayList<String> extractedScriptsFiles = new ArrayList<String>();
        byte[] byteBuf = new byte[2048];
        FileOutputStream fos = null;
        BufferedInputStream bis = null;
        for (String s : scriptNames) {
            IOException e2222;
            Object var18_16;
            block19: {
                if (s == null) {
                    throw new OfflineCaptureException(new NullPointerException());
                }
                InputStream is = clazz.getResourceAsStream(s);
                bis = new BufferedInputStream(clazz.getResourceAsStream(s));
                if (bis == null) {
                    throw new OfflineCaptureException(new FileNotFoundException(s));
                }
                String[] parts = s.split("/");
                if (parts == null) {
                    throw new OfflineCaptureException(new IllegalArgumentException(s));
                }
                String sOutputFile = outputDir + File.separator + parts[parts.length - 1];
                fos = new FileOutputStream(sOutputFile);
                int numRead = bis.read(byteBuf);
                while (numRead != -1) {
                    fos.write(byteBuf, 0, numRead);
                    numRead = bis.read(byteBuf);
                }
                fos.close();
                bis.close();
                extractedScriptsFiles.add(sOutputFile);
                var18_16 = null;
                if (fos == null) break block19;
                try {
                    fos.close();
                }
                catch (IOException e2222) {
                    // empty catch block
                }
            }
            if (bis == null) continue;
            try {
                bis.close();
            }
            catch (IOException e2222) {}
            continue;
            {
                catch (FileNotFoundException e3) {
                    throw new OfflineCaptureException(e3);
                }
                catch (IOException e4) {
                    throw new OfflineCaptureException(e4);
                }
            }
            catch (Throwable throwable) {
                var18_16 = null;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return extractedScriptsFiles.toArray(new String[extractedScriptsFiles.size()]);
    }

    private static OfflineCaptureOptionsDialog getOfflineCaptureDialog() {
        if (s_offlineCaptureOptionsDialog == null) {
            s_offlineCaptureOptionsDialog = new OfflineCaptureOptionsDialog((Frame)Ide.getMainWindow());
            Collection<MigrationPlugin> plugins = MigrationAddin.getPlugins();
            MigrationPlugin[] pluginsArray = plugins.toArray(new MigrationPlugin[plugins.size()]);
            Arrays.sort(pluginsArray, new PluginComparator());
            for (MigrationPlugin plugin : pluginsArray) {
                if (plugin.getOfflineCapturer() == null) continue;
                s_offlineCaptureOptionsDialog.addPlugin(plugin);
            }
        }
        return s_offlineCaptureOptionsDialog;
    }

    private static class PropertiesFileFilter
    extends FileFilter {
        private PropertiesFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String s = f.getName();
            return s.endsWith(".ocp");
        }

        public String getDescription() {
            return MigrationAddinArb.getString(336);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PluginComparator
    implements Comparator<MigrationPlugin> {
        private PluginComparator() {
        }

        @Override
        public int compare(MigrationPlugin o1, MigrationPlugin o2) {
            int[] o23;
            int compare = o1.getPlatformName().compareTo(o2.getPlatformName());
            if (compare != 0) {
                return compare;
            }
            int[] o13 = this.threeNumbers(o1.getVersionNumber());
            compare = o13[0] - (o23 = this.threeNumbers(o2.getVersionNumber()))[0];
            if (compare != 0) {
                return compare;
            }
            compare = o13[1] - o23[1];
            if (compare != 0) {
                return compare;
            }
            return o13[2] - o23[2];
        }

        private int[] threeNumbers(String numbers) {
            int[] retVal = new int[3];
            try {
                String[] numberStrings = numbers.split("\\.");
                retVal[0] = Integer.parseInt(numberStrings[0]);
                if (numberStrings.length > 1) {
                    retVal[1] = Integer.parseInt(numberStrings[1]);
                    retVal[2] = numberStrings.length > 2 ? Integer.parseInt(numberStrings[2]) : 0;
                } else {
                    retVal[1] = 0;
                    retVal[2] = 0;
                }
            }
            catch (NumberFormatException e) {
                retVal[0] = 1;
                retVal[1] = 0;
                retVal[2] = 0;
            }
            return retVal;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PluginComparator;
        }
    }
}

