/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.ui.DataMapPanel;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.util.Assert;

public class DataTypeMapAction
extends AbstractMenuAction {
    private static Logger s_logger = Logger.getLogger(DataTypeMapAction.class.getName());

    public void launch() {
        SupportedDataTypesMap supportedDataTypesMap = this.getSupportedDataTypeMap();
        DataTypeSpecification[] usedDataTypes = this.getDataTypesInUse();
        final DataMapPanel dataMapPanel = new DataMapPanel(supportedDataTypesMap, usedDataTypes);
        dataMapPanel.setPersistedRules(this.getCurrentDataTypeRules());
        int buttonMask = 14;
        ActionListener close = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBObject dbObject;
                DBObjectId dbObjId;
                if (e.getActionCommand() == "apply" && (dbObjId = dataMapPanel.save(dbObject = DataTypeMapAction.this.getDBObject())) != null) {
                    ((JEWTDialog)e.getSource()).closeDialog(true);
                }
            }
        };
        String title = MigrationAddinArb.getString(194);
        UIUtils.showPanelAsDialog((JPanel)dataMapPanel, (String)title, (ActionListener)close, (int)buttonMask, (boolean)true);
    }

    private SupportedDataTypesMap getSupportedDataTypeMap() {
        SupportedDataTypesMap supportedDataTypesMap = null;
        try {
            DBObject dbo = this.getDBObject();
            CapturedConnectionNode capDb = (CapturedConnectionNode)dbo.getElement();
            MdConnection mdConnection = capDb.getMdConnection();
            String sPluginId = mdConnection.getProperty("PLUGIN_ID");
            if (sPluginId == null) {
                return null;
            }
            MigrationPlugin plugin = MigrationAddin.findPlugin(sPluginId);
            if (plugin == null) {
                Assert.println((String)("Plugin no longer available " + sPluginId));
                return null;
            }
            supportedDataTypesMap = plugin.getSupportedDataTypesMap();
        }
        catch (MigrationPluginException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return null;
        }
        return supportedDataTypesMap;
    }

    private DataTypeMappingRule[] getCurrentDataTypeRules() {
        MigrationConnectionNode capturedCon = (MigrationConnectionNode)((Object)this.getDBObject().getNode().getData());
        DBObjectId objectId = capturedCon.getMdConnection().getKey();
        DataTypeConversionMap persistedRules = null;
        try {
            persistedRules = ConvertUtils.getPersistedMap(MigrationAddin.getPersistenceManager(), objectId);
        }
        catch (PersistenceException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.SEVERE, e.getMessage());
            return new DataTypeMappingRule[0];
        }
        Collection<DataTypeMappingRule> values = persistedRules.values();
        DataTypeMappingRule[] arrRules = new DataTypeMappingRule[values.size()];
        int count = 0;
        for (DataTypeMappingRule rule : values) {
            arrRules[count++] = rule;
        }
        return arrRules;
    }

    private DataTypeSpecification[] getDataTypesInUse() {
        DBObject dbo = this.getDBObject();
        CapturedConnectionNode capDb = (CapturedConnectionNode)dbo.getElement();
        MdConnection mdConnection = capDb.getMdConnection();
        try {
            PersistenceUtility util = PersistenceUtility.getInstance(MigrationAddin.getPersistenceManager());
            String[] dataTypes = util.getAllDataTypesForConnection(mdConnection.getKey());
            DataTypeSpecification[] ret = new DataTypeSpecification[dataTypes.length];
            for (int i = 0; i < dataTypes.length; ++i) {
                ret[i] = new DataTypeSpecification(dataTypes[i]);
            }
            return ret;
        }
        catch (PersistenceException pex) {
            s_logger.warning(pex.getMessage());
            return null;
        }
    }

    public void setArgs(String arg) {
    }
}

