/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogRecord;
import oracle.dbtools.metadata.persistence.PersistableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogInfo {
    private Object _sourceObject = null;
    private String _strPhase;
    private List<Object> _argumentList;
    private List<LogRecord> _childRecordsList;
    private int _lineNo = -1;
    private int _colNo = -1;

    public LogInfo(String strPhase) {
        this(null, strPhase, -1, -1);
    }

    public LogInfo(Object sourceObject, String strPhase) {
        this(sourceObject, strPhase, -1, -1);
    }

    public LogInfo(Object sourceObject, int lineNo, int colNo) {
        this(sourceObject, "", lineNo, colNo);
    }

    public LogInfo(Object sourceObject, String strPhase, int lineNo, int colNo) {
        this._lineNo = lineNo;
        this._colNo = colNo;
        this._sourceObject = sourceObject;
        this._strPhase = strPhase;
        this._argumentList = new ArrayList<Object>();
        this._childRecordsList = new ArrayList<LogRecord>();
    }

    public String toString() {
        if (this._sourceObject != null) {
            StringBuffer buffString = new StringBuffer();
            if (this._sourceObject instanceof PersistableObject) {
                PersistableObject pObject = (PersistableObject)this._sourceObject;
                buffString.append(pObject.getObjectName()).append(", ").append(pObject.getObjectType()).append(", ").append(pObject.getKey());
            } else {
                buffString.append(this._sourceObject.toString());
            }
            if (this._strPhase != null) {
                buffString.append(this._strPhase);
            }
            return buffString.toString();
        }
        return super.toString();
    }

    public int getColNo() {
        return this._colNo;
    }

    public int getLineNo() {
        return this._lineNo;
    }

    public Object getSourceObject() {
        return this._sourceObject;
    }

    public void addSupplementaryInfo(Object obj) {
        this._argumentList.add(obj);
    }

    public List<Object> getSupplementaryInfo() {
        return this._argumentList;
    }

    public void addChild(LogRecord childRec) {
        this._childRecordsList.add(childRec);
    }

    public List<LogRecord> getChildRecords() {
        return this._childRecordsList;
    }

    public boolean hasChildren() {
        return this._childRecordsList.size() > 0;
    }

    public String getSourceDisplayString() {
        return this._strPhase;
    }
}

