/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.logging;

import java.io.IOException;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.ide.Ide;

public final class MigrationFileHandler
extends FileHandler {
    private static final int MAX_LOG_FILE_SIZE = 50000000;
    private static final String MIGRATION_ERROR_LOG_FILE = Ide.getUserSettingsDirectory() + "MigrationErrorLog.xml";

    public MigrationFileHandler() throws IOException {
        super(MIGRATION_ERROR_LOG_FILE, 50000000, 1, false);
        XMLFormatter xFormatter = new XMLFormatter(){

            public String format(LogRecord record) {
                String orginalString = super.format(record);
                String filterTags = "(method)|(millis)|(sequence)|(thread)";
                orginalString = orginalString.replaceAll(".*<(" + filterTags + ")>.*[" + System.getProperty("line.separator") + "]", "");
                List<LogInfo> childLogs = MigrationLogUtil.searchParameterByType(record.getParameters(), LogInfo.class);
                if (childLogs.size() == 1) {
                    orginalString = orginalString.replace("</record>", "");
                    StringBuffer sBuffer = new StringBuffer(orginalString);
                    for (LogRecord childRecord : childLogs.get(0).getChildRecords()) {
                        sBuffer.append(this.format(childRecord));
                    }
                    sBuffer.append("</record>" + System.getProperty("line.separator"));
                    orginalString = sBuffer.toString();
                }
                return orginalString;
            }

            public String getHead(Handler h) {
                return super.getHead(h).replaceAll(".*(logger\\.dtd).*[" + System.getProperty("line.separator") + "]", "");
            }
        };
        this.setFormatter(xFormatter);
    }
}

