/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import oracle.dbtools.migration.workbench.core.logging.ILogListener;
import oracle.dbtools.migration.workbench.core.ui.MigrationTreeTableLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;

public final class MigrationLogHandler
extends Handler {
    private static MigrationTreeTableLogPage s_migrationLogPage;
    private static MigrationLogHandler s_self;
    private List<ILogListener> _listenerList = new ArrayList<ILogListener>();

    public static synchronized MigrationLogHandler getInstance() {
        if (s_self == null) {
            s_self = new MigrationLogHandler();
        }
        return s_self;
    }

    private MigrationLogHandler() {
    }

    public static void activateLogView() {
        if (s_migrationLogPage != null) {
            s_migrationLogPage.getLogPageView().show();
            s_migrationLogPage.getLogPageView().activate();
            s_migrationLogPage.startAsynchronousLogging();
        }
    }

    private LogPage getLogPage() {
        if (s_migrationLogPage == null) {
            s_migrationLogPage = new MigrationTreeTableLogPage();
        }
        return s_migrationLogPage;
    }

    private void addMigrationLogPage() {
        LogManager logManager;
        if (s_migrationLogPage == null && (logManager = LogManager.getLogManager()) != null) {
            LogManager.getLogManager().addPage(this.getLogPage());
            MigrationLogHandler.activateLogView();
        }
    }

    public void publish(LogRecord record) {
        this.addMigrationLogPage();
        if (!this.isLoggable(record)) {
            return;
        }
        s_migrationLogPage.log(record);
    }

    public synchronized void flush() {
        while (s_migrationLogPage != null && !s_migrationLogPage.isLogQueueEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void close() {
        if (s_migrationLogPage != null) {
            UnifiedBuildSystem.ideLog.unregisterAsynchronousLogPage(this.getLogPage());
        }
    }

    public void notifyListeners(LogRecord rec) {
        for (ILogListener listener : this._listenerList) {
            listener.run(rec);
        }
    }

    public void registerListener(ILogListener listener) {
        if (!this._listenerList.contains(listener)) {
            this._listenerList.add(listener);
        }
    }

    public void setFilterBy(Object connectionId) {
        if (s_migrationLogPage != null) {
            s_migrationLogPage.setFilterBy(connectionId);
        }
    }
}

