/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.logging;

import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllStoredProgramsRec;
import oracle.dbtools.metadata.persistence.MgvAllTablesRec;
import oracle.dbtools.metadata.persistence.MgvAllViewsRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.ILogListener;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CaptureRepositoryDatabaseManager;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedRepositoryDatabaseManager;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.explorer.ExplorerNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigrationLogListener
implements ILogListener {
    private static final String TYPE_CONVERTED = "CONVERTED";
    private static final String MD_VIEW = "MD_VIEW";
    private static final String MD_TABLE = "MD_TABLE";
    private static final String MD_PROCEDURE = "MD_PROCEDURE";
    private static final String MD_INDEX = "MD_INDEX";
    private static final String MD_TRIGGER = "MD_TRIGGER";
    private static final String MD_FUNCTION = "MD_FUNCTION";
    private static final String MD_SEQUENCE = "MD_SEQUENCE";
    private static final String MD_CONSTRAINT = "MD_CONSTRAINT";
    private static final String MD_USER = "MD_USER";

    @Override
    public void run(LogRecord rec) {
        List<ClickableLogInfo> clickableLogInfoList = MigrationLogUtil.searchParameterByType(rec.getParameters(), ClickableLogInfo.class);
        if (clickableLogInfoList.size() > 0) {
            this.handleSpecificNodeType(clickableLogInfoList.get(0));
        }
    }

    private ExplorerNode searchNode(ExplorerNode currentNode, TreeExplorer treeExplorer, List<URL> nodeURL) {
        if (nodeURL.isEmpty()) {
            return currentNode;
        }
        try {
            treeExplorer.open((TNode)currentNode);
            Enumeration childEnumeration = currentNode.children();
            URL currentURL = nodeURL.remove(0);
            while (childEnumeration.hasMoreElements()) {
                String urlStr;
                ExplorerNode childNode = (ExplorerNode)childEnumeration.nextElement();
                Object userObject = childNode.getUserObject();
                if (!(userObject instanceof Locatable) || !(urlStr = ((Locatable)userObject).getURL().toString()).equals(currentURL.toString())) continue;
                if (nodeURL.isEmpty()) {
                    return childNode;
                }
                return this.searchNode(childNode, treeExplorer, nodeURL);
            }
        }
        catch (Exception ex) {
            MigrationLogUtil.logThrowable("MigrationLogListener.NODE_LOAD_ERROR", "Navigator", (Throwable)ex);
        }
        return currentNode;
    }

    private boolean checkDBConnection() {
        Connection conn;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        return persistenceManager != null && (conn = persistenceManager.getConn()) != null;
    }

    private void handleSpecificNodeType(LogInfo logInfo) {
        if (!this.checkDBConnection()) {
            return;
        }
        if (logInfo.getSourceObject() instanceof MdView) {
            this.handleMDViewObject((MdView)logInfo.getSourceObject());
        } else if (logInfo.getSourceObject() instanceof MdTable) {
            this.handleMDTableObject((MdTable)logInfo.getSourceObject());
        } else if (logInfo.getSourceObject() instanceof MdStoredProgram) {
            this.handleMdStoredProgramObject((MdStoredProgram)logInfo.getSourceObject());
        } else if (logInfo.getSourceObject() instanceof MdIndexe) {
            this.handleMdIndexObject((MdIndexe)logInfo.getSourceObject());
        } else if (logInfo.getSourceObject() instanceof MdTrigger) {
            this.handleMdTriggerObject((MdTrigger)logInfo.getSourceObject());
        } else if (logInfo.getSourceObject() instanceof MdConstraint) {
            this.handleMdConstraintObject((MdConstraint)logInfo.getSourceObject());
        } else if (logInfo.getSourceObject() instanceof MdUser) {
            this.handleMdUserObject((MdUser)logInfo.getSourceObject());
        }
    }

    private void handleMdQuery(PersistableObject pObject, String query, String strObjectType) {
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        try {
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(query);
            ResultSet rSet = preparedStatement.executeQuery();
            if (rSet.next()) {
                DBObjectId connectionId = new DBObjectId(rSet.getLong("connection_id"));
                DBObjectId schemaId = new DBObjectId(rSet.getLong("schema_id"));
                String schemaName = rSet.getString("schema_name");
                List<URL> connectionURL = this.getURLSearchList(pObject, schemaId, schemaName, connectionId, strObjectType);
                this.doTreeSelection(connectionId, persistenceManager, connectionURL);
            }
            rSet.close();
        }
        catch (SQLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void handleMdConstraintObject(MdConstraint constraint) {
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        try {
            MdTable tableObject = MdTable.retrieveExistingInstance(persistenceManager, constraint.getTableId());
            this.handleMDTableObject(tableObject);
        }
        catch (PersistenceException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (NoSuchObjectException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void handleMdUserObject(MdUser mdUser) {
        DBObjectId key = mdUser.getKey();
        StringBuffer query = new StringBuffer("SELECT  unique(md_connections.id) connection_id , ").append(" md_schemas.id schema_id , md_schemas.name schema_name ").append(" FROM md_connections, md_catalogs, md_schemas, md_users, md_tables ").append(" WHERE md_users.id = " + key.getId()).append(" AND md_users.schema_id_fk = md_schemas.id ").append(" AND md_schemas.catalog_id_fk = md_catalogs.id ").append(" AND md_catalogs.connection_id_fk = md_connections.id ");
        this.handleMdQuery(mdUser, query.toString(), MD_USER);
    }

    private void handleMdTriggerObject(MdTrigger mdTrigger) {
        DBObjectId key = mdTrigger.getKey();
        StringBuffer query = new StringBuffer("SELECT  mgv_all_table_triggers.connection_id, ").append(" mgv_all_table_triggers.schema_id,        ").append("  mgv_all_table_triggers.schema_name ").append(" FROM  ").append(" mgv_all_table_triggers ").append(" WHERE   mgv_all_table_triggers.trigger_id = " + key.getId()).append(" UNION ").append(" SELECT  mgv_all_view_triggers.connection_id, ").append(" mgv_all_view_triggers.schema_id,        ").append(" mgv_all_view_triggers.schema_name ").append(" FROM  ").append(" mgv_all_view_triggers ").append(" WHERE   mgv_all_view_triggers.trigger_id = " + key.getId());
        this.handleMdQuery(mdTrigger, query.toString(), MD_TRIGGER);
    }

    private void handleMdIndexObject(MdIndexe mdIndex) {
        DBObjectId key = mdIndex.getKey();
        StringBuffer query = new StringBuffer("SELECT  md_connections.id connection_id , md_schemas.id schema_id , ").append(" md_schemas.name schema_name ").append(" FROM md_connections, md_catalogs, md_schemas, md_indexes, md_tables ").append(" WHERE md_indexes.id = " + key.getId()).append(" AND md_indexes.table_id_fk = md_tables.id ").append(" AND md_tables.schema_id_fk = md_schemas.id ").append(" AND md_schemas.catalog_id_fk = md_catalogs.id ").append(" AND md_catalogs.connection_id_fk = md_connections.id");
        this.handleMdQuery(mdIndex, query.toString(), MD_INDEX);
    }

    private void handleMdStoredProgramObject(MdStoredProgram storedProgram) {
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId schemaId = null;
        String schemaName = null;
        DBObjectId connectionId = null;
        try {
            MgvAllStoredProgramsRec storedProgramRec = PersistenceUtility.getInstance(persistenceManager).getStoredProgramForProgramId(storedProgram.getKey());
            if (storedProgramRec == null) {
                Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, "MigrationLogListener.STORED_PROG_FETCH_ERROR", storedProgram.getName());
                return;
            }
            schemaId = storedProgramRec.getSchemaId();
            schemaName = storedProgramRec.getSchemaName();
            connectionId = storedProgramRec.getConnectionId();
        }
        catch (PersistenceException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, "MigrationLogListener.PERSISTENCE_EXCEPTION", e);
            return;
        }
        List<URL> connectionURL = this.getURLSearchList(storedProgram, schemaId, schemaName, connectionId, MD_PROCEDURE);
        this.doTreeSelection(connectionId, persistenceManager, connectionURL);
    }

    private void handleMDTableObject(MdTable table) {
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId schemaId = null;
        String schemaName = null;
        DBObjectId connectionId = null;
        try {
            MgvAllTablesRec mgvAllTable = PersistenceUtility.getInstance(persistenceManager).getTablesForTableId(table.getKey());
            if (mgvAllTable == null) {
                Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, "MigrationLogListener.TABLE_FETCH_ERROR", table.getTableName());
                return;
            }
            schemaId = mgvAllTable.getSchemaId();
            schemaName = mgvAllTable.getSchemaName();
            connectionId = mgvAllTable.getConnectionId();
        }
        catch (PersistenceException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, "MigrationLogListener.PERSISTENCE_EXCEPTION", e);
            return;
        }
        List<URL> connectionURL = this.getURLSearchList(table, schemaId, schemaName, connectionId, MD_TABLE);
        this.doTreeSelection(connectionId, persistenceManager, connectionURL);
    }

    private void handleMDViewObject(MdView view) {
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId schemaId = null;
        String schemaName = null;
        DBObjectId connectionId = null;
        try {
            MgvAllViewsRec viewRec = PersistenceUtility.getInstance(persistenceManager).getViewRecordForViewId(view.getKey());
            if (viewRec == null) {
                Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, "MigrationLogListener.TABLE_FETCH_ERROR", view.getViewName());
                return;
            }
            schemaId = viewRec.getSchemaId();
            schemaName = viewRec.getSchemaName();
            connectionId = viewRec.getConnectionId();
        }
        catch (PersistenceException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, "MigrationLogListener.PERSISTENCE_EXCEPTION", e);
            return;
        }
        List<URL> connectionURL = this.getURLSearchList(view, schemaId, schemaName, connectionId, MD_VIEW);
        this.doTreeSelection(connectionId, persistenceManager, connectionURL);
    }

    private List<URL> getURLSearchList(PersistableObject pObject, DBObjectId schemaId, String schemaName, DBObjectId connectionId, String nodeType) {
        ArrayList<URL> connectionURL = new ArrayList<URL>();
        String urlString = MigrationAddin.getRepositoryConnectionName() + "/" + connectionId.getId();
        connectionURL.add(URLFactory.newURL((String)"sqldev.migration", (String)urlString));
        Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey((String)"", (String)MigrationAddin.getRepositoryConnectionName());
        urlString = connectionKey.getQualifiedName() + "//" + schemaId + "_" + DBURLFormatHelper.encode((String)schemaName);
        connectionURL.add(URLFactory.newURL((String)"sqldev.migration", (String)urlString));
        urlString = urlString + "/" + nodeType;
        connectionURL.add(URLFactory.newURL((String)"sqldev.migration", (String)urlString));
        urlString = urlString + "/" + pObject.getKey().getId() + "_" + DBURLFormatHelper.encode((String)pObject.getObjectName());
        connectionURL.add(URLFactory.newURL((String)"sqldev.migration", (String)urlString));
        return connectionURL;
    }

    private TreeExplorer getNavigatorInstance(DBObjectId connectionId, PersistenceManager persistenceManager) {
        TreeExplorer treeExplorer = CaptureRepositoryDatabaseManager.getInstance().getNavigatorWindow().getTreeExplorer();
        try {
            MdConnection connectionInstance = MdConnection.retrieveExistingInstance(persistenceManager, connectionId);
            if (TYPE_CONVERTED.equals(connectionInstance.getType())) {
                treeExplorer = ConvertedRepositoryDatabaseManager.getInstance().getNavigatorWindow().getTreeExplorer();
            }
        }
        catch (PersistenceException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, "MigrationLogListener.PERSISTENCE_EXCEPTION", e);
        }
        catch (NoSuchObjectException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, "MigrationLogListener.NOSUCHOBJECT_EXCEPTION", e);
        }
        return treeExplorer;
    }

    private void doTreeSelection(DBObjectId connectionId, PersistenceManager persistenceManager, List<URL> connectionURL) {
        TreeExplorer treeExplorer = this.getNavigatorInstance(connectionId, persistenceManager);
        ExplorerNode root = (ExplorerNode)treeExplorer.getRoot();
        if (treeExplorer != null) {
            String strLeafURLToSearch = connectionURL.get(connectionURL.size() - 1).toString();
            ExplorerNode foundTNode = this.searchNode(root, treeExplorer, connectionURL);
            if (foundTNode != null) {
                boolean isLeafNode;
                if (foundTNode.getData() instanceof ObjectFolder && MD_INDEX.equals(((ObjectFolder)foundTNode.getData()).getObjectType())) {
                    for (int i = 0; i < foundTNode.getChildCount(); ++i) {
                        ExplorerNode child = (ExplorerNode)foundTNode.getChildAt(i);
                        Object userObject = child.getUserObject();
                        if (!(userObject instanceof Locatable) || !((Locatable)userObject).getURL().toString().startsWith(strLeafURLToSearch)) continue;
                        foundTNode = child;
                        strLeafURLToSearch = ((Locatable)userObject).getURL().toString();
                    }
                }
                treeExplorer.setSelected((TNode)foundTNode);
                URL foundNodeURL = ((Locatable)foundTNode.getUserObject()).getURL();
                if (foundNodeURL != null && (isLeafNode = foundNodeURL.toString().equals(strLeafURLToSearch)) && foundTNode.getData() instanceof Node) {
                    final Node dbnode = (Node)foundTNode.getData();
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                        public void run() {
                            NavSelectionListener.getInstance().open(dbnode);
                        }
                    });
                }
            }
            treeExplorer.show();
            treeExplorer.activate();
        }
    }
}

