/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.logging;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.persistence.Migrlog;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

public final class MigrationLogPersistenceHandler
extends Handler {
    private static final int MAX_ASYNC_MESSAGES = 10;
    private static final int ASYNC_THREAD_SLEEP = 1000;
    private static MigrationLogPersistenceHandler s_self;
    private List<LogRecord> _asyncMessages = new ArrayList<LogRecord>(10);
    private Thread _updateThread = null;

    public static synchronized MigrationLogPersistenceHandler getInstance() {
        if (s_self == null) {
            s_self = new MigrationLogPersistenceHandler();
        }
        return s_self;
    }

    private MigrationLogPersistenceHandler() {
    }

    public void activateLogView() {
        if (this._updateThread == null) {
            this.startAsynchronousLogging();
        }
    }

    public void startAsynchronousLogging() {
        this._updateThread = new Thread("Log Persistance Updater"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (MigrationLogPersistenceHandler.this._updateThread == this) {
                    try {
                        Thread.sleep(1000L);
                        List list = MigrationLogPersistenceHandler.this._asyncMessages;
                        synchronized (list) {
                            if (MigrationLogPersistenceHandler.this._asyncMessages.size() > 0) {
                                MigrationLogPersistenceHandler.this.processAsyncMsgQueue(10);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        this._updateThread.setPriority(this._updateThread.getPriority() - 1);
        this._updateThread.start();
    }

    public void finishAsynchronousLogging() {
        this._updateThread = null;
        this.processAsyncMsgQueue(-1);
    }

    private void processAsyncMsgQueue(int max) {
        LogUpdater runner = new LogUpdater(max);
        new Thread(runner).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMsg(Object msg) {
        if (msg instanceof LogRecord) {
            List<LogRecord> list = this._asyncMessages;
            synchronized (list) {
                this._asyncMessages.add((LogRecord)msg);
                if (this._asyncMessages.size() == 10) {
                    this.processAsyncMsgQueue(10);
                }
            }
        }
    }

    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if (this._updateThread == null) {
            this.activateLogView();
        }
        this.logMsg(record);
    }

    public synchronized void flush() {
        while (this._updateThread != null && this._asyncMessages.size() != 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void close() {
        this.finishAsynchronousLogging();
    }

    private final class LogUpdater
    implements Runnable {
        private final int _max;
        private MigrationStorer _storer;

        private LogUpdater(int max) {
            this._max = max;
            this._storer = new BasicMigrationStorer(MigrationAddin.getLogPersistenceConnection());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insertLogRecursively(LogRecord logRecord, Formatter formatter, DBObjectId parentLogId) {
            Object sourceObject;
            Migrlog logObject = new Migrlog(new Timestamp(logRecord.getMillis()), logRecord.getLevel().intValue());
            DBObjectId currentLogId = null;
            List<LogInfo> logInfoList = MigrationLogUtil.searchParameterByType(logRecord.getParameters(), LogInfo.class);
            logObject.setParentLogId(parentLogId);
            String msg = MigrationLogPersistenceHandler.this.getFormatter() == null ? logRecord.getMessage() : MigrationLogPersistenceHandler.this.getFormatter().format(logRecord);
            logObject.setLogtext(msg);
            logObject.setPhase(this.getPhase(logRecord));
            logObject.setRefObjectId(null);
            logObject.setRefObjectType(null);
            if (logInfoList.size() > 0 && (sourceObject = logInfoList.get(0).getSourceObject()) instanceof PersistableObject) {
                PersistableObject persistableObject = (PersistableObject)sourceObject;
                logObject.setRefObjectId(persistableObject.getKey());
                logObject.setRefObjectType(persistableObject.getObjectType());
            }
            sourceObject = this._storer;
            synchronized (sourceObject) {
                try {
                    this._storer.storeObject(logObject);
                    currentLogId = logObject.getKey();
                }
                catch (PersistenceException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
            if (logInfoList.size() == 1) {
                for (LogRecord childRecord : logInfoList.get(0).getChildRecords()) {
                    this.insertLogRecursively(childRecord, formatter, currentLogId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this._storer == null) {
                return;
            }
            List list = MigrationLogPersistenceHandler.this._asyncMessages;
            synchronized (list) {
                int size = MigrationLogPersistenceHandler.this._asyncMessages.size();
                int num = this._max > 0 && size > this._max ? this._max : size;
                for (int i = 0; i < num; ++i) {
                    this.insertLogRecursively((LogRecord)MigrationLogPersistenceHandler.this._asyncMessages.remove(0), MigrationLogPersistenceHandler.this.getFormatter(), null);
                }
            }
        }

        private String getPhase(LogRecord logRecord) {
            List<LogInfo> logInfoParaList = MigrationLogUtil.searchParameterByType(logRecord.getParameters(), LogInfo.class);
            String sourceDisplayString = "";
            if (logInfoParaList.size() == 1) {
                sourceDisplayString = logInfoParaList.get(0).getSourceDisplayString();
                return sourceDisplayString;
            }
            return sourceDisplayString;
        }
    }
}

