/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.logging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.tree.TreePath;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationFileHandler;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogHandler;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogListener;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogPersistenceHandler;
import oracle.dbtools.migration.workbench.core.navigator.CaptureRepositoryDatabaseManager;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedRepositoryDatabaseManager;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationNavWindow;
import oracle.ide.model.Element;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.explorer.ExplorerNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigrationLogUtil {
    public static final String FILTER_KEY = "MigrationConnectionId";
    public static final String MIGRATIONLOG = "oracle.dbtools.migration";
    private static DBObjectId s_sessionConnectionId;

    private MigrationLogUtil() {
    }

    public static void registerLog() {
        Logger logger = Logger.getLogger(MIGRATIONLOG, "MigrationLogResourceBundle");
        MigrationLogHandler handler = MigrationLogHandler.getInstance();
        Vector<Level> acceptableLevels = new Vector<Level>();
        acceptableLevels.add(Level.ALL);
        Formatter formatter = new Formatter(){

            public synchronized String format(LogRecord record) {
                String formatedMessage = this.formatMessage(record);
                Object[] parameters = record.getParameters();
                List<LogInfo> logInfoList = MigrationLogUtil.searchParameterByType(parameters, LogInfo.class);
                if (logInfoList.size() == 0) {
                    logInfoList = new ArrayList<LogInfo>(1);
                    logInfoList.add(new LogInfo(""));
                    if (parameters == null) {
                        record.setParameters(logInfoList.toArray());
                    } else {
                        Object[] arrParams = new Object[parameters.length + 1];
                        System.arraycopy(parameters, 0, arrParams, 0, parameters.length);
                        arrParams[arrParams.length - 1] = logInfoList.get(0);
                        record.setParameters(arrParams);
                    }
                }
                if (logInfoList.size() > 0 && s_sessionConnectionId != null) {
                    logInfoList.get(0).addSupplementaryInfo(new Object[]{MigrationLogUtil.FILTER_KEY, s_sessionConnectionId});
                }
                return formatedMessage;
            }
        };
        handler.setFormatter(formatter);
        logger.addHandler(handler);
        handler.registerListener(new MigrationLogListener());
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.INFO);
        MigrationLogPersistenceHandler pHandler = MigrationLogPersistenceHandler.getInstance();
        pHandler.setFormatter(formatter);
        logger.addHandler(pHandler);
        try {
            MigrationFileHandler migrationFileHandler = new MigrationFileHandler();
            logger.addHandler(migrationFileHandler);
        }
        catch (SecurityException e) {
            Logger.getLogger(MigrationLogUtil.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (IOException e) {
            Logger.getLogger(MigrationLogUtil.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        ViewSelectionListener vsl = new ViewSelectionListener(){

            public void viewSelectionChanged(ViewSelectionEvent e) {
                ExplorerNode connectionNodePath;
                Element[] selections = e.getSelection();
                if (selections == null || selections.length == 0) {
                    return;
                }
                TreePath selectionPath = ((MigrationNavWindow)((Object)e.getSource())).getTreeExplorer().getJTree().getSelectionPath();
                if (selectionPath != null && selectionPath.getPathCount() > 1 && selectionPath.getPathComponent(1) instanceof ExplorerNode && (connectionNodePath = (ExplorerNode)selectionPath.getPathComponent(1)).getUserObject() instanceof MigrationConnectionNode) {
                    DBObjectId connectionId = ((MigrationConnectionNode)((Object)connectionNodePath.getUserObject())).getMdConnection().getKey();
                    MigrationLogHandler.getInstance().setFilterBy(connectionId);
                    return;
                }
                MigrationLogHandler.getInstance().setFilterBy(null);
            }
        };
        CaptureRepositoryDatabaseManager.getInstance().getNavigatorWindow().addViewSelectionListener(vsl);
        ConvertedRepositoryDatabaseManager.getInstance().getNavigatorWindow().addViewSelectionListener(vsl);
    }

    public static void logGroup(String groupMsg, Level groupLevel, String[] childMsgs) {
        if (groupMsg == null || childMsgs == null) {
            throw new IllegalArgumentException("Incorrent log parameters specified");
        }
        Logger logger = Logger.getLogger(MIGRATIONLOG);
        LogInfo childLogs = new LogInfo("");
        for (int i = 0; i < childMsgs.length; ++i) {
            LogRecord logRecord = new LogRecord(groupLevel, childMsgs[i]);
            logRecord.setLoggerName(logger.getName());
            childLogs.addChild(logRecord);
        }
        logger.log(Level.INFO, groupMsg, childLogs);
    }

    public static void logGroup(String groupMsg, String[] childMsgs, Level[] childLevels) {
        if (groupMsg == null || childMsgs == null) {
            throw new IllegalArgumentException("Incorrent log parameters specified");
        }
        Logger logger = Logger.getLogger(MIGRATIONLOG);
        Object[] arrParams = new Object[childMsgs.length];
        for (int i = 0; i < childMsgs.length; ++i) {
            LogRecord logRecord = new LogRecord(childLevels[i], childMsgs[i]);
            logRecord.setLoggerName(logger.getName());
            arrParams[i] = logRecord;
        }
        logger.log(Level.INFO, groupMsg, arrParams);
    }

    public static void logThrowable(String strMessage, String strLogSource, Throwable th) {
        MigrationLogUtil.logThrowable(strMessage, new Object[]{new LogInfo(strLogSource)}, th);
    }

    public static void logThrowable(String strMessage, Object[] arrParams, Throwable th) {
        Logger logger = Logger.getLogger(MIGRATIONLOG);
        LogRecord rec = new LogRecord(Level.SEVERE, strMessage);
        rec.setParameters(arrParams);
        rec.setThrown(th);
        rec.setLoggerName(logger.getName());
        rec.setResourceBundle(logger.getResourceBundle());
        logger.log(rec);
    }

    public static <T> List<T> searchParameterByType(Object[] objArray, Class<T> classToSearch) {
        if (objArray == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> searchResult = new ArrayList<Object>();
        for (Object param : objArray) {
            if (!classToSearch.isAssignableFrom(param.getClass())) continue;
            searchResult.add(param);
        }
        return searchResult;
    }

    public static synchronized void startMigrationLogSession(DBObjectId connectionId) {
        if (s_sessionConnectionId != null) {
            Logger.getLogger(MIGRATIONLOG).log(Level.WARNING, "Migration log session with id:" + s_sessionConnectionId + " was already started. Resetting to new session.");
        }
        s_sessionConnectionId = connectionId;
    }

    public static DBObjectId getCurrentSession() {
        return s_sessionConnectionId;
    }

    public static synchronized void endMigrationLogSession() {
        for (Handler handler : Logger.getLogger(MIGRATIONLOG).getHandlers()) {
            handler.flush();
        }
        s_sessionConnectionId = null;
    }
}

