/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.io.IOException;
import java.sql.Connection;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;

public class CapturedConnectionNode
extends MigrationConnectionNode {
    public CapturedConnectionNode(String label, String connectionName, MdConnection mdconnection) {
        super(label, connectionName, mdconnection);
        this.m_dict.put("IDCONNECTION", mdconnection.getKey().toString());
    }

    protected Connection openConnection() throws IOException {
        return CapturedDatabases.getInstance().getPersistenceManager().getConn();
    }

    protected void closeConnection() {
    }

    public String getConnType() {
        return "MIGREPO";
    }

    public String getSchemaName() {
        return "Captured Models";
    }

    public Icon getIcon() {
        MigrationPlugin plugin;
        String sPluginId;
        MdConnection mdConnection = this.getMdConnection();
        if (mdConnection != null && (sPluginId = mdConnection.getProperty("PLUGIN_ID")) != null && (plugin = MigrationAddin.findPlugin(sPluginId)) != null && plugin.getIcon() != null) {
            return plugin.getIcon();
        }
        return super.getIcon();
    }
}

