/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationRepositoryDatabases;

public final class CapturedDatabases
extends MigrationRepositoryDatabases {
    private static CapturedDatabases s_instance;

    public static synchronized CapturedDatabases getInstance() {
        if (s_instance == null) {
            s_instance = new CapturedDatabases();
        }
        return s_instance;
    }

    public String getShortLabel() {
        return MigrationAddinArb.getString(102);
    }

    protected CloseableIterator getMdConnectionsIterator() throws PersistenceException {
        return this.getUtility().getAllCapturedConnections();
    }

    protected MigrationConnectionNode createMdConnectionNode(String name, String connectionName, MdConnection mdconnection) {
        return new CapturedConnectionNode(name, connectionName, mdconnection);
    }

    public PersistenceManager getPersistenceManager() {
        return MigrationAddin.getCaptureExplorerConnection();
    }

    public Icon getIcon() {
        String sFileName = MigrationAddinArb.getString(0);
        if (sFileName == null) {
            return null;
        }
        URL imageUrl = this.getClass().getResource(sFileName);
        if (imageUrl == null) {
            return null;
        }
        try {
            ImageIcon imageIcon = new ImageIcon(imageUrl);
            return imageIcon;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

